package ai.benshi.android.sdk.e_commerce.impression_listener.sdk

import ai.benshi.android.sdk.e_commerce.event_models.RecyclerItemModel
import ai.benshi.android.sdk.e_commerce.impression_listener.ui.ImpressionThreshold
import android.app.Activity
import androidx.recyclerview.widget.RecyclerView

/**
 * Non-operational implementation of the [BshRecyclerInterface] interface; used when
 * `ClientConfig.loggingEnabled` is set to false, or when the SDK has not yet been initialized.
 */
@Suppress("TooManyFunctions", "EmptyFunctionBlock")
internal class NoOpSdk : BshRecyclerInterface {

    override fun onCollectionVisible(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String,
        model: List<RecyclerItemModel>
    ) {
    }

    override fun onCollectionUpdated(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String,
        model: List<RecyclerItemModel>
    ) {
    }

    override fun onCollectionHidden(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String
    ) {
    }

    override fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<RecyclerItemModel>,
        searchId: String,
        impressionThresholdBlock: (ImpressionThreshold.Builder.() -> Unit)?
    ) {
    }

    override fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<RecyclerItemModel>,
        searchId: String,
        impressionThreshold: ImpressionThreshold
    ) {
    }

    override fun shutdown() {}
}
