package ai.benshi.android.sdk.e_commerce.impression_listerner

import ai.benshi.android.sdk.core.BenshiLog
import ai.benshi.android.sdk.core.impression_listener.BshCoreImpressionListener
import ai.benshi.android.sdk.core.impression_listener.impression_model.RecyclerImpressionModel
import ai.benshi.android.sdk.core.utils.CoreConstants
import ai.benshi.android.sdk.core.utils.ExceptionManager
import ai.benshi.android.sdk.e_commerce.catalog_models.DrugCatalogModel
import ai.benshi.android.sdk.e_commerce.catalog_models.internal_catalog_models.InternalDrugModel
import ai.benshi.android.sdk.e_commerce.event_models.InternalCurrencyCode
import ai.benshi.android.sdk.e_commerce.event_models.ViewItemObject
import ai.benshi.android.sdk.e_commerce.event_types.EComEventType
import ai.benshi.android.sdk.e_commerce.event_types.ItemAction
import ai.benshi.android.sdk.e_commerce.impression_listerner.event_model.ItemImpressionModel
import ai.benshi.android.sdk.e_commerce.utils.ECommerceConstants
import androidx.recyclerview.widget.RecyclerView

object BshItemImpressionListener {

    private var usdRateValue : Float = 1f
    private lateinit var recyclerViewValue : RecyclerView
    private lateinit var currentDataProviderValue: List<ItemImpressionModel>
    private var searchIdValue: String = ""
    private var collectionViewId: String = ""

    @JvmStatic
    fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<ItemImpressionModel>,
        searchId: String) {

        recyclerViewValue = recyclerView
        currentDataProviderValue = currentDataProvider()
        searchIdValue = searchId

        if (currentDataProvider()[0].itemProperties.currency != InternalCurrencyCode.USD.name) {
            BenshiLog().getUSDRate(CoreConstants.context!!, currentDataProvider()[0].itemProperties.currency, ::getUSDRateAndLogEvent)
        }else{
            callCoreImpressionListener()
        }

    }

    private fun callCoreImpressionListener() {
        BshCoreImpressionListener.trackRecyclerView(recyclerViewValue, currentDataProvider = {
            currentDataProviderValue.map {
                RecyclerImpressionModel(
                    elementId = it.itemProperties.id,
                    contentBlock = ECommerceConstants.contentBlockName,
                    eventName = EComEventType.item.name,
                    itemProperties = ViewItemObject(ItemAction.impression.name,
                        it.itemProperties, searchIdValue, usdRateValue, null),
                    catalogProperties = prepareCatalogObject(it.itemProperties.id,
                        it.catalogProperties)
                )
            }
        }, searchIdValue, null)
    }

    private fun getUSDRateAndLogEvent(usdRate : Float){
        usdRateValue = usdRate
        callCoreImpressionListener()
    }

    private fun prepareCatalogObject(itemId : String, drugCatalogModel: DrugCatalogModel) : InternalDrugModel {
        when {
            drugCatalogModel.supplier_id.isNullOrEmpty() -> {
                ExceptionManager.throwIsRequiredException("supplier_id")
            }
            drugCatalogModel.supplier_name.isNullOrEmpty() -> {
                ExceptionManager.throwIsRequiredException("supplier_name")
            }
            drugCatalogModel.active_ingredients.isNullOrEmpty() -> {
                ExceptionManager.throwIsRequiredException("active_ingredients")
            }
            drugCatalogModel.market_id.isNullOrEmpty() -> {
                ExceptionManager.throwIsRequiredException("market_id")
            }
        }
        val activeIngredients =
            drugCatalogModel.active_ingredients!!.joinToString(separator = "|·|")

        return InternalDrugModel(
            id = itemId,
            name = CoreConstants.checkIfNull(drugCatalogModel.name),
            market_id = CoreConstants.checkIfNull(drugCatalogModel.market_id),
            description = CoreConstants.checkIfNull(drugCatalogModel.description),
            supplier_id = CoreConstants.checkIfNull(drugCatalogModel.supplier_id),
            supplier_name = CoreConstants.checkIfNull(drugCatalogModel.supplier_name),
            producer = CoreConstants.checkIfNull(drugCatalogModel.producer),
            packaging = CoreConstants.checkIfNull(drugCatalogModel.packaging),
            active_ingredients = CoreConstants.checkIfNull(activeIngredients),
            drug_form = CoreConstants.checkIfNull(drugCatalogModel.drug_form),
            drug_strength = CoreConstants.checkIfNull(drugCatalogModel.drug_strength),
            atc_anatomical_group = CoreConstants.checkIfNull(drugCatalogModel.ATC_anatomical_group),
            otc_or_ethical = CoreConstants.checkIfNull(drugCatalogModel.OTC_or_ethical)
        )
    }

    interface CurrentDataProvider {
        fun provideCurrentData(): List<ItemImpressionModel>
    }

    @JvmStatic
    fun startTrackingForJavaClass(
        recyclerView: RecyclerView,
        currentDataProvider: CurrentDataProvider,
        searchId: String
    ) {
        trackRecyclerView(
            recyclerView,
            currentDataProvider::provideCurrentData,
            searchId
        )
    }

    @JvmStatic
    fun onCollectionUpdated(
        collectionViewKey: String,
        searchId: String,
        currentDataProvider: List<ItemImpressionModel>
    ) {

        currentDataProviderValue = currentDataProvider
        searchIdValue = searchId
        collectionViewId = collectionViewKey

        if (currentDataProvider[0].itemProperties.currency != InternalCurrencyCode.USD.name) {
            BenshiLog().getUSDRate(CoreConstants.context!!, currentDataProvider[0].itemProperties.currency, ::getUSDRateAndLogRNEvent)
        }else{
            callCoreCollectionUpdated()
        }
    }

    private fun getUSDRateAndLogRNEvent(usdRate : Float){
        usdRateValue = usdRate
        callCoreCollectionUpdated()
    }

    private fun callCoreCollectionUpdated(){
        BshCoreImpressionListener.onCollectionUpdated(null, collectionViewId,
            searchIdValue, currentDataProviderValue.map {
                RecyclerImpressionModel(
                    elementId = it.itemProperties.id,
                    contentBlock = ECommerceConstants.contentBlockName,
                    eventName = EComEventType.item.name,
                    itemProperties = ViewItemObject(ItemAction.impression.name,
                        it.itemProperties, searchIdValue, usdRateValue, null),
                    catalogProperties = prepareCatalogObject(it.itemProperties.id,
                        it.catalogProperties)
                )
            })
    }

}