package ai.benshi.android.sdk.e_commerce.utils

import ai.benshi.android.sdk.core.utils.CoreConstants
import ai.benshi.android.sdk.core.utils.ExceptionManager
import ai.benshi.android.sdk.e_commerce.event_models.InternalCurrencyCode
import ai.benshi.android.sdk.e_commerce.event_models.ItemModel
import ai.benshi.android.sdk.e_commerce.event_types.ItemStockStatus
import ai.benshi.android.sdk.e_commerce.event_types.ItemType
import java.text.SimpleDateFormat
import java.util.*

class ECommerceConstants {
    companion object {
        // SDK API endpoints
        const val contentBlockName: String = "e-commerce"

        fun getDateTime(milliSeconds: Long): String {
            // Create a DateFormatter object for displaying date in specified format.
            val sdf = SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZZZZZ", Locale.ENGLISH)
            // Create a calendar object that will convert the date and time value in milliseconds to date.
            val calendar: Calendar = Calendar.getInstance()
            calendar.timeInMillis = milliSeconds
            return sdf.format(calendar.time)
        }

        fun isItemValueObjectValid(itemValue : ItemModel){
            if (itemValue.id.isNullOrEmpty()){
                ExceptionManager.throwIsRequiredException("item_id")
            }
            else if (itemValue.quantity < 0) {
                ExceptionManager.throwItemQuantityException()
            }
            else if(itemValue.price == null){
                ExceptionManager.throwIsRequiredException("item_price")
            }
            else if (itemValue.currency.isNullOrEmpty()){
                ExceptionManager.throwIsRequiredException("item_currency")
            }
            else if (!CoreConstants.enumContains<InternalCurrencyCode>(itemValue.currency)) {
                ExceptionManager.throwEnumException("CurrencyCode")
            }
            else if (itemValue.type.isNullOrEmpty()){
                ExceptionManager.throwIsRequiredException("item_type")
            }
            else if (!CoreConstants.enumContains<ItemType>(itemValue.type)) {
                ExceptionManager.throwEnumException("ItemType")
            }
        }

    }
}
