package ai.benshi.android.sdk.e_commerce.utils.impression_listener.di

import ai.benshi.android.sdk.e_commerce.utils.impression_listener.ClientConfig
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.trackers.TrackCollectionsUseCase
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.trackers.TrackRecyclerViewUseCase
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.sdk.DefaultSdk
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.sdk.BshRecyclerInterface
import android.content.Context
import android.content.SharedPreferences
import org.koin.core.module.Module
import org.koin.dsl.module

/**
 * The default [ConfigurableKoinComponent] used at runtime of the library. Knows how to provide
 * all library dependencies taking the [ClientConfig] into account.
 */
internal object DefaultKoinComponent : ConfigurableKoinComponent() {
    override fun buildModules(config: ClientConfig?): List<Module> = listOf(
        module {
            single { config }
            single<BshRecyclerInterface> {
                DefaultSdk(
                    get(),
                    get()
                )
            }
            single { TrackCollectionsUseCase() }
            single { TrackRecyclerViewUseCase(get()) }
            factory { getPromotedAiPrefs(get()) }
        }
    )

    private fun getPromotedAiPrefs(context: Context): SharedPreferences =
        context.getSharedPreferences("ai.promoted.prefs", Context.MODE_PRIVATE)
}
