package ai.benshi.android.sdk.e_commerce.utils.impression_listener.sdk

import ai.benshi.android.sdk.e_commerce.event_models.ItemModel
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.ui.ImpressionThreshold
import android.app.Activity
import android.content.Context
import androidx.recyclerview.widget.RecyclerView

/**
 * The public-facing API for interacting with Promoted.Ai. Instances are managed internally by
 * the SDK.
 */
internal interface BshRecyclerInterface {

    fun onCollectionVisible(
        sourceActivity: Activity?,
        collectionViewKey: String,
        model: List<ItemModel>
    )

    fun onCollectionUpdated(
        sourceActivity: Activity?,
        collectionViewKey: String,
        model: List<ItemModel>
    )

    fun onCollectionHidden(
        sourceActivity: Activity?,
        collectionViewKey: String
    )

    fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<ItemModel>,
        impressionThresholdBlock: (ImpressionThreshold.Builder.() -> Unit)? = null
    )

    fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<ItemModel>,
        impressionThreshold: ImpressionThreshold
    )

    fun shutdown()
}
