package ai.benshi.android.sdk.payments.currency_exchange

import ai.benshi.android.sdk.core.BenshiLog
import ai.benshi.android.sdk.core.retrofit.models.CurrencyMainObject
import ai.benshi.android.sdk.core.retrofit.models.CurrencyObject
import ai.benshi.android.sdk.core.retrofit.data.PaperObject
import ai.benshi.android.sdk.core.utils.CoreConstants
import ai.benshi.android.sdk.payments.event_models.DeferredPaymentObject
import ai.benshi.android.sdk.payments.event_types.PaymentsEventType
import ai.benshi.android.sdk.payments.utils.PaymentsConstants
import android.content.Context
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.text.SimpleDateFormat
import java.util.*

/**
 * Created by Moiz Hassan on 17, March,2021
 */

internal class CurrencyAPIHandler : PaymentsLogInterface {

    fun initInterface() {
        PaymentsLog.paymentsLogInterface = this
    }

    override fun getPrice(
        context: Context?,
        fromCurrency: String,
        eventType: String,
        itemObject: Any?,
        updateImmediately: Boolean
    ) {

        val currencyObject: CurrencyMainObject? = PaperObject.readCurrencyObject()

        if (currencyObject != null) {
            val sdf = SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH)
            if (currencyObject.fromCurrency == fromCurrency &&
                (currencyObject.toCurrencyObject?.date == sdf.format(Calendar.getInstance().time) ||
                        CoreConstants.isAgainRate)
            ) {
                checkAndAddUserValues(
                    context, currencyObject,
                    eventType, itemObject, updateImmediately
                )
            } else {
                callCurrencyApi(
                    context, fromCurrency,
                    eventType, itemObject, updateImmediately
                )
            }
        } else {
            callCurrencyApi(
                context, fromCurrency,
                eventType, itemObject, updateImmediately
            )
        }
        CoreConstants.isAgainRate = true
    }

    private fun checkAndAddUserValues(
        context: Context?,
        currencyObject: CurrencyMainObject,
        eventType: String,
        itemObject: Any?,
        updateImmediately: Boolean
    ) {

        when (eventType) {
            PaymentsEventType.deferred_payments.name -> {
                val iObject = itemObject as DeferredPaymentObject
                iObject.usd_rate = currencyObject.toCurrencyObject?.usd

                BenshiLog.track(
                    context!!, PaymentsConstants.contentBlockName, eventType,
                    iObject, updateImmediately
                )
            }
        }
    }

    private fun callCurrencyApi(
        context: Context?,
        fromCurrency: String,
        eventType: String,
        itemObject: Any?,
        updateImmediately: Boolean
    ) {
        val apiInterface: CurrencyAPIInterface = CurrencyAPIClient.getClient()
            .create(CurrencyAPIInterface::class.java)

        val call: Call<CurrencyObject> = apiInterface.getUsdRate(CoreConstants.sdkKey, fromCurrency)
        call.enqueue(object : Callback<CurrencyObject> {
            override fun onResponse(
                call: Call<CurrencyObject>,
                response: Response<CurrencyObject>
            ) {
                if (response.isSuccessful) {
                    val currencyObject = CurrencyMainObject(fromCurrency, response.body())
                    checkAndAddUserValues(
                        context, currencyObject,
                        eventType, itemObject, updateImmediately
                    )

                    PaperObject.writeCurrencyObject(currencyObject)
                } else {
                    BenshiLog.track(
                        context!!, PaymentsConstants.contentBlockName, eventType,
                        itemObject, updateImmediately
                    )
                }
            }

            override fun onFailure(call: Call<CurrencyObject>, throwable: Throwable) {
                call.cancel()
                BenshiLog.track(
                    context!!, PaymentsConstants.contentBlockName, eventType,
                    itemObject, updateImmediately
                )
            }
        })
    }
}
