/*
 * Decompiled with CFR 0.152.
 */
package ai.berktest;

import ai.berktest.Berk;
import ai.berktest.BerkResponse;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.File;
import java.util.HashMap;
import org.openqa.selenium.WebDriver;

public class BerkRequest
extends Berk {
    String workingDir = System.getProperty("user.dir");
    String relativePath = "screenshot.png";
    String fullPath = this.workingDir + File.separator + this.relativePath;
    WebDriver driver;

    public BerkRequest(WebDriver appiumDriver) {
        this.driver = appiumDriver;
    }

    public BerkResponse getCoordinates(String elementPath, int deviceScreenWidth, int deviceScreenHeight) {
        String elementFullPath = this.workingDir + File.separator + elementPath;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("screenshot_path", this.fullPath);
        data.put("element_path", elementFullPath);
        data.put("deviceScreenWidth", deviceScreenWidth);
        data.put("deviceScreenHeight", deviceScreenHeight);
        data.put("image_exif", "true");
        BerkResponse coordinateResponse = (BerkResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(data).post(this.getHost() + this.getPort() + "/get-coordinates", new Object[0])).as(BerkResponse.class);
        return coordinateResponse;
    }

    public String getText(String elementPath, int deviceScreenWidth, int deviceScreenHeight) {
        String elementFullPath = this.workingDir + File.separator + elementPath;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("screenshot_path", this.fullPath);
        data.put("element_path", elementFullPath);
        data.put("deviceScreenWidth", deviceScreenWidth);
        data.put("deviceScreenHeight", deviceScreenHeight);
        data.put("image_exif", "true");
        BerkResponse coordinateResponse = (BerkResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(data).post(this.getHost() + this.getPort() + "/get-text", new Object[0])).as(BerkResponse.class);
        if ("success".equals(coordinateResponse.getStatus())) {
            return coordinateResponse.getText();
        }
        return null;
    }
}

