/*
 * Decompiled with CFR 0.152.
 */
package ai.berktest;

import ai.berktest.BerkRequest;
import ai.berktest.BerkResponse;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.touch.offset.PointOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class Berk {
    String port = "5003";
    String host = "http://0.0.0.0:";
    WebDriver driver;

    public Berk(WebDriver driver, String host, String port) {
        this.port = port;
        this.host = host;
        this.driver = driver;
    }

    public Berk() {
    }

    public Berk(String host) {
        this.host = host;
    }

    public Berk(WebDriver driver) {
        this.driver = driver;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public List<Integer> getCenterCoordinates(WebDriver driver, String elementPath, int waitTimeSecond) throws IOException {
        Dimension screenSize = driver.manage().window().getSize();
        int deviceScreenWidth = screenSize.width;
        int deviceScreenHeight = screenSize.height;
        ArrayList<Integer> centerPoint = new ArrayList<Integer>();
        BerkRequest berkRequest = new BerkRequest(driver);
        this.isElementDisplayed(driver, elementPath, waitTimeSecond);
        BerkResponse response = berkRequest.getCoordinates(elementPath, deviceScreenWidth, deviceScreenHeight);
        centerPoint.add(response.getCenterX());
        centerPoint.add(response.getCenterY());
        return centerPoint;
    }

    public List<Integer> getCenterCoordinates(WebDriver driver, String elementPath) throws IOException {
        return this.getCenterCoordinates(driver, elementPath, 90);
    }

    public boolean waitUntilElementDisplayed(WebDriver driver, String elementPath) throws IOException {
        return this.waitUntilElementDisplayed(driver, elementPath, 90);
    }

    public boolean waitUntilElementDisplayed(WebDriver driver, String elementPath, int waitTime) throws IOException {
        return this.isElementDisplayed(driver, elementPath, waitTime);
    }

    public Boolean isElementDisplayed(WebDriver driver, String elementPath, int waitTimeSecond) throws IOException {
        this.takeScreenshot(driver);
        Dimension screenSize = driver.manage().window().getSize();
        int deviceScreenWidth = screenSize.width;
        int deviceScreenHeight = screenSize.height;
        int count = 0;
        BerkRequest coordinateRequest = new BerkRequest(driver);
        BerkResponse coordinateResponse = coordinateRequest.getCoordinates(elementPath, deviceScreenWidth, deviceScreenHeight);
        Instant currentTime = Instant.now();
        LocalTime waitTime = LocalTime.now().plusSeconds(waitTimeSecond);
        while (!coordinateResponse.getStatus().equals("success") && waitTime.isAfter(LocalTime.now())) {
            this.takeScreenshot(driver);
            Path path = Paths.get(elementPath, new String[0]);
            String fileName = path.getFileName().toString();
            coordinateResponse = coordinateRequest.getCoordinates(elementPath, deviceScreenWidth, deviceScreenHeight);
            System.out.println(count + 2 + ". try " + fileName + (coordinateResponse.getStatus().equals("error") ? " not found" : " found"));
            ++count;
        }
        Instant endTime = Instant.now();
        Duration duration = Duration.between(currentTime, endTime);
        Path path = Paths.get(elementPath, new String[0]);
        String fileName = path.getFileName().toString();
        System.out.println(fileName + " :  found in " + duration.getSeconds() + " second");
        return coordinateResponse.getStatus().equals("success");
    }

    public Map<Boolean, BerkResponse> ifElementDisplayedGetCoordinates(WebDriver driver, String elementPath, int waitTimeSecond) throws IOException {
        this.takeScreenshot(driver);
        Dimension screenSize = driver.manage().window().getSize();
        int deviceScreenWidth = screenSize.width;
        int deviceScreenHeight = screenSize.height;
        int count = 0;
        HashMap<Boolean, BerkResponse> result = new HashMap<Boolean, BerkResponse>();
        BerkRequest coordinateRequest = new BerkRequest(driver);
        BerkResponse coordinateResponse = coordinateRequest.getCoordinates(elementPath, deviceScreenWidth, deviceScreenHeight);
        Instant currentTime = Instant.now();
        LocalTime waitTime = LocalTime.now().plusSeconds(waitTimeSecond);
        while (!coordinateResponse.getStatus().equals("success") && waitTime.isAfter(LocalTime.now())) {
            this.takeScreenshot(driver);
            Path path = Paths.get(elementPath, new String[0]);
            String fileName = path.getFileName().toString();
            coordinateResponse = coordinateRequest.getCoordinates(elementPath, deviceScreenWidth, deviceScreenHeight);
            System.out.println(count + 2 + ". try " + fileName + (coordinateResponse.getStatus().equals("error") ? " not found" : " found"));
            ++count;
        }
        Instant endTime = Instant.now();
        Duration duration = Duration.between(currentTime, endTime);
        Path path = Paths.get(elementPath, new String[0]);
        String fileName = path.getFileName().toString();
        if (coordinateResponse.getStatus().equals("success")) {
            result.put(true, coordinateResponse);
        } else {
            result.put(false, coordinateResponse);
        }
        return result;
    }

    public void click(WebDriver driver, String elementName, int waitTime) throws IOException {
        this.takeScreenshot(driver);
        Map<Boolean, BerkResponse> coordinateResponse = this.ifElementDisplayedGetCoordinates(driver, elementName, waitTime);
        if (!coordinateResponse.containsKey(true)) {
            throw new NoSuchElementException(elementName + " is not available");
        }
        BerkResponse response = coordinateResponse.get(true);
        int coordinate_X = response.getCenterX();
        int coordinate_Y = response.getCenterY();
        TouchAction touchAction = new TouchAction((PerformsTouchActions)((AppiumDriver)driver));
        touchAction.tap(PointOption.point((int)coordinate_X, (int)coordinate_Y)).perform();
    }

    public void takeScreenshot(WebDriver driver) throws IOException {
        byte[] screenshotBytes = (byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES);
        File targetFile = new File("screenshot.png");
        FileUtils.writeByteArrayToFile((File)targetFile, (byte[])screenshotBytes);
    }

    public void scrollUntilElementDisplayed(WebDriver driver, String elementPath) throws IOException {
        Dimension screenSize = driver.manage().window().getSize();
        int deviceScreenWidth = screenSize.width;
        int deviceScreenHeight = screenSize.height;
        while (!this.isElementDisplayed(driver, elementPath, 1).booleanValue()) {
            TouchAction touchAction = new TouchAction((PerformsTouchActions)((AppiumDriver)driver));
            touchAction.press(PointOption.point((int)(deviceScreenWidth / 2), (int)(deviceScreenHeight / 2))).waitAction().moveTo(PointOption.point((int)(deviceScreenWidth / 2), (int)(deviceScreenHeight / 4))).release().perform();
        }
    }

    public void sendKeys(AppiumDriver driver, String elementPath, String text, int waitTime) throws IOException {
        this.takeScreenshot((WebDriver)driver);
        Map<Boolean, BerkResponse> coordinateResponse = this.ifElementDisplayedGetCoordinates((WebDriver)driver, elementPath, waitTime);
        if (!coordinateResponse.containsKey(true)) {
            throw new NoSuchElementException(elementPath + " is not available");
        }
        BerkResponse response = coordinateResponse.get(true);
        int x = response.getCenterX();
        int y = response.getCenterY();
        TouchAction touchAction = new TouchAction((PerformsTouchActions)driver);
        touchAction.tap(PointOption.point((int)x, (int)y)).perform();
        driver.getKeyboard().sendKeys(new CharSequence[]{text});
    }

    public String getText(WebDriver driver, String elementName, int waitTime) throws IOException {
        this.takeScreenshot(driver);
        String text = "";
        Map<Boolean, BerkResponse> berkResponse = this.ifElementDisplayedGetCoordinates(driver, elementName, waitTime);
        if (!berkResponse.containsKey(true)) {
            throw new NoSuchElementException(elementName + " is not available");
        }
        BerkResponse response = berkResponse.get(true);
        text = response.getText();
        return text;
    }

    public Map<Boolean, BerkResponse> ifElementDisplayedGetText(WebDriver driver, String elementPath, int waitTimeSecond) throws IOException {
        this.takeScreenshot(driver);
        Dimension screenSize = driver.manage().window().getSize();
        int deviceScreenWidth = screenSize.width;
        int deviceScreenHeight = screenSize.height;
        int count = 0;
        HashMap<Boolean, BerkResponse> result = new HashMap<Boolean, BerkResponse>();
        BerkRequest berkRequest = new BerkRequest(driver);
        BerkResponse berkResponse = berkRequest.getCoordinates(elementPath, deviceScreenWidth, deviceScreenHeight);
        Instant currentTime = Instant.now();
        LocalTime waitTime = LocalTime.now().plusSeconds(waitTimeSecond);
        while (!berkResponse.getStatus().equals("success") && waitTime.isAfter(LocalTime.now())) {
            this.takeScreenshot(driver);
            Path path = Paths.get(elementPath, new String[0]);
            String fileName = path.getFileName().toString();
            berkResponse = berkRequest.getCoordinates(elementPath, deviceScreenWidth, deviceScreenHeight);
            ++count;
        }
        Instant endTime = Instant.now();
        Duration duration = Duration.between(currentTime, endTime);
        Path path = Paths.get(elementPath, new String[0]);
        String fileName = path.getFileName().toString();
        if (berkResponse.getStatus().equals("success")) {
            result.put(true, berkResponse);
        } else {
            result.put(false, berkResponse);
        }
        return result;
    }
}

