/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost;

import ai.catboost.CatBoostError;
import ai.catboost.CatBoostPredictions;
import ai.catboost.NativeLib;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class CatBoostModel
implements AutoCloseable {
    private long handle = 0L;
    private int predictionDimension = 0;
    private int treeCount = 0;
    private int usedNumericFeatureCount = 0;
    private int usedCategoricFeatureCount = 0;

    @NotNull
    public static CatBoostModel loadModel(@NotNull String modelPath) throws CatBoostError {
        long[] handles = new long[1];
        int[] predictionDimension = new int[1];
        int[] treeCount = new int[1];
        int[] usedNumericFeatureCount = new int[1];
        int[] usedCatFeatureCount = new int[1];
        CatBoostModel model = new CatBoostModel();
        NativeLib.handle().catBoostLoadModelFromFile(modelPath, handles);
        model.handle = handles[0];
        try {
            NativeLib.handle().catBoostModelGetPredictionDimension(model.handle, predictionDimension);
            NativeLib.handle().catBoostModelGetTreeCount(model.handle, treeCount);
            NativeLib.handle().catBoostModelGetUsedNumericFeatureCount(model.handle, usedNumericFeatureCount);
            NativeLib.handle().catBoostModelGetUsedCategoricalFeatureCount(model.handle, usedCatFeatureCount);
        }
        catch (CatBoostError e) {
            model.close();
            throw e;
        }
        model.predictionDimension = predictionDimension[0];
        model.treeCount = treeCount[0];
        model.usedNumericFeatureCount = usedNumericFeatureCount[0];
        model.usedCategoricFeatureCount = usedCatFeatureCount[0];
        return model;
    }

    @NotNull
    public static CatBoostModel loadModel(InputStream in) throws CatBoostError, IOException {
        int bytesRead;
        long[] handles = new long[1];
        int[] predictionDimension = new int[1];
        int[] treeCount = new int[1];
        int[] usedNumericFeatureCount = new int[1];
        int[] usedCatFeatureCount = new int[1];
        byte[] copyBuffer = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((bytesRead = in.read(copyBuffer)) != -1) {
            out.write(copyBuffer, 0, bytesRead);
        }
        CatBoostModel model = new CatBoostModel();
        NativeLib.handle().catBoostLoadModelFromArray(out.toByteArray(), handles);
        model.handle = handles[0];
        try {
            NativeLib.handle().catBoostModelGetPredictionDimension(model.handle, predictionDimension);
            NativeLib.handle().catBoostModelGetTreeCount(model.handle, treeCount);
            NativeLib.handle().catBoostModelGetUsedNumericFeatureCount(model.handle, usedNumericFeatureCount);
            NativeLib.handle().catBoostModelGetUsedCategoricalFeatureCount(model.handle, usedCatFeatureCount);
        }
        catch (CatBoostError e) {
            model.close();
            throw e;
        }
        model.predictionDimension = predictionDimension[0];
        model.treeCount = treeCount[0];
        model.usedNumericFeatureCount = usedNumericFeatureCount[0];
        model.usedCategoricFeatureCount = usedCatFeatureCount[0];
        return model;
    }

    static int hashCategoricalFeature(@NotNull String catFeature) throws CatBoostError {
        int[] hash = new int[1];
        NativeLib.handle().catBoostHashCatFeature(catFeature, hash);
        return hash[0];
    }

    static void hashCategoricalFeatures(@NotNull String[] catFeatures, @NotNull int[] hashes) throws CatBoostError {
        NativeLib.handle().catBoostHashCatFeatures(catFeatures, hashes);
    }

    @NotNull
    static int[] hashCategoricalFeatures(@NotNull String[] catFeatures) throws CatBoostError {
        int[] hashes = new int[catFeatures.length];
        CatBoostModel.hashCategoricalFeatures(catFeatures, hashes);
        return hashes;
    }

    public int getPredictionDimension() {
        return this.predictionDimension;
    }

    public int getTreeCount() {
        return this.treeCount;
    }

    public int getUsedNumericFeatureCount() {
        return this.usedNumericFeatureCount;
    }

    public int getUsedCategoricFeatureCount() {
        return this.usedCategoricFeatureCount;
    }

    public void predict(@Nullable float[] numericFeatures, @Nullable String[] catFeatures, @NotNull CatBoostPredictions prediction) throws CatBoostError {
        NativeLib.handle().catBoostModelPredict(this.handle, numericFeatures, catFeatures, prediction.getRawData());
    }

    @NotNull
    public CatBoostPredictions predict(@Nullable float[] numericFeatures, @Nullable String[] catFeatures) throws CatBoostError {
        CatBoostPredictions prediction = new CatBoostPredictions(1, this.getPredictionDimension());
        this.predict(numericFeatures, catFeatures, prediction);
        return prediction;
    }

    public void predict(@Nullable float[] numericFeatures, @Nullable int[] catFeatureHashes, @NotNull CatBoostPredictions prediction) throws CatBoostError {
        NativeLib.handle().catBoostModelPredict(this.handle, numericFeatures, catFeatureHashes, prediction.getRawData());
    }

    @NotNull
    public CatBoostPredictions predict(@Nullable float[] numericFeatures, @Nullable int[] catFeatureHashes) throws CatBoostError {
        CatBoostPredictions prediction = new CatBoostPredictions(1, this.getPredictionDimension());
        this.predict(numericFeatures, catFeatureHashes, prediction);
        return prediction;
    }

    public void predict(@Nullable float[][] numericFeatures, @Nullable String[][] catFeatures, @NotNull CatBoostPredictions prediction) throws CatBoostError {
        NativeLib.handle().catBoostModelPredict(this.handle, numericFeatures, catFeatures, prediction.getRawData());
    }

    @NotNull
    public CatBoostPredictions predict(@Nullable float[][] numericFeatures, @Nullable String[][] catFeatures) throws CatBoostError {
        if (numericFeatures == null && catFeatures == null) {
            throw new CatBoostError("both arguments are null");
        }
        CatBoostPredictions prediction = new CatBoostPredictions(numericFeatures == null ? catFeatures.length : numericFeatures.length, this.getPredictionDimension());
        this.predict(numericFeatures, catFeatures, prediction);
        return prediction;
    }

    public void predict(@Nullable float[][] numericFeatures, @Nullable int[][] catFeatureHashes, @NotNull CatBoostPredictions prediction) throws CatBoostError {
        NativeLib.handle().catBoostModelPredict(this.handle, numericFeatures, catFeatureHashes, prediction.getRawData());
    }

    @NotNull
    public CatBoostPredictions predict(@Nullable float[][] numericFeatures, @Nullable int[][] catFeatureHashes) throws CatBoostError {
        if (numericFeatures == null && catFeatureHashes == null) {
            throw new CatBoostError("both arguments are null");
        }
        CatBoostPredictions prediction = new CatBoostPredictions(numericFeatures == null ? catFeatureHashes.length : numericFeatures.length, this.getPredictionDimension());
        this.predict(numericFeatures, catFeatureHashes, prediction);
        return prediction;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private synchronized void dispose() throws CatBoostError {
        if (this.handle != 0L) {
            NativeLib.handle().catBoostFreeModel(this.handle);
            this.handle = 0L;
        }
    }

    @Override
    public void close() throws CatBoostError {
        this.dispose();
    }
}

