/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost;

import ai.catboost.CatBoostJNI;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeLib {
    private static final Logger logger = LoggerFactory.getLogger(NativeLib.class);
    private static final String nativeLibDirectory = "../lib";

    NativeLib() {
    }

    @NotNull
    public static CatBoostJNI handle() {
        return SingletonHolder.catBoostJNI;
    }

    private static void smartLoad(@NotNull String libName) throws IOException {
        NativeLib.addDirectoryToNativeLibSearchList(nativeLibDirectory);
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            logger.debug(e.getMessage());
            try {
                NativeLib.loadNativeLibraryFromJar(libName);
            }
            catch (IOException ioe) {
                logger.error("failed to load native library from both default location and JAR");
                throw ioe;
            }
        }
    }

    @NotNull
    private static String getCurrentMachineResourcesDir() {
        String osName;
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch.equals("amd64")) {
            osArch = "x86_64";
        }
        if ((osName = System.getProperty("os.name").toLowerCase()).contains("mac")) {
            osName = "darwin";
        } else if (osName.contains("win")) {
            osName = "win32";
        }
        return osName + "-" + osArch;
    }

    private static void loadNativeLibraryFromJar(@NotNull String libName) throws IOException {
        String pathWithinJar = "/" + NativeLib.getCurrentMachineResourcesDir() + "/lib/" + System.mapLibraryName(libName);
        String tempLibPath = NativeLib.createTemporaryFileFromJar(pathWithinJar);
        System.load(tempLibPath);
    }

    private static void copyFileFromJar(@NotNull String pathWithinJar, @NotNull String pathOnDisk) throws IOException {
        byte[] copyBuffer = new byte[4096];
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pathOnDisk));
             InputStream in = NativeLib.class.getResourceAsStream(pathWithinJar);){
            int bytesRead;
            if (in == null) {
                throw new FileNotFoundException("File " + pathWithinJar + " was not found inside JAR.");
            }
            while ((bytesRead = in.read(copyBuffer)) != -1) {
                ((OutputStream)out).write(copyBuffer, 0, bytesRead);
            }
        }
    }

    @NotNull
    private static String createTemporaryFileFromJar(@NotNull String pathWithinJar) throws IOException, IllegalArgumentException {
        if (!pathWithinJar.startsWith("/")) {
            throw new IllegalArgumentException("Path must be absolute (start with '/')");
        }
        if (pathWithinJar.endsWith("/")) {
            throw new IllegalArgumentException("Must be a path to file not directory (ends with '/')");
        }
        String[] parts = pathWithinJar.split("/");
        String filename = parts[parts.length - 1];
        parts = filename.split("\\.", 2);
        String prefix = parts[0];
        String suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        File libOnDisk = File.createTempFile(prefix, suffix);
        libOnDisk.deleteOnExit();
        NativeLib.copyFileFromJar(pathWithinJar, libOnDisk.getPath());
        return libOnDisk.getAbsolutePath();
    }

    private static void addDirectoryToNativeLibSearchList(@NotNull String dirToAdd) throws IOException {
        try {
            String[] paths;
            Field userPathsField = ClassLoader.class.getDeclaredField("usr_paths");
            userPathsField.setAccessible(true);
            for (String path : paths = (String[])userPathsField.get(null)) {
                if (!path.equals(dirToAdd)) continue;
                return;
            }
            String[] newPaths = new String[paths.length + 1];
            System.arraycopy(paths, 0, newPaths, 0, paths.length);
            newPaths[newPaths.length - 1] = dirToAdd;
            userPathsField.set(null, newPaths);
        }
        catch (NoSuchFieldException e) {
            logger.error(e.getMessage());
            throw new IOException("Failed to get field handle for `usr_path`");
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            throw new IOException("failed to set field handle for `usr_path`");
        }
    }

    static {
        try {
            NativeLib.smartLoad("catboost4j-prediction");
        }
        catch (Exception ex) {
            logger.error("Failed to load native library", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private static final class SingletonHolder {
        public static final CatBoostJNI catBoostJNI = new CatBoostJNI();

        private SingletonHolder() {
        }
    }
}

