/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.CatBoostError;
import ai.catboost.spark.EstimatedFeaturesLoadingContext;
import ai.catboost.spark.EstimatedFeaturesLoadingContext$;
import ai.catboost.spark.FeaturesColumnStorage;
import ai.catboost.spark.FeaturesColumnStorage$;
import ai.catboost.spark.Pool;
import ai.catboost.spark.PoolFilesPaths;
import ai.catboost.spark.QuantizedFeaturesIndices;
import ai.catboost.spark.SelectedFeaturesOffsets;
import ai.catboost.spark.SelectedFeaturesOffsets$;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.EDatasetVisitorType;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.ERawTargetType;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.IQuantizedFeaturesDataVisitor;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.QuantizedFeaturesInfoPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.SWIGTYPE_p_NCB__TRawObjectsDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TDataProviderBuilderOptions;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TDataProviderClosureForJVM;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TFeaturesLayoutPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TIntermediateDataMetaInfo;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TPairsDataBuilder;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TQuantizedObjectsDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TMaybeOwningConstArrayHolder_float;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TMaybeOwningConstArrayHolder_i32;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TString;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.native_impl;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DataHelpers$ {
    public static DataHelpers$ MODULE$;

    static {
        new DataHelpers$();
    }

    public Dataset<Row> mapSampleIdxToPerGroupSampleIdx(Dataset<Row> data) {
        int groupIdIdx = data.schema().fieldIndex("groupId");
        int sampleIdIdx = data.schema().fieldIndex("sampleId");
        RDD resultAsRDD = data.rdd().groupBy((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToLong((long)row.getLong(groupIdIdx)), ClassTag$.MODULE$.Long()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable rows = (Iterable)tuple2._2();
            LongRef startSampleId = LongRef.create((long)Long.MAX_VALUE);
            Seq rowsCopy = ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> {
                startSampleId$1.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(startSampleId$1.elem), row.getLong(sampleIdIdx));
                return row;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            Seq seq = (Seq)rowsCopy.map((Function1 & Serializable & scala.Serializable)row -> {
                Object[] fields = (Object[])row.toSeq().toArray(ClassTag$.MODULE$.Any());
                fields[sampleIdIdx$1] = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)fields[sampleIdIdx]) - startSampleId$1.elem));
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)fields));
            }, Seq$.MODULE$.canBuildFrom());
            return seq;
        }, ClassTag$.MODULE$.apply(Row.class));
        return data.sparkSession().createDataFrame(resultAsRDD, data.schema());
    }

    public Metadata makeFeaturesMetadata(String[] initialFeatureNames) {
        String[] featureNames = new String[initialFeatureNames.length];
        HashSet featureNamesSet = new HashSet();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureNames)).size()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            String name = initialFeatureNames[i];
            if (name.isEmpty()) {
                String generatedName = new StringBuilder(2).append("_f").append(i).toString();
                if (featureNamesSet.contains((Object)generatedName)) {
                    throw new CatBoostError(new StringBuilder(118).append("Unable to use generated name \"").append(generatedName).append("\" for feature with unspecified name because").append(" it has been already used for another feature").toString());
                }
                featureNames$1[i] = generatedName;
            } else {
                featureNames$1[i] = name;
            }
            return featureNamesSet.add((Object)featureNames[i]);
        });
        NumericAttribute defaultAttr = NumericAttribute$.MODULE$.defaultAttr();
        Attribute[] attrs = (Attribute[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureNames)).map((Function1 & Serializable & scala.Serializable)name -> defaultAttr.withName(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class))))).toArray(ClassTag$.MODULE$.apply(Attribute.class));
        AttributeGroup attrGroup = new AttributeGroup("userFeatures", attrs);
        return attrGroup.toMetadata();
    }

    public String[] getClassNamesFromLabelData(Dataset<Row> data, String labelColumn) {
        String[] stringArray;
        Iterator iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(data.select(labelColumn, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().toLocalIterator()).asScala();
        DataType dataType = data.schema().apply(labelColumn).dataType();
        DataType dataType2 = DataTypes.IntegerType;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            stringArray = (String[])((TraversableOnce)((TraversableLike)iterator.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DataHelpers$.$anonfun$getClassNamesFromLabelData$1(x$2))).toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$3 -> DataHelpers$.$anonfun$getClassNamesFromLabelData$2(BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            DataType dataType4 = DataTypes.LongType;
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                stringArray = (String[])((TraversableOnce)((TraversableLike)iterator.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)DataHelpers$.$anonfun$getClassNamesFromLabelData$3(x$4))).toSeq().sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> DataHelpers$.$anonfun$getClassNamesFromLabelData$4(BoxesRunTime.unboxToLong((Object)x$5)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            } else {
                DataType dataType6 = DataTypes.FloatType;
                DataType dataType7 = dataType;
                if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                    stringArray = (String[])((TraversableOnce)((TraversableLike)iterator.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToFloat((float)DataHelpers$.$anonfun$getClassNamesFromLabelData$5(x$6))).toSeq().sorted((Ordering)Ordering.Float$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$7 -> DataHelpers$.$anonfun$getClassNamesFromLabelData$6(BoxesRunTime.unboxToFloat((Object)x$7)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                } else {
                    DataType dataType8 = DataTypes.DoubleType;
                    DataType dataType9 = dataType;
                    if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                        stringArray = (String[])((TraversableOnce)((TraversableLike)iterator.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)DataHelpers$.$anonfun$getClassNamesFromLabelData$7(x$8))).toSeq().sorted((Ordering)Ordering.Double$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> DataHelpers$.$anonfun$getClassNamesFromLabelData$8(BoxesRunTime.unboxToDouble((Object)x$9)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                    } else {
                        DataType dataType10 = DataTypes.StringType;
                        DataType dataType11 = dataType;
                        if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                            stringArray = (String[])iterator.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getString(0)).toArray(ClassTag$.MODULE$.apply(String.class));
                        } else {
                            throw new CatBoostError("Unsupported data type for Label");
                        }
                    }
                }
            }
        }
        return stringArray;
    }

    public Tuple2<ArrayBuffer<Object[]>, SWIGTYPE_p_NCB__TRawObjectsDataProviderPtr> processDatasetWithRawFeatures(Iterator<Row> rows, int featuresColumnIdx, TFeaturesLayoutPtr featuresLayout, int maxUniqCatFeatureValues, boolean keepRawFeaturesInDstRows, int dstRowLength, int threadCount) {
        ArrayBuffer dstRows = new ArrayBuffer();
        int[] availableFloatFeaturesFlatIndices = native_impl.GetAvailableFeaturesFlatIndices_Float(featuresLayout.__deref__()).toPrimitiveArray();
        int[] availableCatFeaturesFlatIndices = native_impl.GetAvailableFeaturesFlatIndices_Categorical(featuresLayout.__deref__()).toPrimitiveArray();
        ObjectRef availableFloatFeaturesData = ObjectRef.create((Object)new ArrayBuilder[new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableFloatFeaturesFlatIndices)).size()]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableFloatFeaturesData.elem))).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ((ArrayBuilder[])availableFloatFeaturesData$1.elem)[i] = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Float());
        });
        ObjectRef availableCatFeaturesData = ObjectRef.create((Object)new ArrayBuilder[new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableCatFeaturesFlatIndices)).size()]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableCatFeaturesData.elem))).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ((ArrayBuilder[])availableCatFeaturesData$1.elem)[i] = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        });
        rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
            Object[] rowFields = new Object[dstRowLength];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (i == featuresColumnIdx) {
                    Vector featuresValues = (Vector)row.getAs(i);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableFloatFeaturesFlatIndices)).size()).foreach((Function1 & Serializable & scala.Serializable)j -> DataHelpers$.$anonfun$processDatasetWithRawFeatures$5(availableFloatFeaturesData, featuresValues, availableFloatFeaturesFlatIndices, BoxesRunTime.unboxToInt((Object)j)));
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableCatFeaturesFlatIndices)).size()).foreach((Function1 & Serializable & scala.Serializable)j -> DataHelpers$.$anonfun$processDatasetWithRawFeatures$6(availableCatFeaturesData, featuresValues, availableCatFeaturesFlatIndices, BoxesRunTime.unboxToInt((Object)j)));
                    if (keepRawFeaturesInDstRows) {
                        rowFields$1[i] = row.apply(i);
                    }
                } else {
                    rowFields$1[i] = row.apply(i);
                }
            });
            return dstRows.$plus$eq((Object)rowFields);
        });
        TVector_TMaybeOwningConstArrayHolder_float availableFloatFeaturesDataForBuilder = new TVector_TMaybeOwningConstArrayHolder_float();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableFloatFeaturesData.elem))).foreach((Function1 & Serializable & scala.Serializable)featureData -> BoxesRunTime.boxToBoolean((boolean)DataHelpers$.$anonfun$processDatasetWithRawFeatures$7(availableFloatFeaturesDataForBuilder, featureData)));
        TVector_TMaybeOwningConstArrayHolder_i32 availableCatFeaturesDataForBuilder = new TVector_TMaybeOwningConstArrayHolder_i32();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableCatFeaturesData.elem))).foreach((Function1 & Serializable & scala.Serializable)featureData -> BoxesRunTime.boxToBoolean((boolean)DataHelpers$.$anonfun$processDatasetWithRawFeatures$8(availableCatFeaturesDataForBuilder, featureData)));
        SWIGTYPE_p_NCB__TRawObjectsDataProviderPtr rawObjectsDataProviderPtr = native_impl.CreateRawObjectsDataProvider(featuresLayout, dstRows.size(), availableFloatFeaturesDataForBuilder, availableCatFeaturesDataForBuilder, maxUniqCatFeatureValues, threadCount);
        availableFloatFeaturesData.elem = null;
        availableCatFeaturesData.elem = null;
        System.gc();
        return new Tuple2((Object)dstRows, (Object)rawObjectsDataProviderPtr);
    }

    public Function1<Row, BoxedUnit> getLabelCallback(TVector_TString stringLabelData, ArrayBuilder.ofFloat floatLabelData, int fieldIdx, StructType schema) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType = schema.apply(fieldIdx).dataType();
        DataType dataType2 = DataTypes.IntegerType;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)row -> {
                floatLabelData.$plus$eq((float)BoxesRunTime.unboxToInt((Object)row.getAs(fieldIdx)));
                return BoxedUnit.UNIT;
            };
        } else {
            DataType dataType4 = DataTypes.LongType;
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)row -> {
                    floatLabelData.$plus$eq((float)BoxesRunTime.unboxToLong((Object)row.getAs(fieldIdx)));
                    return BoxedUnit.UNIT;
                };
            } else {
                DataType dataType6 = DataTypes.FloatType;
                DataType dataType7 = dataType;
                if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)row -> {
                        floatLabelData.$plus$eq(BoxesRunTime.unboxToFloat((Object)row.getAs(fieldIdx)));
                        return BoxedUnit.UNIT;
                    };
                } else {
                    DataType dataType8 = DataTypes.DoubleType;
                    DataType dataType9 = dataType;
                    if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)row -> {
                            floatLabelData.$plus$eq((float)BoxesRunTime.unboxToDouble((Object)row.getAs(fieldIdx)));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        DataType dataType10 = DataTypes.StringType;
                        DataType dataType11 = dataType;
                        if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)row -> {
                                stringLabelData.add((String)row.getAs(fieldIdx));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            throw new CatBoostError("Unsupported data type for Label");
                        }
                    }
                }
            }
        }
        return intersect;
    }

    public Function1<Row, BoxedUnit> getFloatCallback(ArrayBuilder.ofFloat floatData, int fieldIdx, StructType schema) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType = schema.apply(fieldIdx).dataType();
        DataType dataType2 = DataTypes.FloatType;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)row -> {
                floatData.$plus$eq(BoxesRunTime.unboxToFloat((Object)row.getAs(fieldIdx)));
                return BoxedUnit.UNIT;
            };
        } else {
            DataType dataType4 = DataTypes.DoubleType;
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)row -> {
                    floatData.$plus$eq((float)BoxesRunTime.unboxToDouble((Object)row.getAs(fieldIdx)));
                    return BoxedUnit.UNIT;
                };
            } else {
                throw new CatBoostError("Unsupported data type for float column");
            }
        }
        return intersect;
    }

    public Tuple2<TDataProviderClosureForJVM, IQuantizedFeaturesDataVisitor> getDataProviderBuilderAndVisitor(boolean hasFeatures, int threadCount) {
        TDataProviderBuilderOptions dataProviderBuilderOptions = new TDataProviderBuilderOptions();
        TDataProviderClosureForJVM dataProviderClosure = new TDataProviderClosureForJVM(EDatasetVisitorType.QuantizedFeatures, dataProviderBuilderOptions, hasFeatures, threadCount);
        IQuantizedFeaturesDataVisitor visitor = dataProviderClosure.GetQuantizedVisitor();
        if (visitor == null) {
            throw new CatBoostError("Failure to create IQuantizedFeaturesDataVisitor");
        }
        return new Tuple2((Object)dataProviderClosure, (Object)visitor);
    }

    public Tuple2<ArrayBuffer<Function1<Row, BoxedUnit>>, ArrayBuffer<Function0<BoxedUnit>>> getMainDataProcessingCallbacks(QuantizedFeaturesInfoPtr quantizedFeaturesInfo, HashMap<String, Object> columnIndexMap, TIntermediateDataMetaInfo dataMetaInfo, IQuantizedFeaturesDataVisitor visitor, StructType schema) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        BoxedUnit boxedUnit7;
        BoxedUnit boxedUnit8;
        ArrayBuffer callbacks = new ArrayBuffer();
        ArrayBuffer postprocessingCallbacks = new ArrayBuffer();
        if (columnIndexMap.contains((Object)"features")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"features"));
            FeaturesColumnStorage featuresColumnStorage = FeaturesColumnStorage$.MODULE$.apply(dataMetaInfo.getFeaturesLayout(), quantizedFeaturesInfo);
            callbacks.$plus$eq((Function1 & Serializable & scala.Serializable)row -> {
                featuresColumnStorage.addRowFeatures((byte[])row.getAs(fieldIdx));
                return BoxedUnit.UNIT;
            });
            boxedUnit8 = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> featuresColumnStorage.addToVisitor(visitor));
        } else {
            boxedUnit8 = BoxedUnit.UNIT;
        }
        if (columnIndexMap.contains((Object)"label")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"label"));
            TVector_TString stringLabelData = new TVector_TString();
            ArrayBuilder.ofFloat floatLabelData = new ArrayBuilder.ofFloat();
            callbacks.$plus$eq(this.getLabelCallback(stringLabelData, floatLabelData, fieldIdx, schema));
            boxedUnit7 = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ERawTargetType eRawTargetType = dataMetaInfo.getTargetType();
                boolean bl = ((Object)((Object)ERawTargetType.Float)).equals((Object)eRawTargetType) ? true : ((Object)((Object)ERawTargetType.Integer)).equals((Object)eRawTargetType);
                if (bl) {
                    visitor.AddTarget(floatLabelData.result());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (((Object)((Object)ERawTargetType.String)).equals((Object)eRawTargetType)) {
                    visitor.AddTarget(stringLabelData);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            });
        } else {
            boxedUnit7 = BoxedUnit.UNIT;
        }
        if (columnIndexMap.contains((Object)"weight")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"weight"));
            ArrayBuilder.ofFloat weightData = new ArrayBuilder.ofFloat();
            callbacks.$plus$eq(this.getFloatCallback(weightData, fieldIdx, schema));
            boxedUnit6 = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> visitor.AddWeight(weightData.result()));
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        if (columnIndexMap.contains((Object)"groupWeight")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"groupWeight"));
            ArrayBuilder.ofFloat groupWeightData = new ArrayBuilder.ofFloat();
            callbacks.$plus$eq(this.getFloatCallback(groupWeightData, fieldIdx, schema));
            boxedUnit5 = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> visitor.AddGroupWeight(groupWeightData.result()));
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (columnIndexMap.contains((Object)"baseline")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"baseline"));
            int baselineCount = (int)dataMetaInfo.getBaselineCount();
            ArrayBuilder.ofFloat[] baselineData = new ArrayBuilder.ofFloat[baselineCount];
            callbacks.$plus$eq((Function1 & Serializable & scala.Serializable)row -> {
                DataHelpers$.$anonfun$getMainDataProcessingCallbacks$6(fieldIdx, baselineCount, baselineData, row);
                return BoxedUnit.UNIT;
            });
            boxedUnit4 = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), baselineCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> visitor.AddBaseline(i, baselineData[i].result())));
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (columnIndexMap.contains((Object)"groupId")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"groupId"));
            ArrayBuilder.ofLong groupIdData = new ArrayBuilder.ofLong();
            callbacks.$plus$eq((Function1 & Serializable & scala.Serializable)row -> {
                groupIdData.$plus$eq(BoxesRunTime.unboxToLong((Object)row.getAs(fieldIdx)));
                return BoxedUnit.UNIT;
            });
            boxedUnit3 = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> visitor.AddGroupId(groupIdData.result()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (columnIndexMap.contains((Object)"subgroupId")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"subgroupId"));
            ArrayBuilder.ofInt subgroupIdData = new ArrayBuilder.ofInt();
            callbacks.$plus$eq((Function1 & Serializable & scala.Serializable)row -> {
                subgroupIdData.$plus$eq(BoxesRunTime.unboxToInt((Object)row.getAs(fieldIdx)));
                return BoxedUnit.UNIT;
            });
            boxedUnit2 = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> visitor.AddSubgroupId(subgroupIdData.result()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (columnIndexMap.contains((Object)"timestamp")) {
            int fieldIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"timestamp"));
            ArrayBuilder.ofLong timestampData = new ArrayBuilder.ofLong();
            callbacks.$plus$eq((Function1 & Serializable & scala.Serializable)row -> {
                timestampData.$plus$eq(BoxesRunTime.unboxToLong((Object)row.getAs(fieldIdx)));
                return BoxedUnit.UNIT;
            });
            boxedUnit = postprocessingCallbacks.$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> visitor.AddTimestamp(timestampData.result()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)callbacks, (Object)postprocessingCallbacks);
    }

    public Tuple2<Function3<Object, HashMap<Object, Object>, Row, BoxedUnit>, Function0<BoxedUnit>> getPairsDataProcessingCallbacks(IQuantizedFeaturesDataVisitor visitor, StructType schema) {
        Function3 & Serializable & scala.Serializable intersect;
        TPairsDataBuilder pairsDataBuilder = new TPairsDataBuilder();
        int winnerIdIdx = schema.fieldIndex("winnerId");
        int loserIdIdx = schema.fieldIndex("loserId");
        ObjectRef maybeWeightIdx = ObjectRef.create((Object)None$.MODULE$);
        ((TraversableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DataHelpers$.$anonfun$getPairsDataProcessingCallbacks$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            DataHelpers$.$anonfun$getPairsDataProcessingCallbacks$2(maybeWeightIdx, x$11);
            return BoxedUnit.UNIT;
        });
        Option option = (Option)maybeWeightIdx.elem;
        if (option instanceof Some) {
            Some some = (Some)option;
            int weightIdx = BoxesRunTime.unboxToInt((Object)some.value());
            intersect = (Function3 & Serializable & scala.Serializable)(groupIdx, sampleIdToIdxInGroup, row) -> {
                pairsDataBuilder.Add(BoxesRunTime.unboxToInt((Object)groupIdx), BoxesRunTime.unboxToInt((Object)sampleIdToIdxInGroup.apply(row.getAs(winnerIdIdx))), BoxesRunTime.unboxToInt((Object)sampleIdToIdxInGroup.apply(row.getAs(loserIdIdx))), BoxesRunTime.unboxToFloat((Object)row.getAs(weightIdx)));
                return BoxedUnit.UNIT;
            };
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function3 & Serializable & scala.Serializable)(groupIdx, sampleIdToIdxInGroup, row) -> {
                pairsDataBuilder.Add(BoxesRunTime.unboxToInt((Object)groupIdx), BoxesRunTime.unboxToInt((Object)sampleIdToIdxInGroup.apply(row.getAs(winnerIdIdx))), BoxesRunTime.unboxToInt((Object)sampleIdToIdxInGroup.apply(row.getAs(loserIdIdx))));
                return BoxedUnit.UNIT;
            };
        } else {
            throw new MatchError((Object)option);
        }
        Function3 & Serializable & scala.Serializable rowCallback = intersect;
        return new Tuple2((Object)rowCallback, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> pairsDataBuilder.AddToResult(visitor));
    }

    public Tuple2<TDataProviderPtr, TDataProviderPtr> loadQuantizedDatasets(QuantizedFeaturesInfoPtr quantizedFeaturesInfo, HashMap<String, Object> columnIndexMap, TIntermediateDataMetaInfo dataMetaInfo, StructType schema, Option<Object> estimatedFeatureCount, int threadCount, Iterator<Row> rows) {
        Tuple2 tuple2;
        Tuple2<TDataProviderClosureForJVM, IQuantizedFeaturesDataVisitor> tuple22 = this.getDataProviderBuilderAndVisitor(columnIndexMap.contains((Object)"features"), threadCount);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        TDataProviderClosureForJVM dataProviderBuilderClosure = (TDataProviderClosureForJVM)tuple22._1();
        IQuantizedFeaturesDataVisitor visitor = (IQuantizedFeaturesDataVisitor)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)dataProviderBuilderClosure, (Object)visitor);
        Tuple2 tuple24 = tuple23;
        TDataProviderClosureForJVM dataProviderBuilderClosure2 = (TDataProviderClosureForJVM)tuple24._1();
        IQuantizedFeaturesDataVisitor visitor2 = (IQuantizedFeaturesDataVisitor)tuple24._2();
        Tuple2<ArrayBuffer<Function1<Row, BoxedUnit>>, ArrayBuffer<Function0<BoxedUnit>>> tuple25 = this.getMainDataProcessingCallbacks(quantizedFeaturesInfo, columnIndexMap, dataMetaInfo, visitor2, schema);
        if (tuple25 == null) {
            throw new MatchError(tuple25);
        }
        ArrayBuffer mainDataRowCallbacks = (ArrayBuffer)tuple25._1();
        ArrayBuffer postprocessingCallbacks = (ArrayBuffer)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)mainDataRowCallbacks, (Object)postprocessingCallbacks);
        Tuple2 tuple27 = tuple26;
        ObjectRef mainDataRowCallbacks2 = ObjectRef.create((Object)((ArrayBuffer)tuple27._1()));
        ArrayBuffer postprocessingCallbacks2 = (ArrayBuffer)tuple27._2();
        EstimatedFeaturesLoadingContext estimatedFeaturesLoadingContext = null;
        if (estimatedFeatureCount.isDefined()) {
            estimatedFeaturesLoadingContext = EstimatedFeaturesLoadingContext$.MODULE$.createAndUpdateCallbacks(BoxesRunTime.unboxToInt((Object)estimatedFeatureCount.get()), BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"_estimatedFeatures")), threadCount, (ArrayBuffer<Function1<Row, BoxedUnit>>)((ArrayBuffer)mainDataRowCallbacks2.elem), (ArrayBuffer<Function0<BoxedUnit>>)postprocessingCallbacks2);
        }
        IntRef objectCount = IntRef.create((int)0);
        rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
            DataHelpers$.$anonfun$loadQuantizedDatasets$1(mainDataRowCallbacks2, objectCount, row);
            return BoxedUnit.UNIT;
        });
        dataMetaInfo.setObjectCount(BigInteger.valueOf(objectCount.elem));
        visitor2.Start(dataMetaInfo, objectCount.elem, quantizedFeaturesInfo.__deref__());
        if (estimatedFeatureCount.isDefined()) {
            estimatedFeaturesLoadingContext.start(objectCount.elem);
        }
        postprocessingCallbacks2.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
        visitor2.Finish();
        if (estimatedFeatureCount.isDefined()) {
            estimatedFeaturesLoadingContext.finish();
            tuple2 = new Tuple2((Object)dataProviderBuilderClosure2.GetResult(), (Object)estimatedFeaturesLoadingContext.getResult());
        } else {
            tuple2 = new Tuple2((Object)dataProviderBuilderClosure2.GetResult(), null);
        }
        return tuple2;
    }

    public Tuple2<TDataProviderPtr, TDataProviderPtr> loadQuantizedDatasetsWithPairs(QuantizedFeaturesInfoPtr quantizedFeaturesInfo, HashMap<String, Object> columnIndexMap, TIntermediateDataMetaInfo dataMetaInfo, StructType datasetSchema, StructType pairsDatasetSchema, Option<Object> estimatedFeatureCount, int threadCount, Iterator<Tuple2<Object, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>> groupsIterator) {
        Tuple2 tuple2;
        Tuple2<Function3<Object, HashMap<Object, Object>, Row, BoxedUnit>, Function0<BoxedUnit>> tuple22;
        Tuple2<TDataProviderClosureForJVM, IQuantizedFeaturesDataVisitor> tuple23 = this.getDataProviderBuilderAndVisitor(columnIndexMap.contains((Object)"features"), threadCount);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        TDataProviderClosureForJVM dataProviderBuilderClosure = (TDataProviderClosureForJVM)tuple23._1();
        IQuantizedFeaturesDataVisitor visitor = (IQuantizedFeaturesDataVisitor)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)dataProviderBuilderClosure, (Object)visitor);
        Tuple2 tuple25 = tuple24;
        TDataProviderClosureForJVM dataProviderBuilderClosure2 = (TDataProviderClosureForJVM)tuple25._1();
        IQuantizedFeaturesDataVisitor visitor2 = (IQuantizedFeaturesDataVisitor)tuple25._2();
        Tuple2<ArrayBuffer<Function1<Row, BoxedUnit>>, ArrayBuffer<Function0<BoxedUnit>>> tuple26 = this.getMainDataProcessingCallbacks(quantizedFeaturesInfo, columnIndexMap, dataMetaInfo, visitor2, datasetSchema);
        if (tuple26 == null) {
            throw new MatchError(tuple26);
        }
        ArrayBuffer mainDataRowCallbacks = (ArrayBuffer)tuple26._1();
        ArrayBuffer mainDataPostprocessingCallbacks = (ArrayBuffer)tuple26._2();
        Tuple2 tuple27 = new Tuple2((Object)mainDataRowCallbacks, (Object)mainDataPostprocessingCallbacks);
        Tuple2 tuple28 = tuple27;
        ArrayBuffer mainDataRowCallbacks2 = (ArrayBuffer)tuple28._1();
        ArrayBuffer mainDataPostprocessingCallbacks2 = (ArrayBuffer)tuple28._2();
        EstimatedFeaturesLoadingContext estimatedFeaturesLoadingContext = null;
        if (estimatedFeatureCount.isDefined()) {
            estimatedFeaturesLoadingContext = EstimatedFeaturesLoadingContext$.MODULE$.createAndUpdateCallbacks(BoxesRunTime.unboxToInt((Object)estimatedFeatureCount.get()), BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"_estimatedFeatures")), threadCount, (ArrayBuffer<Function1<Row, BoxedUnit>>)mainDataRowCallbacks2, (ArrayBuffer<Function0<BoxedUnit>>)mainDataPostprocessingCallbacks2);
        }
        if ((tuple22 = this.getPairsDataProcessingCallbacks(visitor2, pairsDatasetSchema)) == null) {
            throw new MatchError(tuple22);
        }
        Function3 pairsDataRowCallback = (Function3)tuple22._1();
        Function0 pairsDataPostprocessingCallback = (Function0)tuple22._2();
        Tuple2 tuple29 = new Tuple2((Object)pairsDataRowCallback, (Object)pairsDataPostprocessingCallback);
        Tuple2 tuple210 = tuple29;
        Function3 pairsDataRowCallback2 = (Function3)tuple210._1();
        Function0 pairsDataPostprocessingCallback2 = (Function0)tuple210._2();
        IntRef objectCount = IntRef.create((int)0);
        IntRef groupIdx = IntRef.create((int)0);
        int sampleIdIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"sampleId"));
        groupsIterator.foreach((Function1 & Serializable & scala.Serializable)group -> {
            DataHelpers$.$anonfun$loadQuantizedDatasetsWithPairs$1(mainDataRowCallbacks2, sampleIdIdx, objectCount, pairsDataRowCallback2, groupIdx, group);
            return BoxedUnit.UNIT;
        });
        dataMetaInfo.setObjectCount(BigInteger.valueOf(objectCount.elem));
        visitor2.Start(dataMetaInfo, objectCount.elem, quantizedFeaturesInfo.__deref__());
        if (estimatedFeatureCount.isDefined()) {
            estimatedFeaturesLoadingContext.start(objectCount.elem);
        }
        mainDataPostprocessingCallbacks2.foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
            x$20.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
        pairsDataPostprocessingCallback2.apply$mcV$sp();
        visitor2.Finish();
        if (estimatedFeatureCount.isDefined()) {
            estimatedFeaturesLoadingContext.finish();
            tuple2 = new Tuple2((Object)dataProviderBuilderClosure2.GetResult(), (Object)estimatedFeaturesLoadingContext.getResult());
        } else {
            tuple2 = new Tuple2((Object)dataProviderBuilderClosure2.GetResult(), null);
        }
        return tuple2;
    }

    public Tuple3<Dataset<Row>, HashMap<String, Object>, Option<Object>> selectColumnsForTrainingAndReturnIndex(Pool pool, boolean includeFeatures, boolean includeSampleId, boolean includeEstimatedFeatures) {
        None$ none$;
        HashMap columnTypesMap = new HashMap();
        ArrayBuffer columnTypeNames = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "weight", "groupWeight", "baseline", "groupId", "subgroupId", "timestamp"}));
        Object object = includeFeatures ? columnTypeNames.$plus$eq((Object)"features") : BoxedUnit.UNIT;
        Object object2 = includeSampleId ? columnTypeNames.$plus$eq((Object)"sampleId") : BoxedUnit.UNIT;
        ObjectRef columnsList = ObjectRef.create((Object)new ArrayBuffer());
        IntRef i = IntRef.create((int)0);
        columnTypeNames.foreach((Function1 & Serializable & scala.Serializable)columnTypeName -> {
            DataHelpers$.$anonfun$selectColumnsForTrainingAndReturnIndex$1(pool, columnsList, columnTypesMap, i, columnTypeName);
            return BoxedUnit.UNIT;
        });
        if (includeEstimatedFeatures && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pool.data().schema().names())).contains((Object)"_estimatedFeatures")) {
            ((ArrayBuffer)columnsList.elem).$plus$eq((Object)"_estimatedFeatures");
            columnTypesMap.update((Object)"_estimatedFeatures", (Object)BoxesRunTime.boxToInteger((int)i.elem));
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)pool.getEstimatedFeatureCount()));
        } else {
            none$ = None$.MODULE$;
        }
        None$ estimatedFeatureCount = none$;
        Dataset dfWithColumnsForTraining = pool.data().select((String)((ArrayBuffer)columnsList.elem).head(), (Seq)((ArrayBuffer)columnsList.elem).tail());
        return new Tuple3((Object)dfWithColumnsForTraining, (Object)columnTypesMap, (Object)estimatedFeatureCount);
    }

    public RDD<Tuple2<Object, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>> getCogroupedMainAndPairsRDD(Dataset<Row> mainData, int mainDataGroupIdFieldIdx, Dataset<Row> pairsData) {
        RDD groupedMainData = mainData.rdd().groupBy((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToLong((long)row.getLong(mainDataGroupIdFieldIdx)), ClassTag$.MODULE$.Long());
        int pairsGroupIdx = pairsData.schema().fieldIndex("groupId");
        RDD groupedPairsData = pairsData.rdd().groupBy((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToLong((long)row.getLong(pairsGroupIdx)), ClassTag$.MODULE$.Long());
        return RDD$.MODULE$.rddToPairRDDFunctions(groupedMainData, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Long$.MODULE$).cogroup(groupedPairsData);
    }

    public PoolFilesPaths downloadQuantizedPoolToTempFiles(Pool pool, boolean includeFeatures, boolean includeEstimatedFeatures, int threadCount, String tmpFilePrefix, String tmpFileSuffix) {
        Tuple2<TDataProviderPtr, TDataProviderPtr> tuple2;
        Tuple2<TDataProviderPtr, TDataProviderPtr> tuple22;
        Tuple3<Dataset<Row>, HashMap<String, Object>, Option<Object>> tuple3 = this.selectColumnsForTrainingAndReturnIndex(pool, includeFeatures, pool.pairsData() != null, includeEstimatedFeatures);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Dataset selectedDF = (Dataset)tuple3._1();
        HashMap columnIndexMap = (HashMap)tuple3._2();
        Option estimatedFeatureCount = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)selectedDF, (Object)columnIndexMap, (Object)estimatedFeatureCount);
        Tuple3 tuple33 = tuple32;
        Dataset selectedDF2 = (Dataset)tuple33._1();
        HashMap columnIndexMap2 = (HashMap)tuple33._2();
        Option estimatedFeatureCount2 = (Option)tuple33._3();
        if (pool.pairsData() != null) {
            OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(this.getCogroupedMainAndPairsRDD((Dataset<Row>)selectedDF2, BoxesRunTime.unboxToInt((Object)columnIndexMap2.apply((Object)"groupId")), pool.pairsData()), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class));
            boolean x$1 = qual$1.sortByKey$default$1();
            int x$2 = qual$1.sortByKey$default$2();
            RDD cogroupedMainAndPairsRDD = qual$1.sortByKey(x$1, x$2);
            tuple22 = this.loadQuantizedDatasetsWithPairs(pool.quantizedFeaturesInfo(), (HashMap<String, Object>)columnIndexMap2, pool.createDataMetaInfo(), selectedDF2.schema(), pool.pairsData().schema(), (Option<Object>)estimatedFeatureCount2, threadCount, (Iterator<Tuple2<Object, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>>)cogroupedMainAndPairsRDD.toLocalIterator());
        } else {
            tuple22 = tuple2 = this.loadQuantizedDatasets(pool.quantizedFeaturesInfo(), (HashMap<String, Object>)columnIndexMap2, pool.createDataMetaInfo(), selectedDF2.schema(), (Option<Object>)estimatedFeatureCount2, threadCount, (Iterator<Row>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(selectedDF2.toLocalIterator()).asScala()));
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TDataProviderPtr mainDataProvider = (TDataProviderPtr)tuple2._1();
        TDataProviderPtr estimatedDataProvider = (TDataProviderPtr)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)mainDataProvider, (Object)estimatedDataProvider);
        Tuple2 tuple24 = tuple23;
        TDataProviderPtr mainDataProvider2 = (TDataProviderPtr)tuple24._1();
        TDataProviderPtr estimatedDataProvider2 = (TDataProviderPtr)tuple24._2();
        Path tmpMainFilePath = Files.createTempFile(tmpFilePrefix, tmpFileSuffix, new FileAttribute[0]);
        tmpMainFilePath.toFile().deleteOnExit();
        native_impl.SaveQuantizedPoolWrapper(mainDataProvider2, ((Object)tmpMainFilePath).toString());
        None$ tmpPairsDataFilePath = None$.MODULE$;
        if (pool.pairsData() != null) {
            tmpPairsDataFilePath = new Some((Object)Files.createTempFile(tmpFilePrefix, tmpFileSuffix, new FileAttribute[0]));
            ((Path)tmpPairsDataFilePath.get()).toFile().deleteOnExit();
            native_impl.SavePairsInGroupedDsvFormat(mainDataProvider2, tmpPairsDataFilePath.get().toString());
        }
        None$ tmpEstimatedFilePath = None$.MODULE$;
        if (estimatedDataProvider2 != null) {
            tmpEstimatedFilePath = new Some((Object)Files.createTempFile(tmpFilePrefix, tmpFileSuffix, new FileAttribute[0]));
            ((Path)tmpEstimatedFilePath.get()).toFile().deleteOnExit();
            native_impl.SaveQuantizedPoolWrapper(estimatedDataProvider2, tmpEstimatedFilePath.get().toString());
        }
        return new PoolFilesPaths(tmpMainFilePath, (Option<Path>)tmpPairsDataFilePath, (Option<Path>)tmpEstimatedFilePath);
    }

    public int downloadQuantizedPoolToTempFiles$default$4() {
        return 1;
    }

    public String downloadQuantizedPoolToTempFiles$default$5() {
        return null;
    }

    public String downloadQuantizedPoolToTempFiles$default$6() {
        return null;
    }

    public TQuantizedObjectsDataProviderPtr downloadSubsetOfQuantizedFeatures(Pool pool, QuantizedFeaturesIndices quantizedFeaturesIndices, Set<Object> selectedFeaturesFlatIndices, int threadCount) {
        if (!pool.isQuantized()) {
            throw new CatBoostError("downloadSubsetOfQuantizedFeatures is applicable only for quantized pools");
        }
        SelectedFeaturesOffsets selectedFeaturesOffsets = SelectedFeaturesOffsets$.MODULE$.apply(pool.quantizedFeaturesInfo(), quantizedFeaturesIndices, selectedFeaturesFlatIndices);
        int selectedFeaturesByteSize = selectedFeaturesOffsets.getByteSize();
        StructType selectedFeaturesSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("features", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        ExpressionEncoder selectedFeaturesEncoder = RowEncoder$.MODULE$.apply(selectedFeaturesSchema);
        Dataset selectedFeaturesDf = pool.data().select(pool.getFeaturesCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
            byte[] buffer = new byte[selectedFeaturesByteSize];
            return rows.map((Function1 & Serializable & scala.Serializable)row -> {
                ByteBuffer srcByteBuffer = ByteBuffer.wrap((byte[])row.getAs(0));
                srcByteBuffer.order(ByteOrder.nativeOrder());
                ByteBuffer dstByteBuffer = ByteBuffer.wrap(buffer);
                dstByteBuffer.order(ByteOrder.nativeOrder());
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeaturesOffsets.ui8Offsets())).foreach((Function1 & Serializable & scala.Serializable)offset -> dstByteBuffer.put(srcByteBuffer.get(BoxesRunTime.unboxToInt((Object)offset))));
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeaturesOffsets.ui16Offsets())).foreach((Function1 & Serializable & scala.Serializable)offset -> dstByteBuffer.putShort(srcByteBuffer.getShort(BoxesRunTime.unboxToInt((Object)offset))));
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeaturesOffsets.ui32Offsets())).foreach((Function1 & Serializable & scala.Serializable)offset -> dstByteBuffer.putInt(srcByteBuffer.getInt(BoxesRunTime.unboxToInt((Object)offset))));
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer}));
            });
        }, (Encoder)selectedFeaturesEncoder);
        TIntermediateDataMetaInfo dataMetaInfo = new TIntermediateDataMetaInfo();
        dataMetaInfo.setFeaturesLayout(native_impl.CloneWithSelectedFeatures(pool.quantizedFeaturesInfo().GetFeaturesLayout().__deref__(), (int[])selectedFeaturesFlatIndices.toArray(ClassTag$.MODULE$.Int())));
        return ((TDataProviderPtr)this.loadQuantizedDatasets(pool.quantizedFeaturesInfo(), (HashMap<String, Object>)((HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)BoxesRunTime.boxToInteger((int)0))}))), dataMetaInfo, selectedFeaturesSchema, (Option<Object>)None$.MODULE$, threadCount, (Iterator<Row>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(selectedFeaturesDf.toLocalIterator()).asScala()))._1()).GetQuantizedObjectsDataProvider();
    }

    public int downloadSubsetOfQuantizedFeatures$default$4() {
        return 1;
    }

    public static final /* synthetic */ int $anonfun$getClassNamesFromLabelData$1(Row x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2.getAs(0));
    }

    public static final /* synthetic */ String $anonfun$getClassNamesFromLabelData$2(int x$3) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
    }

    public static final /* synthetic */ long $anonfun$getClassNamesFromLabelData$3(Row x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4.getAs(0));
    }

    public static final /* synthetic */ String $anonfun$getClassNamesFromLabelData$4(long x$5) {
        return ((Object)BoxesRunTime.boxToLong((long)x$5)).toString();
    }

    public static final /* synthetic */ float $anonfun$getClassNamesFromLabelData$5(Row x$6) {
        return BoxesRunTime.unboxToFloat((Object)x$6.getAs(0));
    }

    public static final /* synthetic */ String $anonfun$getClassNamesFromLabelData$6(float x$7) {
        return ((Object)BoxesRunTime.boxToFloat((float)x$7)).toString();
    }

    public static final /* synthetic */ double $anonfun$getClassNamesFromLabelData$7(Row x$8) {
        return BoxesRunTime.unboxToDouble((Object)x$8.getAs(0));
    }

    public static final /* synthetic */ String $anonfun$getClassNamesFromLabelData$8(double x$9) {
        return ((Object)BoxesRunTime.boxToDouble((double)x$9)).toString();
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$processDatasetWithRawFeatures$5(ObjectRef availableFloatFeaturesData$1, Vector featuresValues$1, int[] availableFloatFeaturesFlatIndices$1, int j) {
        return (ArrayBuilder)((ArrayBuilder[])availableFloatFeaturesData$1.elem)[j].$plus$eq((Object)BoxesRunTime.boxToFloat((float)((float)featuresValues$1.apply(availableFloatFeaturesFlatIndices$1[j]))));
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$processDatasetWithRawFeatures$6(ObjectRef availableCatFeaturesData$1, Vector featuresValues$1, int[] availableCatFeaturesFlatIndices$1, int j) {
        return (ArrayBuilder)((ArrayBuilder[])availableCatFeaturesData$1.elem)[j].$plus$eq((Object)BoxesRunTime.boxToInteger((int)((int)featuresValues$1.apply(availableCatFeaturesFlatIndices$1[j]))));
    }

    public static final /* synthetic */ boolean $anonfun$processDatasetWithRawFeatures$7(TVector_TMaybeOwningConstArrayHolder_float availableFloatFeaturesDataForBuilder$1, ArrayBuilder featureData) {
        float[] result = (float[])featureData.result();
        return availableFloatFeaturesDataForBuilder$1.add(result);
    }

    public static final /* synthetic */ boolean $anonfun$processDatasetWithRawFeatures$8(TVector_TMaybeOwningConstArrayHolder_i32 availableCatFeaturesDataForBuilder$1, ArrayBuilder featureData) {
        int[] result = (int[])featureData.result();
        return availableCatFeaturesDataForBuilder$1.add(result);
    }

    public static final /* synthetic */ ArrayBuilder.ofFloat $anonfun$getMainDataProcessingCallbacks$7(ArrayBuilder.ofFloat[] baselineData$1, DenseVector baselineRow$1, int i) {
        return baselineData$1[i].$plus$eq((float)baselineRow$1.apply(i));
    }

    public static final /* synthetic */ void $anonfun$getMainDataProcessingCallbacks$6(int fieldIdx$4, int baselineCount$1, ArrayBuilder.ofFloat[] baselineData$1, Row row) {
        DenseVector baselineRow = ((Vector)row.getAs(fieldIdx$4)).toDense();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), baselineCount$1).foreach((Function1 & Serializable & scala.Serializable)i -> DataHelpers$.$anonfun$getMainDataProcessingCallbacks$7(baselineData$1, baselineRow, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ boolean $anonfun$getPairsDataProcessingCallbacks$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getPairsDataProcessingCallbacks$2(ObjectRef maybeWeightIdx$1, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = structField.name();
            if ("weight".equals(string)) {
                maybeWeightIdx$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)idx));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$loadQuantizedDatasets$1(ObjectRef mainDataRowCallbacks$1, IntRef objectCount$1, Row row) {
        ((ArrayBuffer)mainDataRowCallbacks$1.elem).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.apply((Object)row);
            return BoxedUnit.UNIT;
        });
        ++objectCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$loadQuantizedDatasetsWithPairs$3(ArrayBuffer mainDataRowCallbacks$2, int sampleIdIdx$2, HashMap sampleIdToIdxInGroup$1, IntRef objectIdxInGroup$1, Row row) {
        mainDataRowCallbacks$2.foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            x$19.apply((Object)row);
            return BoxedUnit.UNIT;
        });
        long sampleId = row.getLong(sampleIdIdx$2);
        sampleIdToIdxInGroup$1.put((Object)BoxesRunTime.boxToLong((long)sampleId), (Object)BoxesRunTime.boxToInteger((int)objectIdxInGroup$1.elem));
        ++objectIdxInGroup$1.elem;
    }

    public static final /* synthetic */ void $anonfun$loadQuantizedDatasetsWithPairs$1(ArrayBuffer mainDataRowCallbacks$2, int sampleIdIdx$2, IntRef objectCount$2, Function3 pairsDataRowCallback$1, IntRef groupIdx$1, Tuple2 group) {
        HashMap sampleIdToIdxInGroup = new HashMap();
        IntRef objectIdxInGroup = IntRef.create((int)0);
        ((IterableLike)((Tuple2)group._2())._1()).foreach((Function1 & Serializable & scala.Serializable)it -> {
            it.foreach((Function1 & Serializable & scala.Serializable)row -> {
                DataHelpers$.$anonfun$loadQuantizedDatasetsWithPairs$3(mainDataRowCallbacks$2, sampleIdIdx$2, sampleIdToIdxInGroup$1, objectIdxInGroup$1, row);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        objectCount$2.elem += objectIdxInGroup.elem;
        ((IterableLike)((Tuple2)group._2())._2()).foreach((Function1 & Serializable & scala.Serializable)it -> {
            it.foreach((Function1 & Serializable & scala.Serializable)row -> {
                pairsDataRowCallback$1.apply((Object)BoxesRunTime.boxToInteger((int)groupIdx$1.elem), (Object)sampleIdToIdxInGroup$1, (Object)row);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ++groupIdx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$selectColumnsForTrainingAndReturnIndex$1(Pool pool$1, ObjectRef columnsList$1, HashMap columnTypesMap$1, IntRef i$1, String columnTypeName) {
        block0: {
            Param<Object> param = pool$1.getParam(new StringBuilder(3).append(columnTypeName).append("Col").toString());
            if (!pool$1.isDefined(param)) break block0;
            String paramValue = (String)pool$1.getOrDefault(param);
            ((ArrayBuffer)columnsList$1.elem).$plus$eq((Object)paramValue);
            columnTypesMap$1.update((Object)columnTypeName, (Object)BoxesRunTime.boxToInteger((int)i$1.elem));
            ++i$1.elem;
        }
    }

    private DataHelpers$() {
        MODULE$ = this;
    }
}

