/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.CatBoostError;
import ai.catboost.spark.CatBoostModelTrait;
import ai.catboost.spark.CatBoostModelWriter;
import ai.catboost.spark.DataHelpers$;
import ai.catboost.spark.FeatureImportance;
import ai.catboost.spark.FeatureInteractionScore;
import ai.catboost.spark.Pool;
import ai.catboost.spark.Pool$;
import ai.catboost.spark.SparkHelpers$;
import ai.catboost.spark.impl.FeatureImportanceCalcer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.ECalcTypeShapValues;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.EExplainableModelOutput;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.EFstrType;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.EModelType;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.EPreCalcShapValues;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TFeaturesLayoutPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TLocalExecutor;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TRawObjectsDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TString;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.native_impl;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class CatBoostModelTrait$class {
    /*
     * WARNING - void declaration
     */
    public static final double[] predictRawImpl(CatBoostModelTrait $this, Vector features) {
        block4: {
            void var2_2;
            block3: {
                Vector vector;
                double[] result;
                block2: {
                    result = new double[$this.nativeDimension()];
                    vector = features;
                    if (!(vector instanceof DenseVector)) break block2;
                    DenseVector denseVector = (DenseVector)vector;
                    $this.nativeModel().Calc(denseVector.values(), result);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(vector instanceof SparseVector)) break block4;
                SparseVector sparseVector = (SparseVector)vector;
                $this.nativeModel().CalcSparse(sparseVector.size(), sparseVector.indices(), sparseVector.values(), result);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }
        throw new CatBoostError("Unknown Vector subtype");
    }

    public static Dataset transformCatBoostImpl(CatBoostModelTrait $this, Dataset dataset) {
        Dataset dataset2;
        Dataset dataFrame = dataset;
        int featuresColumnIdx = dataset.schema().fieldIndex((String)((Params)$this).$(((HasFeaturesCol)$this).featuresCol()));
        Seq<StructField> additionalColumnsForApply = $this.getAdditionalColumnsForApply();
        if (additionalColumnsForApply.isEmpty()) {
            ((Logging)$this).logWarning((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CatBoostModelTrait $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": transform() was called as NOOP since no output columns were set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Identifiable)this.$outer).uid()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            dataset2 = dataFrame;
        } else {
            StructType resultSchema = StructType$.MODULE$.apply((Seq)dataset.schema().toSeq().$plus$plus(additionalColumnsForApply, Seq$.MODULE$.canBuildFrom()));
            Pool pool = new Pool((Dataset<Row>)dataFrame).setFeaturesCol((String)((Params)$this).$(((HasFeaturesCol)$this).featuresCol()));
            TFeaturesLayoutPtr featuresLayoutPtr = pool.getFeaturesLayout();
            int maxUniqCatFeatureValues = Pool$.MODULE$.getCatFeaturesMaxUniqValueCount((Dataset<Row>)dataFrame, (String)((Params)$this).$(((HasFeaturesCol)$this).featuresCol()));
            int dstRowLength = resultSchema.length();
            int threadCountForTask = SparkHelpers$.MODULE$.getThreadCountForTask(dataset.sparkSession());
            ((Logging)$this).logInfo((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CatBoostModelTrait $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": schedule applying model."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Identifiable)this.$outer).uid()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            RDD resultAsRDD = dataFrame.rdd().mapPartitions((Function1)new Serializable($this, featuresColumnIdx, featuresLayoutPtr, maxUniqCatFeatureValues, dstRowLength, threadCountForTask){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CatBoostModelTrait $outer;
                private final int featuresColumnIdx$1;
                private final TFeaturesLayoutPtr featuresLayoutPtr$1;
                private final int maxUniqCatFeatureValues$1;
                private final int dstRowLength$1;
                private final int threadCountForTask$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Iterator<Row> apply(Iterator<Row> rowsIterator) {
                    Iterator<Row> iterator;
                    if (rowsIterator.hasNext()) {
                        Tuple2 tuple2;
                        TLocalExecutor localExecutor = new TLocalExecutor();
                        localExecutor.Init(this.threadCountForTask$1);
                        Tuple2<ArrayBuffer<Object[]>, TRawObjectsDataProviderPtr> tuple22 = DataHelpers$.MODULE$.processDatasetWithRawFeatures(rowsIterator, this.featuresColumnIdx$1, this.featuresLayoutPtr$1, this.maxUniqCatFeatureValues$1, true, this.dstRowLength$1, localExecutor);
                        if (tuple22 == null) throw new MatchError(tuple22);
                        ArrayBuffer dstRows = (ArrayBuffer)tuple22._1();
                        TRawObjectsDataProviderPtr rawObjectsDataProviderPtr = (TRawObjectsDataProviderPtr)tuple22._2();
                        Tuple2 tuple23 = tuple2 = new Tuple2((Object)dstRows, (Object)rawObjectsDataProviderPtr);
                        ArrayBuffer dstRows2 = (ArrayBuffer)tuple23._1();
                        TRawObjectsDataProviderPtr rawObjectsDataProviderPtr2 = (TRawObjectsDataProviderPtr)tuple23._2();
                        iterator = this.$outer.getResultIteratorForApply(rawObjectsDataProviderPtr2.ToBase(), (ArrayBuffer<Object[]>)dstRows2, localExecutor);
                        return iterator;
                    } else {
                        iterator = package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                    }
                    return iterator;
                }
                {
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.featuresColumnIdx$1 = featuresColumnIdx$1;
                    this.featuresLayoutPtr$1 = var3_3;
                    this.maxUniqCatFeatureValues$1 = maxUniqCatFeatureValues$1;
                    this.dstRowLength$1 = dstRowLength$1;
                    this.threadCountForTask$1 = threadCountForTask$1;
                }
            }, dataFrame.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
            dataset2 = dataFrame.sparkSession().createDataFrame(resultAsRDD, resultSchema);
        }
        return dataset2;
    }

    public static Dataset transformPool(CatBoostModelTrait $this, Pool dataset) {
        String string = dataset.getFeaturesCol();
        String string2 = ((HasFeaturesCol)$this).getFeaturesCol();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Object object;
            if (dataset.isQuantized()) {
                Seq<StructField> additionalColumnsForApply = $this.getAdditionalColumnsForApply();
                if (additionalColumnsForApply.isEmpty()) {
                    ((Logging)$this).logWarning((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CatBoostModelTrait $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": transform() was called as NOOP since no output columns were set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Identifiable)this.$outer).uid()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    object = dataset.data();
                } else {
                    StructType resultSchema = StructType$.MODULE$.apply((Seq)dataset.data().schema().toSeq().$plus$plus(additionalColumnsForApply, Seq$.MODULE$.canBuildFrom()));
                    object = dataset.mapQuantizedPartitions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dataset.getFeaturesCol()}))), false, false, (String[])null, resultSchema.length(), new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CatBoostModelTrait $outer;

                        public final Iterator<Row> apply(TDataProviderPtr dataProvider, TDataProviderPtr estimatedDataProvider, ArrayBuffer<Object[]> dstRows, TLocalExecutor localExecutor) {
                            return this.$outer.getResultIteratorForApply(dataProvider.GetQuantizedObjectsDataProvider().ToBase(), dstRows, localExecutor);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, RowEncoder$.MODULE$.apply(resultSchema), scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Row.class)));
                }
            } else {
                object = $this.ai$catboost$spark$CatBoostModelTrait$$super$transformImpl(dataset.data());
            }
            return object;
        }
        throw new CatBoostError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"model and dataset have incompatible features column names: ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((HasFeaturesCol)$this).getFeaturesCol()}))).append((Object)dataset.getFeaturesCol()).toString());
    }

    public static MLWriter write(CatBoostModelTrait $this) {
        return new CatBoostModelWriter($this);
    }

    public static void saveNativeModel(CatBoostModelTrait $this, String fileName, EModelType format, Map exportParameters, Pool pool) {
        String string;
        if (exportParameters == null) {
            string = "";
        } else {
            DefaultFormats$ formats = DefaultFormats$.MODULE$;
            string = Serialization$.MODULE$.write((Object)exportParameters, (Formats)formats);
        }
        String exportParametersJsonString = string;
        int poolCatFeaturesMaxUniqValueCount = pool == null ? 0 : BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(pool.getCatFeaturesUniqValueCounts()).max((Ordering)Ordering.Int$.MODULE$));
        $this.nativeModel().Save(fileName, format, exportParametersJsonString, poolCatFeaturesMaxUniqValueCount);
    }

    public static EModelType saveNativeModel$default$2(CatBoostModelTrait $this) {
        return EModelType.CatboostBinary;
    }

    public static Map saveNativeModel$default$3(CatBoostModelTrait $this) {
        return null;
    }

    public static Pool saveNativeModel$default$4(CatBoostModelTrait $this) {
        return null;
    }

    public static double[] getFeatureImportance(CatBoostModelTrait $this, EFstrType fstrType, Pool data, ECalcTypeShapValues calcType) {
        return new FeatureImportanceCalcer().calc($this.nativeModel(), fstrType, data, calcType);
    }

    public static EFstrType getFeatureImportance$default$1(CatBoostModelTrait $this) {
        return EFstrType.FeatureImportance;
    }

    public static Pool getFeatureImportance$default$2(CatBoostModelTrait $this) {
        return null;
    }

    public static ECalcTypeShapValues getFeatureImportance$default$3(CatBoostModelTrait $this) {
        return ECalcTypeShapValues.Regular;
    }

    public static FeatureImportance[] getFeatureImportancePrettified(CatBoostModelTrait $this, EFstrType fstrType, Pool data, ECalcTypeShapValues calcType) {
        double[] featureImportancesArray = $this.getFeatureImportance(fstrType, data, calcType);
        TFeaturesLayoutPtr datasetFeaturesLayout = data == null ? new TFeaturesLayoutPtr() : data.getFeaturesLayout();
        TVector_TString featureNames = native_impl.GetMaybeGeneratedModelFeatureIds($this.nativeModel(), datasetFeaturesLayout);
        return (FeatureImportance[])((TraversableOnce)((TraversableLike)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)featureNames).asScala()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(featureImportancesArray), Buffer$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<String, Object> x$2) {
                return -x$2._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final FeatureImportance apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    double value = tuple2._2$mcD$sp();
                    FeatureImportance featureImportance = new FeatureImportance(name, value);
                    return featureImportance;
                }
                throw new MatchError(tuple2);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FeatureImportance.class));
    }

    public static EFstrType getFeatureImportancePrettified$default$1(CatBoostModelTrait $this) {
        return EFstrType.FeatureImportance;
    }

    public static Pool getFeatureImportancePrettified$default$2(CatBoostModelTrait $this) {
        return null;
    }

    public static ECalcTypeShapValues getFeatureImportancePrettified$default$3(CatBoostModelTrait $this) {
        return ECalcTypeShapValues.Regular;
    }

    public static Dataset getFeatureImportanceShapValues(CatBoostModelTrait $this, Pool data, EPreCalcShapValues preCalcMode, ECalcTypeShapValues calcType, EExplainableModelOutput modelOutputType, Pool referenceData, String[] outputColumns) {
        return new FeatureImportanceCalcer().calcShapValues($this.nativeModel(), data, preCalcMode, calcType, modelOutputType, referenceData, outputColumns);
    }

    public static EPreCalcShapValues getFeatureImportanceShapValues$default$2(CatBoostModelTrait $this) {
        return EPreCalcShapValues.Auto;
    }

    public static ECalcTypeShapValues getFeatureImportanceShapValues$default$3(CatBoostModelTrait $this) {
        return ECalcTypeShapValues.Regular;
    }

    public static EExplainableModelOutput getFeatureImportanceShapValues$default$4(CatBoostModelTrait $this) {
        return EExplainableModelOutput.Raw;
    }

    public static Pool getFeatureImportanceShapValues$default$5(CatBoostModelTrait $this) {
        return null;
    }

    public static String[] getFeatureImportanceShapValues$default$6(CatBoostModelTrait $this) {
        return null;
    }

    public static Dataset getFeatureImportanceShapInteractionValues(CatBoostModelTrait $this, Pool data, Pair featureIndices, Pair featureNames, EPreCalcShapValues preCalcMode, ECalcTypeShapValues calcType, String[] outputColumns) {
        return new FeatureImportanceCalcer().calcShapInteractionValues($this.nativeModel(), data, (Pair<Object, Object>)featureIndices, (Pair<String, String>)featureNames, preCalcMode, calcType, outputColumns);
    }

    public static Pair getFeatureImportanceShapInteractionValues$default$2(CatBoostModelTrait $this) {
        return null;
    }

    public static Pair getFeatureImportanceShapInteractionValues$default$3(CatBoostModelTrait $this) {
        return null;
    }

    public static EPreCalcShapValues getFeatureImportanceShapInteractionValues$default$4(CatBoostModelTrait $this) {
        return EPreCalcShapValues.Auto;
    }

    public static ECalcTypeShapValues getFeatureImportanceShapInteractionValues$default$5(CatBoostModelTrait $this) {
        return ECalcTypeShapValues.Regular;
    }

    public static String[] getFeatureImportanceShapInteractionValues$default$6(CatBoostModelTrait $this) {
        return null;
    }

    public static FeatureInteractionScore[] getFeatureImportanceInteraction(CatBoostModelTrait $this) {
        return new FeatureImportanceCalcer().calcInteraction($this.nativeModel());
    }

    public static void $init$(CatBoostModelTrait $this) {
    }
}

