/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.spark.CatBoostModelReaderTrait;
import java.io.DataInput;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TFullModel;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public abstract class CatBoostModelReaderTrait$class {
    private static CatBoostModelReaderTrait.Metadata loadMetadata(CatBoostModelReaderTrait $this, String path, SparkContext sc, String expectedClassName) {
        String metadataPath = new Path(path, "metadata").toString();
        String metadataStr = (String)sc.textFile(metadataPath, 1).first();
        return $this.parseMetadata(metadataStr, expectedClassName);
    }

    private static String loadMetadata$default$3(CatBoostModelReaderTrait $this) {
        return "";
    }

    public static CatBoostModelReaderTrait.Metadata parseMetadata(CatBoostModelReaderTrait $this, String metadataStr, String expectedClassName) {
        JsonAST.JValue metadata = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(metadataStr), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        DefaultFormats$ format = DefaultFormats$.MODULE$;
        String className = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata).$bslash("class")).extract((Formats)format, ManifestFactory$.MODULE$.classType(String.class));
        String uid = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata).$bslash("uid")).extract((Formats)format, ManifestFactory$.MODULE$.classType(String.class));
        long timestamp = BoxesRunTime.unboxToLong((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata).$bslash("timestamp")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Long()));
        String sparkVersion = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata).$bslash("sparkVersion")).extract((Formats)format, ManifestFactory$.MODULE$.classType(String.class));
        if (new StringOps(Predef$.MODULE$.augmentString(expectedClassName)).nonEmpty()) {
            String string = className;
            String string2 = expectedClassName;
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable($this, className, expectedClassName){
                public static final long serialVersionUID = 0L;
                private final String className$1;
                private final String expectedClassName$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error loading metadata: Expected class name"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " but found class name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expectedClassName$1, this.className$1}))).toString();
                }
                {
                    this.className$1 = className$1;
                    this.expectedClassName$1 = expectedClassName$1;
                }
            });
        }
        return new CatBoostModelReaderTrait.Metadata($this, className, uid, timestamp, sparkVersion);
    }

    public static String parseMetadata$default$2(CatBoostModelReaderTrait $this) {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static Tuple2 loadImpl(CatBoostModelReaderTrait $this, SparkContext sc, String className, String path) {
        CatBoostModelReaderTrait.Metadata metadata = CatBoostModelReaderTrait$class.loadMetadata($this, path, sc, className);
        Path modelPath = new Path(path, "model");
        FileSystem fileSystem = modelPath.getFileSystem(sc.hadoopConfiguration());
        ContentSummary contentSummary = fileSystem.getContentSummary(modelPath);
        TFullModel nativeModel = new TFullModel();
        FSDataInputStream inputStream = fileSystem.open(modelPath);
        try {
            nativeModel.read((int)contentSummary.getLength(), (DataInput)inputStream);
        }
        catch (Throwable throwable) {
            void var9_9;
            var9_9.close();
            throw throwable;
        }
        inputStream.close();
        return new Tuple2((Object)metadata.uid(), (Object)nativeModel);
    }

    public static void $init$(CatBoostModelReaderTrait $this) {
    }
}

