/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark.impl.pyspark_wrapper_generator;

import ai.catboost.spark.CatBoostClassificationModel;
import ai.catboost.spark.CatBoostClassifier;
import ai.catboost.spark.CatBoostRegressionModel;
import ai.catboost.spark.CatBoostRegressor;
import ai.catboost.spark.Pool;
import ai.catboost.spark.impl.pyspark_wrapper_generator.Generator$;
import ai.catboost.spark.params.PoolLoadParams;
import ai.catboost.spark.params.QuantizationParams;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.PrintWriter;
import java.time.Duration;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TFullModel;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Generator$ {
    public static final Generator$ MODULE$;

    static {
        new Generator$();
    }

    public void generateCorePyPrologue(String sparkCompatVersion, PrintWriter out) {
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nimport collections\nimport datetime\nfrom enum import Enum\nfrom typing import TYPE_CHECKING\n\nfrom py4j.java_gateway import JavaObject\n\nfrom pyspark import keyword_only, SparkContext\n"})).s((Seq)Nil$.MODULE$));
        String string = sparkCompatVersion;
        if ("3.0".equals(string)) {
            out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nfrom pyspark.ml.classification import JavaProbabilisticClassificationModel\nfrom pyspark.ml.regression import JavaRegressionModel\n"})).s((Seq)Nil$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = "3.1".equals(string) ? true : ("3.2".equals(string) ? true : ("3.3".equals(string) ? true : "3.4".equals(string)));
            if (bl) {
                out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nfrom pyspark.ml.classification import _JavaProbabilisticClassificationModel\nfrom pyspark.ml.regression import _JavaRegressionModel\n"})).s((Seq)Nil$.MODULE$));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nfrom pyspark.ml.classification import JavaClassificationModel\nfrom pyspark.ml.util import JavaPredictionModel\nfrom pyspark.ml.wrapper import JavaModel\n"})).s((Seq)Nil$.MODULE$));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nimport pyspark.ml.common\nfrom pyspark.ml.common import inherit_doc\nfrom pyspark.ml.param import Param, Params\nfrom pyspark.ml.util import JavaMLReader, JavaMLWriter, JavaMLWritable, MLReadable\n"})).s((Seq)Nil$.MODULE$));
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nimport pyspark.ml.wrapper\nfrom pyspark.ml.wrapper import JavaParams, JavaEstimator, JavaWrapper\nfrom pyspark.sql import DataFrame, SparkSession\n\n\nif TYPE_CHECKING:\n    from pyspark.sql._typing import OptionalPrimitiveType\n\n\"\\\"\"\n    original JavaParams._from_java has to be replaced because of hardcoded class names transformation\n\"\\\"\"\n\n@staticmethod\ndef _from_java_patched_for_catboost(java_stage):\n    \"\\\"\"\n    Given a Java object, create and return a Python wrapper of it.\n    Used for ML persistence.\n\n    Meta-algorithms such as Pipeline should override this method as a classmethod.\n    \"\\\"\"\n    def __get_class(clazz):\n        \"\\\"\"\n        Loads Python class from its name.\n        \"\\\"\"\n        parts = clazz.split('.')\n        module = \".\".join(parts[:-1])\n        m = __import__(module)\n        for comp in parts[1:]:\n            m = getattr(m, comp)\n        return m\n    stage_name = (\n        java_stage.getClass().getName()\n            .replace(\"org.apache.spark\", \"pyspark\")\n            .replace(\"ai.catboost.spark\", \"catboost_spark\")\n    )\n    # Generate a default new instance from the stage_name class.\n    py_type = __get_class(stage_name)\n    if issubclass(py_type, JavaParams):\n        # Load information from java_stage to the instance.\n        py_stage = py_type()\n        py_stage._java_obj = java_stage\n        py_stage._resetUid(java_stage.uid())\n        py_stage._transfer_params_from_java()\n    elif hasattr(py_type, \"_from_java\"):\n        py_stage = py_type._from_java(java_stage)\n    else:\n        raise NotImplementedError(\"This Java stage cannot be loaded into Python currently: %r\"\n                                  % stage_name)\n    return py_stage\n\nJavaParams._from_java = _from_java_patched_for_catboost\n\n\n\"\\\"\"\n    Adapt _py2java and _java2py for additional types present in CatBoost Params\n\"\\\"\"\n\n_standard_py2java = pyspark.ml.common._py2java\n_standard_java2py = pyspark.ml.common._java2py\n\ndef _py2java(sc, obj):\n    \"\\\"\" Convert Python object into Java \"\\\"\"\n    if isinstance(obj, SparkSession):\n        return obj._jsparkSession\n    if isinstance(obj, Enum):\n        return getattr(\n            getattr(\n                sc._jvm.ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl,\n                obj.__class__.__name__\n            ),\n            'swigToEnum'\n        )(obj.value)\n    if isinstance(obj, datetime.timedelta):\n        return sc._jvm.java.time.Duration.ofMillis(obj // datetime.timedelta(milliseconds=1))\n    if isinstance(obj, JavaParams):\n        return obj._to_java()\n    if isinstance(obj, collections.OrderedDict):\n        return sc._jvm.java.util.LinkedHashMap(obj)\n    return _standard_py2java(sc, obj)\n\ndef _java2py(sc, r, encoding=\"bytes\"):\n    if isinstance(r, JavaObject):\n        enumValues = r.getClass().getEnumConstants()\n        if (enumValues is not None) and (len(enumValues) > 0):\n            return globals()[r.getClass().getSimpleName()](r.swigValue())\n\n        clsName = r.getClass().getName()\n        if clsName == 'java.time.Duration':\n            return datetime.timedelta(milliseconds=r.toMillis())\n        if clsName == 'ai.catboost.spark.Pool':\n            return Pool(r)\n        if clsName == 'java.util.LinkedHashMap':\n            return collections.OrderedDict(r)\n    return _standard_java2py(sc, r, encoding)\n\npyspark.ml.common._py2java = _py2java\npyspark.ml.common._java2py = _java2py\n\npyspark.ml.wrapper._py2java = _py2java\npyspark.ml.wrapper._java2py = _java2py\n\n\n@inherit_doc\nclass CatBoostMLReader(JavaMLReader):\n    \"\\\"\"\n    (Private) Specialization of :py:class:`JavaMLReader` for CatBoost types\n    \"\\\"\"\n\n    @classmethod\n    def _java_loader_class(cls, clazz):\n        \"\\\"\"\n        Returns the full class name of the Java ML instance.\n        \"\\\"\"\n        java_package = clazz.__module__.replace(\"catboost_spark.core\", \"ai.catboost.spark\")\n        print(\"CatBoostMLReader._java_loader_class. \", java_package + \".\" + clazz.__name__)\n        return java_package + \".\" + clazz.__name__\n\n"})).s((Seq)Nil$.MODULE$));
    }

    public <T> String jvmToPyValueAsString(T obj) {
        String string;
        if (obj instanceof Duration) {
            long durationInMilliseconds = ((Duration)obj).toMillis();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datetime.timedelta(milliseconds=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)durationInMilliseconds)}));
        } else {
            string = obj instanceof String ? new StringBuilder().append((Object)"\"").append((Object)obj.toString().replace("\t", "\\t")).append((Object)"\"").toString() : obj.toString();
        }
        return string;
    }

    public String generateParamsKeywordArgs(Params params) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])params.params()).map((Function1)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final Params params$1;

            public final String apply(Param<?> param) {
                Option option;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            option = this.params$1.getDefault(param);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object value = some.x();
                            string = Generator$.MODULE$.jvmToPyValueAsString(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        string = "None";
                    }
                    String value = string;
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{param.name(), value}));
                }
                throw new MatchError((Object)option);
            }
            {
                this.params$1 = params$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
    }

    public <Params> Map<String, String> getParamNameToPythonTypeMap(Params obj, TypeTags.TypeTag<Params> evidence$1) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Regex paramReg = new StringOps(Predef$.MODULE$.augmentString(".*Param\\[([\\w\\.]+)\\]")).r();
        Regex enumParamReg = new StringOps(Predef$.MODULE$.augmentString(".*EnumParam\\[([\\w\\.]+)\\]")).r();
        ((TypeTags)package$.MODULE$.universe()).typeOf(evidence$1).members().foreach((Function1)new Serializable(result, paramReg, enumParamReg){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map result$1;
            private final Regex paramReg$1;
            private final Regex enumParamReg$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Symbols.SymbolApi member) {
                Some pyType;
                Some some;
                String string = member.typeSignature().typeSymbol().name().toString();
                if ("BooleanParam".equals(string)) {
                    some = new Some((Object)"bool");
                } else if ("IntParam".equals(string)) {
                    some = new Some((Object)"int");
                } else if ("LongParam".equals(string)) {
                    some = new Some((Object)"long");
                } else if ("FloatParam".equals(string)) {
                    some = new Some((Object)"float");
                } else if ("DoubleParam".equals(string)) {
                    some = new Some((Object)"double");
                } else if ("StringParam".equals(string)) {
                    some = new Some((Object)"str");
                } else {
                    boolean bl = "StringArrayParam".equals(string) ? true : ("IntArrayParam".equals(string) ? true : ("LongArrayParam".equals(string) ? true : ("ByteArrayParam".equals(string) ? true : "DoubleArrayParam".equals(string))));
                    if (bl) {
                        some = new Some((Object)"list");
                    } else {
                        boolean bl2 = "MapArrayParam".equals(string) ? true : ("MapParam".equals(string) ? true : "OrderedStringMapParam".equals(string));
                        if (bl2) {
                            some = new Some((Object)"dict");
                        } else if ("DurationParam".equals(string)) {
                            some = new Some((Object)"datetime.timedelta");
                        } else if ("Param".equals(string)) {
                            Some some2;
                            String pType;
                            String string2 = member.typeSignature().toString();
                            Option option = this.paramReg$1.unapplySeq((CharSequence)string2);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0 || !(pType = (String)((LinearSeqOptimized)option.get()).apply(0)).equals("String")) throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected Param type: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.typeSignature().toString()})));
                            some = some2 = new Some((Object)"str");
                        } else if ("EnumParam".equals(string)) {
                            Some some3;
                            String string3 = member.typeSignature().toString();
                            Option option = this.enumParamReg$1.unapplySeq((CharSequence)string3);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EnumParam bad match: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.typeSignature().toString()})));
                            String enumType = (String)((LinearSeqOptimized)option.get()).apply(0);
                            some = some3 = new Some(Predef$.MODULE$.refArrayOps((Object[])enumType.split("\\.")).last());
                        } else {
                            some = None$.MODULE$;
                        }
                    }
                }
                Some some4 = pyType = some;
                if (some4 instanceof Some) {
                    Some some5 = some4;
                    String pyType2 = (String)some5.x();
                    return this.result$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)member.name().toString().trim()), (Object)pyType2));
                }
                if (!None$.MODULE$.equals(some4)) throw new MatchError((Object)some4);
                return BoxedUnit.UNIT;
            }
            {
                this.result$1 = result$1;
                this.paramReg$1 = paramReg$1;
                this.enumParamReg$1 = enumParamReg$1;
            }
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    public <Params> Set<String> getEnumNamesUsedInParams(Params obj, TypeTags.TypeTag<Params> evidence$2) {
        HashSet result = new HashSet();
        Regex enumReg = new StringOps(Predef$.MODULE$.augmentString(".*EnumParam\\[([\\w\\.]+)\\]")).r();
        ((TypeTags)package$.MODULE$.universe()).typeOf(evidence$2).members().foreach((Function1)new Serializable(result, enumReg){
            public static final long serialVersionUID = 0L;
            private final HashSet result$2;
            private final Regex enumReg$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Symbols.SymbolApi member) {
                None$ none$;
                String string = member.typeSignature().typeSymbol().name().toString();
                if ("EnumParam".equals(string)) {
                    String string2 = member.typeSignature().toString();
                    Option option = this.enumReg$1.unapplySeq((CharSequence)string2);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EnumParam bad match: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{member.typeSignature().toString()})));
                    String enumType = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String string3 = (String)Predef$.MODULE$.refArrayOps((Object[])enumType.split("\\.")).last();
                    none$ = this.result$2.$plus$eq((Object)string3);
                } else {
                    none$ = None$.MODULE$;
                }
                None$ none$2 = none$;
            }
            {
                this.result$2 = result$2;
                this.enumReg$1 = enumReg$1;
            }
        });
        return result.toSet();
    }

    public String patchJvmToPyEnumValue(Object enumValue) {
        String valueAsString = enumValue.toString();
        return valueAsString.equals("None") ? "No" : valueAsString;
    }

    public void generateEnumDefinitions(Set<String> enumNames, PrintWriter out) {
        Seq sortedEnumNames = (Seq)enumNames.toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        sortedEnumNames.foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            public final PrintWriter out$1;

            public final void apply(String enumName) {
                Class<?> enumClass = Class.forName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{enumName})));
                this.out$1.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nclass ", "(Enum):\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{enumName})));
                Object[] enumValues = enumClass.getEnumConstants();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(enumValues).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                        Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generateEnumDefinitions.1 $outer;

                    public final void apply(Tuple2<Object, Object> x$1) {
                        Tuple2<Object, Object> tuple2 = x$1;
                        if (tuple2 != null) {
                            Object enumValue = tuple2._1();
                            int idx = tuple2._2$mcI$sp();
                            this.$outer.out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Generator$.MODULE$.patchJvmToPyEnumValue(enumValue), BoxesRunTime.boxToInteger((int)idx)})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.out$1.println("");
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    public <ParamsClass> String generateParamsDocStrings(ParamsClass paramsClass, int tabShift, TypeTags.TypeTag<ParamsClass> evidence$3) {
        Map<String, String> paramNameToPythonTypeMap = this.getParamNameToPythonTypeMap(paramsClass, evidence$3);
        String tabOffset = new StringOps(Predef$.MODULE$.augmentString("    ")).$times(tabShift);
        Params params = (Params)paramsClass;
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])params.params()).map((Function1)new Serializable(paramNameToPythonTypeMap, tabOffset, params){
            public static final long serialVersionUID = 0L;
            private final Map paramNameToPythonTypeMap$1;
            private final String tabOffset$1;
            private final Params params$2;

            public final String apply(Param<?> param) {
                Option option;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            option = this.params$2.getDefault(param);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object value = some.x();
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Generator$.MODULE$.jvmToPyValueAsString(value)}));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        string = "";
                    }
                    String defaultValueDescription = string;
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", " : ", "", "\\n", "    ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tabOffset$1, param.name(), this.paramNameToPythonTypeMap$1.apply((Object)param.name()), defaultValueDescription, this.tabOffset$1, param.doc()}));
                }
                throw new MatchError((Object)option);
            }
            {
                this.paramNameToPythonTypeMap$1 = paramNameToPythonTypeMap$1;
                this.tabOffset$1 = tabOffset$1;
                this.params$2 = params$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
    }

    public String generateParamsInitialization(Params params) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])params.params()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Param<?> p) {
                String string = p.name();
                String string2 = "classWeights";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        })).map((Function1)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final Params params$3;

            public final String apply(Param<?> param) {
                Option option;
                block4: {
                    String string;
                    block3: {
                        String paramInit;
                        block2: {
                            paramInit = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"        self.", " = Param(self, \"", "\", \"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{param.name(), param.name(), param.doc()}));
                            option = this.params$3.getDefault(param);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Object value = some.x();
                            string = (String)new StringOps(Predef$.MODULE$.augmentString(paramInit)).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n        self._setDefault(", "=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{param.name(), Generator$.MODULE$.jvmToPyValueAsString(value)})))), Predef$.MODULE$.StringCanBuildFrom());
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        string = paramInit;
                    }
                    return string;
                }
                throw new MatchError((Object)option);
            }
            {
                this.params$3 = params$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
    }

    public <ParamsClass> String generateParamsGettersAndSetters(ParamsClass paramsClass, TypeTags.TypeTag<ParamsClass> evidence$4) {
        Map<String, String> paramNameToPythonTypeMap = this.getParamNameToPythonTypeMap(paramsClass, evidence$4);
        Params params = (Params)paramsClass;
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])params.params()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Param<?> p) {
                String string = p.name();
                String string2 = "classWeights";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        })).map((Function1)new Serializable(paramNameToPythonTypeMap){
            public static final long serialVersionUID = 0L;
            private final Map paramNameToPythonTypeMap$2;

            public final String apply(Param<?> param) {
                String nameInMethods = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, param.name());
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    def get", "(self):\n        \"\\\"\"\n        Returns\n        -------\n        ", "\n            ", "\n        \"\\\"\"\n        return self.getOrDefault(self.", ")\n\n    def set", "(self, value):\n        \"\\\"\"\n        Parameters\n        ----------\n        value : ", "\n            ", "\n        \"\\\"\"\n        self._set(", "=value)\n        return self\n\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nameInMethods, this.paramNameToPythonTypeMap$2.apply((Object)param.name()), param.doc(), param.name(), nameInMethods, this.paramNameToPythonTypeMap$2.apply((Object)param.name()), param.doc(), param.name()}));
            }
            {
                this.paramNameToPythonTypeMap$2 = paramNameToPythonTypeMap$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
    }

    public <Params> String generateParamsPart(Params params, String paramsKeywordArgs, TypeTags.TypeTag<Params> evidence$5) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    @keyword_only\n    def setParams(self, ", "):\n        \"\\\"\"\n        Set the (keyword only) parameters\n\n        Parameters\n        ----------\n", "\n        \"\\\"\"\n        if hasattr(self, \"_input_kwargs\"):\n            kwargs = self._input_kwargs\n        else:\n            kwargs = self.__init__._input_kwargs\n        return self._set(**kwargs)\n\n", "\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramsKeywordArgs, this.generateParamsDocStrings(params, 2, evidence$5), this.generateParamsGettersAndSetters(params, evidence$5)}));
    }

    public <ParamsClass> void generateStandardParamsWrapper(ParamsClass params, PrintWriter out, TypeTags.TypeTag<ParamsClass> evidence$6) {
        Params paramsAsParamsClass = (Params)params;
        String paramsKeywordArgs = this.generateParamsKeywordArgs(paramsAsParamsClass);
        String pyClassName = params.getClass().getSimpleName();
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nclass ", "(JavaParams):\n    \"\\\"\"\n    Parameters\n    ----------\n", "\n    \"\\\"\"\n\n    @keyword_only\n    def __init__(self, ", "):\n        super(", ", self).__init__()\n        self._java_obj = self._new_java_obj(\"", "\")\n", "\n\n        if hasattr(self, \"_input_kwargs\"):\n            kwargs = self._input_kwargs\n        else:\n            kwargs = self.__init__._input_kwargs\n        self.setParams(**kwargs)\n\n", "\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pyClassName, this.generateParamsDocStrings(params, 1, evidence$6), paramsKeywordArgs, pyClassName, params.getClass().getCanonicalName(), this.generateParamsInitialization(paramsAsParamsClass), this.generateParamsPart(params, paramsKeywordArgs, evidence$6)})));
    }

    public String generateForwardedAccessors(Seq<Tuple2<String, String>> accessors) {
        return ((TraversableOnce)accessors.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String accessor = (String)tuple2._1();
                    String docString = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    def ", "(self):\n        \"\\\"\"\n        ", "\n        \"\\\"\"\n        return self._call_java(\"", "\")\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accessor, docString, accessor}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public void generatePoolSerializationWrappers(PrintWriter out) {
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nclass PoolReader(JavaWrapper):\n    \"\\\"\"\n    This class is used to load a :class:`Pool` from external storage systems (it is analogous to PySpark's DataFrameReader).\n    Use Pool.read() to get it.\n    \"\\\"\"\n    def __init__(self, sparkSession: \"SparkSession\"):\n        super(PoolReader, self).__init__(JavaWrapper._new_java_obj(\"ai.catboost.spark.PoolReader\", sparkSession))\n\n    def dataFramesReaderFormat(self, source: str) -> \"PoolReader\":\n        self._java_obj = self._java_obj.dataFramesReaderFormat(source)\n        return self\n\n    def dataFramesReaderOption(self, key: str, value: \"OptionalPrimitiveType\") -> \"PoolReader\":\n        self._java_obj = self._java_obj.dataFramesReaderOption(key, to_str(value))\n        return self\n\n    def dataFramesReaderOptions(self, **options: \"OptionalPrimitiveType\") -> \"PoolReader\":\n        for k in options:\n            self._java_obj = self._java_obj.dataFramesReaderOption(key, to_str(options[k]))\n        return self\n\n    def load(self, path: str) -> \"Pool\":\n        return Pool(self._java_obj.load(path))\n\n\nclass PoolWriter(JavaWrapper):\n    \"\\\"\"\n    This class is used to save :class:`Pool` to external storage systems (it is analogous to PySpark's DataFrameWriter).\n      Use Pool.write() to get it.\n    \"\\\"\"\n    def __init__(self, pool: \"Pool\"):\n        super(PoolWriter, self).__init__(pool._java_obj.write())\n\n    def dataFramesWriterFormat(self, source: str) -> \"PoolWriter\":\n        self._java_obj = self._java_obj.dataFramesWriterFormat(source)\n        return self\n\n    def dataFramesWriterOption(self, key: str, value: \"OptionalPrimitiveType\") -> \"PoolWriter\":\n        self._java_obj = self._java_obj.dataFramesWriterOption(key, to_str(value))\n        return self\n\n    def dataFramesWriterOptions(self, **options: \"OptionalPrimitiveType\") -> \"PoolWriter\":\n        for k in options:\n            self._java_obj = self._java_obj.dataFramesWriterOption(key, to_str(options[k]))\n        return self\n\n    def mode(self, saveModeArg: str) -> \"PoolWriter\":\n        self._java_obj = self._java_obj.mode(saveModeArg)\n        return self\n\n    def save(self, path: str) -> None:\n        self._java_obj.save(path)\n\n"})).s((Seq)Nil$.MODULE$));
    }

    public void generatePoolWrapper(PrintWriter out) {
        this.generatePoolSerializationWrappers(out);
        Pool pool = new Pool(null);
        String paramsKeywordArgs = this.generateParamsKeywordArgs((Params)pool);
        Seq forwardedAccessors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"isQuantized", (Object)"Returns whether the main `data` has already been quantized."), new Tuple2((Object)"getFeatureCount", (Object)"Returns the number of features."), new Tuple2((Object)"getFeatureNames", (Object)"Returns the list of feature names."), new Tuple2((Object)"count", (Object)"Returns the number of rows in the main `data` DataFrame."), new Tuple2((Object)"pairsCount", (Object)"Returns the number of rows in the `pairsData` DataFrame."), new Tuple2((Object)"getBaselineCount", (Object)"Returns the dimension of the baseline data (0 if not specified).")}));
        Object[] objectArray = new Object[3];
        objectArray[0] = this.generateParamsInitialization((Params)pool);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.Pool").asType().toTypeConstructor();
            }

            public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$1() {
            }
        }
        objectArray[1] = this.generateParamsPart(pool, paramsKeywordArgs, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$1()));
        objectArray[2] = this.generateForwardedAccessors((Seq<Tuple2<String, String>>)forwardedAccessors);
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nclass Pool(JavaParams):\n    \"\\\"\"\n    CatBoost's abstraction of a dataset.\n    Features data can be stored in raw (features column has pyspark.ml.linalg.Vector type)\n    or quantized (float feature values are quantized into integer bin values, features column has\n    Array[Byte] type) form.\n\n    Raw Pool can be transformed to quantized form using `quantize` method.\n    This is useful if this dataset is used for training multiple times and quantization parameters do not\n    change. Pre-quantized Pool allows to cache quantized features data and so do not re-run\n    feature quantization step at the start of an each training.\n    \"\\\"\"\n    def __init__(self, data_frame_or_java_object, pairs_data_frame=None):\n        \"\\\"\"\n        Construct Pool from DataFrame, optionally specifying pairs data in an additional DataFrame.\n        \"\\\"\"\n        if isinstance(data_frame_or_java_object, JavaObject):\n            java_obj = data_frame_or_java_object\n        else:\n            java_obj = JavaWrapper._new_java_obj(\"ai.catboost.spark.Pool\", data_frame_or_java_object, pairs_data_frame)\n\n        super(Pool, self).__init__(java_obj)\n", "\n\n", "\n\n    def _call_java(self, name, *args):\n        self._transfer_params_to_java()\n        return JavaWrapper._call_java(self, name, *args)\n\n", "\n\n    @property\n    def data(self):\n        \"\\\"\"\n        DataFrame with the main data (features, label, (optionally) weight etc.)\n        \"\\\"\"\n        return self._call_java(\"data\")\n\n    @property\n    def pairsData(self):\n        \"\\\"\"\n        DataFrame with the pairs data (groupId, winnerId, loserId and optionally weight).\n        Can be None.\n        \"\\\"\"\n        return self._call_java(\"pairsData\")\n\n    def quantize(self, quantizationParams = None):\n        \"\\\"\"Create Pool with quantized features from Pool with raw features\"\\\"\"\n        if quantizationParams is None:\n            quantizationParams = QuantizationParams()\n        return self._call_java(\"quantize\", quantizationParams)\n\n    def repartition(self, partitionCount, byGroupColumnsIfPresent):\n        \"\\\"\"\n        Repartion data to the specified number of partitions.\n        Useful to repartition data to create one partition per executor for training\n        (where each executor gets its' own CatBoost worker with a part of the training data).\n        \"\\\"\"\n        return self._call_java(\"repartition\", partitionCount, byGroupColumnsIfPresent)\n\n    @staticmethod\n    def load(sparkSession, dataPathWithScheme, columnDescription=None, poolLoadParams=None, pairsDataPathWithScheme=None):\n        \"\\\"\"\n        Load dataset in one of CatBoost's natively supported formats:\n           * dsv - https://catboost.ai/docs/concepts/input-data_values-file.html\n           * libsvm - https://catboost.ai/docs/concepts/input-data_libsvm.html\n\n        Parameters\n        ----------\n        sparkSession : SparkSession\n        dataPathWithScheme : str\n            Path with scheme to dataset in CatBoost format.\n            For example, `dsv:///home/user/datasets/my_dataset/train.dsv` or\n            `libsvm:///home/user/datasets/my_dataset/train.libsvm`\n        columnDescription : str, optional\n            Path to column description file. See https://catboost.ai/docs/concepts/input-data_column-descfile.html\n        params : PoolLoadParams, optional\n            Additional params specifying data format.\n        pairsDataPathWithScheme : str, optional\n            Path with scheme to dataset pairs in CatBoost format.\n            Only \"dsv-grouped\" format is supported for now.\n            For example, `dsv-grouped:///home/user/datasets/my_dataset/train_pairs.dsv`\n\n        Returns\n        -------\n           Pool\n               Pool containing loaded data\n        \"\\\"\"\n        if poolLoadParams is None:\n            poolLoadParams = PoolLoadParams()\n        sc = sparkSession.sparkContext\n        java_obj = sc._jvm.ai.catboost.spark.Pool.load(\n            _py2java(sc, sparkSession),\n            dataPathWithScheme,\n            (sc._jvm.java.nio.file.Paths.get(columnDescription, sc._gateway.new_array(sc._jvm.String, 0))\n             if columnDescription\n             else None\n            ),\n            _py2java(sc, poolLoadParams),\n            pairsDataPathWithScheme\n        )\n        return Pool(java_obj)\n\n    @staticmethod\n    def read(sparkSession) -> \"PoolReader\":\n        \"\\\"\"\n        Interface for reading the content from external storage (API similar to PySpark's DataFrameReader)\n\n        Returns\n        -------\n            PoolReader\n                PoolReader helper class to read Pool data\n        \"\\\"\"\n        return PoolReader(sparkSession)\n\n    @property\n    def write(self) -> \"PoolWriter\":\n        \"\\\"\"\n        Interface for saving the content out into external storage (API similar to PySpark's DataFrameWriter)\n\n        Returns\n        -------\n            PoolWriter\n                PoolWriter helper class to save Pool data\n        \"\\\"\"\n        return PoolWriter(self)\n\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
    }

    public <EstimatorClass, ModelClass> void generateEstimatorAndModelWrapper(EstimatorClass estimator, ModelClass model, String modelBaseClassName, String estimatorDoc, String modelDoc, String sparkCompatVersion, PrintWriter out, TypeTags.TypeTag<EstimatorClass> evidence$7, TypeTags.TypeTag<ModelClass> evidence$8) {
        String estimatorClassName = (String)Predef$.MODULE$.refArrayOps((Object[])((TypeTags)package$.MODULE$.universe()).typeOf(evidence$7).typeSymbol().name().toString().split("\\.")).last();
        Params estimatorAsParams = (Params)estimator;
        String estimatorParamsKeywordArgs = this.generateParamsKeywordArgs(estimatorAsParams);
        String modelClassName = (String)Predef$.MODULE$.refArrayOps((Object[])((TypeTags)package$.MODULE$.universe()).typeOf(evidence$8).typeSymbol().name().toString().split("\\.")).last();
        Params modelAsParams = (Params)model;
        String modelParamsKeywordArgs = this.generateParamsKeywordArgs(modelAsParams);
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n\n@inherit_doc\nclass ", "(JavaEstimator, MLReadable, JavaMLWritable):\n    \"\\\"\"\n    ", "\n\n    Init Parameters\n    ---------------\n", "\n    \"\\\"\"\n\n    @keyword_only\n    def __init__(self, ", "):\n        super(", ", self).__init__()\n        self._java_obj = self._new_java_obj(\"ai.catboost.spark.", "\")\n", "\n\n        if hasattr(self, \"_input_kwargs\"):\n            kwargs = self._input_kwargs\n        else:\n            kwargs = self.__init__._input_kwargs\n        self.setParams(**kwargs)\n\n", "\n\n    @classmethod\n    def read(cls):\n        \"\\\"\"Returns an MLReader instance for this class.\"\\\"\"\n        return CatBoostMLReader(cls)\n\n    def _create_model(self, java_model):\n        return ", "(java_model)\n\n    def _fit_with_eval(self, trainDatasetAsJavaObject, evalDatasetsAsJavaObject, params=None):\n        \"\\\"\"\n        Implementation of fit with eval datasets with no more than one set of optional parameters\n        \"\\\"\"\n        if params:\n            return self.copy(params)._fit_with_eval(trainDatasetAsJavaObject, evalDatasetsAsJavaObject)\n        else:\n            self._transfer_params_to_java()\n            java_model = self._java_obj.fit(trainDatasetAsJavaObject, evalDatasetsAsJavaObject)\n            return ", "(java_model)\n\n    def fit(self, dataset, params=None, evalDatasets=None):\n        \"\\\"\"\n        Extended variant of standard Estimator's fit method\n        that accepts CatBoost's Pool s and allows to specify additional\n        datasets for computing evaluation metrics and overfitting detection similarily to CatBoost's other APIs.\n\n        Parameters\n        ----------\n        dataset : Pool or DataFrame\n          The input training dataset.\n        params : dict or list or tuple, optional\n          an optional param map that overrides embedded params. If a list/tuple of\n          param maps is given, this calls fit on each param map and returns a list of\n          models.\n        evalDatasets : Pools, optional\n          The validation datasets used for the following processes:\n           - overfitting detector\n           - best iteration selection\n           - monitoring metrics' changes\n\n        Returns\n        -------\n        trained model(s): ", " or a list of trained ", "\n        \"\\\"\"\n        if (isinstance(dataset, DataFrame)):\n            if evalDatasets is not None:\n                raise RuntimeError(\"if dataset has type DataFrame no evalDatasets are supported\")\n            return JavaEstimator.fit(self, dataset, params)\n        else:\n            sc = SparkContext._active_spark_context\n\n            trainDatasetAsJavaObject = _py2java(sc, dataset)\n            evalDatasetCount = 0 if (evalDatasets is None) else len(evalDatasets)\n\n            # need to create it because default mapping for python list is ArrayList, not Array\n            evalDatasetsAsJavaObject = sc._gateway.new_array(sc._jvm.ai.catboost.spark.Pool, evalDatasetCount)\n            for i in range(evalDatasetCount):\n                evalDatasetsAsJavaObject[i] = _py2java(sc, evalDatasets[i])\n\n            def _fit_with_eval(params):\n                return self._fit_with_eval(trainDatasetAsJavaObject, evalDatasetsAsJavaObject, params)\n\n            if (params is None) or isinstance(params, dict):\n                return _fit_with_eval(params)\n            if isinstance(params, (list, tuple)):\n                models = []\n                for paramsInstance in params:\n                    models.append(_fit_with_eval(paramsInstance))\n                return models\n            else:\n                raise TypeError(\"Params must be either a param map or a list/tuple of param maps, \"\n                                \"but got %s.\" % type(params))\n\n@inherit_doc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimatorClassName, estimatorDoc, this.generateParamsDocStrings(estimator, 2, evidence$7), estimatorParamsKeywordArgs, estimatorClassName, estimatorClassName, this.generateParamsInitialization(estimatorAsParams), this.generateParamsPart(estimator, estimatorParamsKeywordArgs, evidence$7), modelClassName, modelClassName, modelClassName, modelClassName})));
        if (sparkCompatVersion.startsWith("3.")) {
            out.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"class ", "(", ", MLReadable, JavaMLWritable):"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelClassName, modelBaseClassName})));
        } else {
            out.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"class ", "(JavaModel, ", ", MLReadable, JavaMLWritable):"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelClassName, modelBaseClassName})));
        }
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    \"\\\"\"\n    ", "\n    \"\\\"\"\n    def __init__(self, java_model=None):\n        super(", ", self).__init__(java_model)\n", "\n        if java_model is not None:\n            self._transfer_params_from_java()\n\n", "\n\n    @staticmethod\n    def _from_java(java_model):\n        return ", "(java_model)\n\n    @classmethod\n    def read(cls):\n        \"\\\"\"Returns an MLReader instance for this class.\"\\\"\"\n        return CatBoostMLReader(cls)\n\n    def saveNativeModel(self, fileName, format=EModelType.CatboostBinary, exportParameters=None, pool=None):\n        \"\\\"\"\n        Save the model to a local file.\n        See https://catboost.ai/docs/concepts/python-reference_catboostclassifier_save_model.html\n        for detailed parameters description\n        \"\\\"\"\n        return self._call_java(\"saveNativeModel\", fileName, format, exportParameters, pool)\n\n    @staticmethod\n    def loadNativeModel(fileName, format=EModelType.CatboostBinary):\n        \"\\\"\"\n        Load the model from a local file.\n        See https://catboost.ai/docs/concepts/python-reference_catboostclassifier_load_model.html\n        for detailed parameters description\n        \"\\\"\"\n        sc = SparkContext._active_spark_context\n        java_model = sc._jvm.ai.catboost.spark.", ".loadNativeModel(fileName, _py2java(sc, format))\n        return ", "(java_model)\n\n\n    def transformPool(self, pool):\n        \"\\\"\"\n        This function is useful when the dataset has been already quantized but works with any Pool\n        \"\\\"\"\n        return self._call_java(\"transformPool\", pool)\n\n\n    def getFeatureImportance(self,\n                             fstrType=EFstrType.FeatureImportance,\n                             data=None,\n                             calcType=ECalcTypeShapValues.Regular\n                            ):\n        \"\\\"\"\n        Parameters\n        ----------\n        fstrType : EFstrType\n            Supported values are FeatureImportance, PredictionValuesChange, LossFunctionChange, PredictionDiff\n        data : Pool\n            if fstrType is PredictionDiff it is required and must contain 2 samples\n            if fstrType is PredictionValuesChange this param is required in case if model was explicitly trained\n            with flag to store no leaf weights.\n            otherwise it can be null\n        calcType : ECalcTypeShapValues\n            Used only for PredictionValuesChange.\n            Possible values:\n              - Regular\n                 Calculate regular SHAP values\n              - Approximate\n                 Calculate approximate SHAP values\n              - Exact\n                 Calculate exact SHAP values\n\n        Returns\n        -------\n        list of float\n            array of feature importances (index corresponds to the order of features in the model)\n        \"\\\"\"\n        return self._call_java(\"getFeatureImportance\", fstrType, data, calcType)\n\n    def getFeatureImportancePrettified(self,\n                                       fstrType=EFstrType.FeatureImportance,\n                                       data=None,\n                                       calcType=ECalcTypeShapValues.Regular\n                                      ):\n        \"\\\"\"\n        Parameters\n        ----------\n        fstrType : EFstrType\n            Supported values are FeatureImportance, PredictionValuesChange, LossFunctionChange, PredictionDiff\n        data : Pool\n            if fstrType is PredictionDiff it is required and must contain 2 samples\n            if fstrType is PredictionValuesChange this param is required in case if model was explicitly trained\n            with flag to store no leaf weights.\n            otherwise it can be null\n        calcType : ECalcTypeShapValues\n            Used only for PredictionValuesChange.\n            Possible values:\n\n              - Regular\n                 Calculate regular SHAP values\n              - Approximate\n                 Calculate approximate SHAP values\n              - Exact\n                 Calculate exact SHAP values\n\n        Returns\n        -------\n        list of FeatureImportance\n            array of feature importances sorted in descending order by importance\n        \"\\\"\"\n        return self._call_java(\"getFeatureImportancePrettified\", fstrType, data, calcType)\n\n    def getFeatureImportanceShapValues(self,\n                                       data,\n                                       preCalcMode=EPreCalcShapValues.Auto,\n                                       calcType=ECalcTypeShapValues.Regular,\n                                       modelOutputType=EExplainableModelOutput.Raw,\n                                       referenceData=None,\n                                       outputColumns=None\n                                      ):\n        \"\\\"\"\n        Parameters\n        ----------\n        data : Pool\n            dataset to calculate SHAP values for\n        preCalcMode : EPreCalcShapValues\n            Possible values:\n               - Auto\n                  Use direct SHAP Values calculation only if data size is smaller than average leaves number\n                  (the best of two strategies below is chosen).\n               - UsePreCalc\n                  Calculate SHAP Values for every leaf in preprocessing. Final complexity is\n                  O(NT(D+F))+O(TL^2 D^2) where N is the number of documents(objects), T - number of trees,\n                  D - average tree depth, F - average number of features in tree, L - average number of leaves in tree\n                  This is much faster (because of a smaller constant) than direct calculation when N >> L\n               - NoPreCalc\n                  Use direct SHAP Values calculation calculation with complexity O(NTLD^2). Direct algorithm\n                  is faster when N < L (algorithm from https://arxiv.org/abs/1802.03888)\n        calcType : ECalcTypeShapValues\n            Possible values:\n\n              - Regular\n                 Calculate regular SHAP values\n              - Approximate\n                 Calculate approximate SHAP values\n              - Exact\n                 Calculate exact SHAP values\n        referenceData : Pool\n            reference data for Independent Tree SHAP values from https://arxiv.org/abs/1905.04610v1\n            if referenceData is not null, then Independent Tree SHAP values are calculated\n        outputColumns : list of str\n            columns from data to add to output DataFrame, if None - add all columns\n\n        Returns\n        -------\n        DataFrame\n            - for regression and binclass models:\n              contains outputColumns and \"shapValues\" column with Vector of length (n_features + 1) with SHAP values\n            - for multiclass models:\n              contains outputColumns and \"shapValues\" column with Matrix of shape (n_classes x (n_features + 1)) with SHAP values\n        \"\\\"\"\n        return self._call_java(\n            \"getFeatureImportanceShapValues\",\n            data,\n            preCalcMode,\n            calcType,\n            modelOutputType,\n            referenceData,\n            outputColumns\n        )\n\n    def getFeatureImportanceShapInteractionValues(self,\n                                                  data,\n                                                  featureIndices=None,\n                                                  featureNames=None,\n                                                  preCalcMode=EPreCalcShapValues.Auto,\n                                                  calcType=ECalcTypeShapValues.Regular,\n                                                  outputColumns=None):\n        \"\\\"\"\n        SHAP interaction values are calculated for all features pairs if nor featureIndices nor featureNames\n          are specified.\n\n        Parameters\n        ----------\n        data : Pool\n            dataset to calculate SHAP interaction values\n        featureIndices : (int, int), optional\n            pair of features indices to calculate SHAP interaction values for.\n        featureNames : (str, str), optional\n            pair of features names to calculate SHAP interaction values for.\n        preCalcMode : EPreCalcShapValues\n            Possible values:\n\n            - Auto\n                Use direct SHAP Values calculation only if data size is smaller than average leaves number\n                (the best of two strategies below is chosen).\n            - UsePreCalc\n                Calculate SHAP Values for every leaf in preprocessing. Final complexity is\n                O(NT(D+F))+O(TL^2 D^2) where N is the number of documents(objects), T - number of trees,\n                D - average tree depth, F - average number of features in tree, L - average number of leaves in tree\n                This is much faster (because of a smaller constant) than direct calculation when N >> L\n            - NoPreCalc\n                Use direct SHAP Values calculation calculation with complexity O(NTLD^2). Direct algorithm\n                is faster when N < L (algorithm from https://arxiv.org/abs/1802.03888)\n        calcType : ECalcTypeShapValues\n            Possible values:\n\n              - Regular\n                  Calculate regular SHAP values\n              - Approximate\n                  Calculate approximate SHAP values\n              - Exact\n                  Calculate exact SHAP values\n        outputColumns : list of str\n            columns from data to add to output DataFrame, if None - add all columns\n\n        Returns\n        -------\n        DataFrame\n            - for regression and binclass models:\n              contains outputColumns and \"featureIdx1\", \"featureIdx2\", \"shapInteractionValue\" columns\n            - for multiclass models:\n              contains outputColumns and \"classIdx\", \"featureIdx1\", \"featureIdx2\", \"shapInteractionValue\" columns\n        \"\\\"\"\n        return self._call_java(\n            \"getFeatureImportanceShapInteractionValues\",\n            data,\n            featureIndices,\n            featureNames,\n            preCalcMode,\n            calcType,\n            outputColumns\n        )\n\n    def getFeatureImportanceInteraction(self):\n        \"\\\"\"\n        Returns\n        -------\n        list of FeatureInteractionScore\n        \"\\\"\"\n        return self._call_java(\"getFeatureImportanceInteraction\")\n\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelDoc, modelClassName, this.generateParamsInitialization(modelAsParams), this.generateParamsPart(model, modelParamsKeywordArgs, evidence$8), modelClassName, modelClassName, modelClassName})));
        if (!sparkCompatVersion.startsWith("3.")) {
            String string = modelBaseClassName;
            String string2 = "JavaClassificationModel";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    def predictRaw(self, value):\n        \"\\\"\"\n        Raw prediction for each possible label.\n        \"\\\"\"\n        return self._call_java(\"predictRaw\", value)\n\n    def predictProbability(self, value):\n        \"\\\"\"\n        Predict the probability of each class given the features.\n        \"\\\"\"\n        return self._call_java(\"predictProbability\", value)\n"})).s((Seq)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateVersionPy(File modulePath, String version) {
        PrintWriter versionPyWriter = new PrintWriter(new File(modulePath, "version.py"));
        try {
            versionPyWriter.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VERSION = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})));
            versionPyWriter.close();
            return;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateInitPy(File modulePath, Set<String> enumsUsedInParams) {
        Seq exportList = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PoolLoadParams", "QuantizationParams", "PoolReader", "PoolWriter", "Pool", "CatBoostClassificationModel", "CatBoostClassifier", "CatBoostRegressionModel", "CatBoostRegressor"}))).$plus$plus((GenTraversableOnce)enumsUsedInParams.toSeq().sorted((Ordering)Ordering.String$.MODULE$), Seq$.MODULE$.canBuildFrom());
        PrintWriter initPyWriter = new PrintWriter(new File(modulePath, "__init__.py"));
        try {
            initPyWriter.print("\nfrom .version import VERSION as __version__  # noqa\nfrom .core import (\n");
            exportList.foreach((Function1)new Serializable(initPyWriter){
                public static final long serialVersionUID = 0L;
                private final PrintWriter initPyWriter$1;

                public final void apply(String symbol) {
                    this.initPyWriter$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{symbol})));
                }
                {
                    this.initPyWriter$1 = initPyWriter$1;
                }
            });
            initPyWriter.print("\n)\n__all__ = [\n");
            exportList.foreach((Function1)new Serializable(initPyWriter){
                public static final long serialVersionUID = 0L;
                private final PrintWriter initPyWriter$1;

                public final void apply(String symbol) {
                    this.initPyWriter$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    '", "',"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{symbol})));
                }
                {
                    this.initPyWriter$1 = initPyWriter$1;
                }
            });
            initPyWriter.println("]");
            initPyWriter.close();
            return;
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void main(String[] args) {
        String string;
        String string2;
        String sparkCompatVersion = args[2];
        File modulePath = new File(args[1]);
        modulePath.mkdirs();
        this.generateVersionPy(modulePath, args[0]);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class typecreator2.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.params.QuantizationParams").asType().toTypeConstructor();
            }

            public typecreator2.1() {
            }
        }
        public final class typecreator3.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.Pool").asType().toTypeConstructor();
            }

            public typecreator3.1() {
            }
        }
        public final class typecreator4.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.CatBoostClassifier").asType().toTypeConstructor();
            }

            public typecreator4.1() {
            }
        }
        public final class typecreator5.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.CatBoostRegressor").asType().toTypeConstructor();
            }

            public typecreator5.1() {
            }
        }
        Set enumsUsedInParams = (Set)this.getEnumNamesUsedInParams(new QuantizationParams(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new typecreator2.1())).$plus$plus(this.getEnumNamesUsedInParams(new Pool(null), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new typecreator3.1()))).$plus$plus(this.getEnumNamesUsedInParams(new CatBoostClassifier(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new typecreator4.1()))).$plus$plus(this.getEnumNamesUsedInParams(new CatBoostRegressor(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new typecreator5.1()))).$plus((Object)"EModelType").$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EFstrType", "ECalcTypeShapValues", "EPreCalcShapValues", "EExplainableModelOutput"})));
        this.generateInitPy(modulePath, (Set<String>)enumsUsedInParams);
        PrintWriter corePyWriter = new PrintWriter(new File(modulePath, "core.py"));
        this.generateCorePyPrologue(sparkCompatVersion, corePyWriter);
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class typecreator6.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.params.PoolLoadParams").asType().toTypeConstructor();
            }

            public typecreator6.1() {
            }
        }
        this.generateStandardParamsWrapper(new PoolLoadParams(), corePyWriter, ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new typecreator6.1()));
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class typecreator7.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.params.QuantizationParams").asType().toTypeConstructor();
            }

            public typecreator7.1() {
            }
        }
        this.generateStandardParamsWrapper(new QuantizationParams(), corePyWriter, ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new typecreator7.1()));
        this.generatePoolWrapper(corePyWriter);
        this.generateEnumDefinitions((Set<String>)enumsUsedInParams, corePyWriter);
        CatBoostRegressor catBoostRegressor = new CatBoostRegressor();
        CatBoostRegressionModel catBoostRegressionModel = new CatBoostRegressionModel(new TFullModel());
        String string3 = sparkCompatVersion;
        if ("3.0".equals(string3)) {
            string2 = "JavaRegressionModel";
        } else {
            boolean bl = "3.1".equals(string3) ? true : ("3.2".equals(string3) ? true : ("3.3".equals(string3) ? true : "3.4".equals(string3)));
            string2 = bl ? "_JavaRegressionModel" : "JavaPredictionModel";
        }
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class typecreator8.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.CatBoostRegressor").asType().toTypeConstructor();
            }

            public typecreator8.1() {
            }
        }
        public final class typecreator9.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.CatBoostRegressionModel").asType().toTypeConstructor();
            }

            public typecreator9.1() {
            }
        }
        this.generateEstimatorAndModelWrapper(catBoostRegressor, catBoostRegressionModel, string2, "Class to train CatBoostRegressionModel", "Regression model trained by CatBoost. Use CatBoostRegressor to train it", sparkCompatVersion, corePyWriter, ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new typecreator8.1()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new typecreator9.1()));
        CatBoostClassifier catBoostClassifier = new CatBoostClassifier();
        CatBoostClassificationModel catBoostClassificationModel = new CatBoostClassificationModel(new TFullModel());
        String string4 = sparkCompatVersion;
        if ("3.0".equals(string4)) {
            string = "JavaProbabilisticClassificationModel";
        } else {
            boolean bl = "3.1".equals(string4) ? true : ("3.2".equals(string4) ? true : ("3.3".equals(string4) ? true : "3.4".equals(string4)));
            string = bl ? "_JavaProbabilisticClassificationModel" : "JavaClassificationModel";
        }
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class typecreator10.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.CatBoostClassifier").asType().toTypeConstructor();
            }

            public typecreator10.1() {
            }
        }
        public final class typecreator11.1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.CatBoostClassificationModel").asType().toTypeConstructor();
            }

            public typecreator11.1() {
            }
        }
        this.generateEstimatorAndModelWrapper(catBoostClassifier, catBoostClassificationModel, string, "Class to train CatBoostClassificationModel", "Classification model trained by CatBoost. Use CatBoostClassifier to train it", sparkCompatVersion, corePyWriter, ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new typecreator10.1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new typecreator11.1()));
        corePyWriter.close();
        throw scala.sys.package$.MODULE$.exit(0);
        {
            catch (Throwable throwable) {
                try {
                    void var14_13;
                    var14_13.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                    throw scala.sys.package$.MODULE$.exit(1);
                }
            }
        }
    }

    private Generator$() {
        MODULE$ = this;
    }
}

