/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.CatBoostError;
import ai.catboost.spark.TrainingDriver$;
import ai.catboost.spark.WorkerInfo;
import ai.catboost.spark.impl.RunClassInNewProcess$;
import ai.catboost.spark.impl.ShutdownWorkersApp$;
import ai.catboost.spark.impl.TimeHelpers$;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001U4Q!\u0004\b\u0001\u001dQA\u0001\"\r\u0001\u0003\u0006\u0004%Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005i!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015A\u0005\u0001\"\u0001N\u0011\u0015)\u0006\u0001\"\u0003W\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015Y\u0007\u0001\"\u0001k\u0011\u0015a\u0007\u0001\"\u00014\u0011\u0015i\u0007\u0001\"\u0001o\u0005Q)\u0006\u000fZ1uC\ndWmV8sW\u0016\u00148/\u00138g_*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\t\u0001bY1uE>|7\u000f\u001e\u0006\u0002'\u0005\u0011\u0011-[\n\u0006\u0001Ui\u0002E\n\t\u0003-mi\u0011a\u0006\u0006\u00031e\tA\u0001\\1oO*\t!$\u0001\u0003kCZ\f\u0017B\u0001\u000f\u0018\u0005\u0019y%M[3diB\u0011aCH\u0005\u0003?]\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003Ge\t!![8\n\u0005\u0015\u0012#!C\"m_N,\u0017M\u00197f!\t9s&D\u0001)\u0015\tI#&\u0001\u0005j]R,'O\\1m\u0015\ty1F\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019)\u0005\u001daunZ4j]\u001e\f1b^8sW\u0016\u00148/\u00138g_\u000e\u0001Q#\u0001\u001b\u0011\u0007UB$(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0015\t%O]1z!\tYD(D\u0001\u000f\u0013\tidB\u0001\u0006X_J\\WM]%oM>\fAb^8sW\u0016\u00148/\u00138g_\u0002\nAb]3sm\u0016\u00148k\\2lKR,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tf\t1A\\3u\u0013\t15I\u0001\u0007TKJ4XM]*pG.,G/A\u0007tKJ4XM]*pG.,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)[E\n\u0005\u0002<\u0001!)\u0011'\u0002a\u0001i!)q(\u0002a\u0001\u0003R\u0019!JT*\t\u000b=3\u0001\u0019\u0001)\u0002\u001b1L7\u000f^3oS:<\u0007k\u001c:u!\t)\u0014+\u0003\u0002Sm\t\u0019\u0011J\u001c;\t\u000bQ3\u0001\u0019\u0001)\u0002\u0017]|'o[3s\u0007>,h\u000e^\u0001\u001bC\u000e\u001cW\r\u001d;B]\u0012\u0004&o\\2fgN<vN]6fe&sgm\u001c\u000b\u0003/j\u0003\"!\u000e-\n\u0005e3$\u0001B+oSRDQaW\u0004A\u0002q\u000b\u0001bY1mY\n\f7m\u001b\t\u0005kuSt+\u0003\u0002_m\tIa)\u001e8di&|g.M\u0001\fS:LGoV8sW\u0016\u00148\u000f\u0006\u0002XC\")!\r\u0003a\u0001G\u0006Yro\u001c:lKJLe.\u001b;jC2L'0\u0019;j_:$\u0016.\\3pkR\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\r\u0002\tQLW.Z\u0005\u0003Q\u0016\u0014\u0001\u0002R;sCRLwN\\\u0001\u0004eVtG#A,\u0002\u000b\rdwn]3\u0002\u001d\u001d,GoV8sW\u0016\u00148/\u00138g_\u0006A2\u000f[;uI><hNU3nC&t\u0017N\\4X_J\\WM]:\u0015\t]{\u0017o\u001d\u0005\u0006a2\u0001\raY\u0001\u000fG>tg.Z2u)&lWm\\;u\u0011\u0015\u0011H\u00021\u0001d\u0003}9xN]6feNCW\u000f\u001e3po:|\u0005\u000f^5nSN$\u0018n\u0019+j[\u0016|W\u000f\u001e\u0005\u0006i2\u0001\raY\u0001!o>\u00148.\u001a:TQV$Hm\\<o!\u0016\u001c8/[7jgRL7\rV5nK>,H\u000f")
public class UpdatableWorkersInfo
implements Runnable,
Closeable,
Logging {
    private final WorkerInfo[] workersInfo;
    private final ServerSocket serverSocket;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private WorkerInfo[] workersInfo() {
        return this.workersInfo;
    }

    public ServerSocket serverSocket() {
        return this.serverSocket;
    }

    private void acceptAndProcessWorkerInfo(Function1<WorkerInfo, BoxedUnit> callback) {
        try (Socket socket = this.serverSocket().accept();
             InputStream inputStream = socket.getInputStream();
             ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            callback.apply((Object)((WorkerInfo)objectInputStream.readUnshared()));
        }
    }

    public void initWorkers(Duration workerInitializationTimeout) {
        this.serverSocket().setSoTimeout((int)workerInitializationTimeout.toMillis());
        try {
            IntRef registeredWorkerCount = IntRef.create((int)0);
            while (registeredWorkerCount.elem < this.workersInfo().length) {
                this.acceptAndProcessWorkerInfo((Function1<WorkerInfo, BoxedUnit>)(Function1 & Serializable & scala.Serializable)workerInfo -> {
                    UpdatableWorkersInfo.$anonfun$initWorkers$1(this, registeredWorkerCount, workerInfo);
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new CatBoostError(new StringBuilder(39).append("Initial worker wait timeout of ").append(TimeHelpers$.MODULE$.format(workerInitializationTimeout)).append(" expired").toString());
        }
    }

    @Override
    public void run() {
        try {
            this.serverSocket().setSoTimeout(0);
            while (true) {
                this.acceptAndProcessWorkerInfo((Function1<WorkerInfo, BoxedUnit>)(Function1 & Serializable & scala.Serializable)workerInfo -> {
                    UpdatableWorkersInfo.$anonfun$run$1(this, workerInfo);
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public void close() {
        this.serverSocket().close();
    }

    public synchronized WorkerInfo[] getWorkersInfo() {
        return (WorkerInfo[])Arrays.copyOf((Object[])this.workersInfo(), this.workersInfo().length);
    }

    public void shutdownRemainingWorkers(Duration connectTimeout, Duration workerShutdownOptimisticTimeout, Duration workerShutdownPessimisticTimeout) {
        this.log().info("Shutdown remaining workers: start");
        WorkerInfo[] remainingWorkersInfo = (WorkerInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workersInfo())).filter((Function1 & Serializable & scala.Serializable)workerInfo -> BoxesRunTime.boxToBoolean((boolean)UpdatableWorkersInfo.$anonfun$shutdownRemainingWorkers$1(this, connectTimeout, workerInfo)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])remainingWorkersInfo)).isEmpty()) {
            this.log().info("Shutdown remaining workers: no remaining workers");
        } else {
            Path tmpDirPath = Files.createTempDirectory("catboost_train", new FileAttribute[0]);
            Path hostsFilePath = tmpDirPath.resolve("worker_hosts.txt");
            TrainingDriver$.MODULE$.saveHostsListToFile(hostsFilePath, remainingWorkersInfo);
            Class<?> x$1 = ShutdownWorkersApp$.MODULE$.getClass();
            Some x$2 = new Some((Object)new String[]{((Object)hostsFilePath).toString(), ((Object)BoxesRunTime.boxToLong((long)workerShutdownPessimisticTimeout.getSeconds())).toString()});
            Option<String[]> x$3 = RunClassInNewProcess$.MODULE$.apply$default$2();
            boolean x$4 = RunClassInNewProcess$.MODULE$.apply$default$4();
            Option<ProcessBuilder.Redirect> x$5 = RunClassInNewProcess$.MODULE$.apply$default$5();
            Option<ProcessBuilder.Redirect> x$6 = RunClassInNewProcess$.MODULE$.apply$default$6();
            Option<ProcessBuilder.Redirect> x$7 = RunClassInNewProcess$.MODULE$.apply$default$7();
            Process shutdownWorkersAppProcess = RunClassInNewProcess$.MODULE$.apply(x$1, x$3, (Option<String[]>)x$2, x$4, x$5, x$6, x$7);
            int returnValue = shutdownWorkersAppProcess.waitFor();
            if (returnValue != 0) {
                throw new CatBoostError(new StringBuilder(50).append("Shutdown workers process failed: exited with code ").append(returnValue).toString());
            }
            Thread.sleep(workerShutdownOptimisticTimeout.toMillis());
        }
        this.log().info("Shutdown remaining workers: finish");
    }

    public static final /* synthetic */ void $anonfun$initWorkers$1(UpdatableWorkersInfo $this, IntRef registeredWorkerCount$1, WorkerInfo workerInfo) {
        $this.log().info(new StringBuilder(20).append("received workerInfo=").append(workerInfo).toString());
        if ($this.workersInfo()[workerInfo.partitionId()] == null) {
            ++registeredWorkerCount$1.elem;
        }
        $this.workersInfo()[workerInfo.partitionId()] = workerInfo;
    }

    public static final /* synthetic */ void $anonfun$run$1(UpdatableWorkersInfo $this, WorkerInfo workerInfo) {
        UpdatableWorkersInfo updatableWorkersInfo = $this;
        synchronized (updatableWorkersInfo) {
            $this.log().info(new StringBuilder(20).append("received workerInfo=").append(workerInfo).toString());
            $this.workersInfo()[workerInfo.partitionId()] = workerInfo;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$shutdownRemainingWorkers$1(UpdatableWorkersInfo $this, Duration connectTimeout$1, WorkerInfo workerInfo) {
        void var3_3;
        block0: {
            boolean isListening;
            boolean bl = isListening = workerInfo != null && TrainingDriver$.MODULE$.isWorkerListening(workerInfo.host(), workerInfo.port(), connectTimeout$1);
            if (!isListening) break block0;
            $this.log().info(new StringBuilder(31).append("remaining listening workerInfo=").append(workerInfo).toString());
        }
        return (boolean)var3_3;
    }

    public UpdatableWorkersInfo(WorkerInfo[] workersInfo, ServerSocket serverSocket) {
        this.workersInfo = workersInfo;
        this.serverSocket = serverSocket;
        Logging.$init$((Logging)this);
    }

    public UpdatableWorkersInfo(int listeningPort, int workerCount) {
        this(new WorkerInfo[workerCount], new ServerSocket(listeningPort));
    }
}

