/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.spark.CatBoostModelTrait;
import java.io.DataOutput;
import java.io.Serializable;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.util.BaseReadWrite;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLWriter;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154Q\u0001C\u0005\u0001\u0013=A\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006s\u0001!\tA\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u00199\u0005\u0001)A\u0005\u007f!)\u0001\n\u0001C\u0005\u0013\")!\f\u0001C\u00057\")!\r\u0001C)G\n\u00192)\u0019;C_>\u001cH/T8eK2<&/\u001b;fe*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\t\u0001bY1uE>|7\u000f\u001e\u0006\u0002\u001d\u0005\u0011\u0011-[\u000b\u0003!\u0019\u001a\"\u0001A\t\u0011\u0005IaR\"A\n\u000b\u0005Q)\u0012\u0001B;uS2T!AF\f\u0002\u00055d'B\u0001\u0006\u0019\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\n\u0005u\u0019\"\u0001C'M/JLG/\u001a:\u0002\u0011%t7\u000f^1oG\u0016\u001c\u0001\u0001E\u0002\"E\u0011j\u0011!C\u0005\u0003G%\u0011!cQ1u\u0005>|7\u000f^'pI\u0016dGK]1jiB\u0011QE\n\u0007\u0001\t\u00159\u0003A1\u0001)\u0005\u0015iu\u000eZ3m#\tIs\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3FA\u0004O_RD\u0017N\\4\u0011\tA\n4\u0007J\u0007\u0002+%\u0011!'\u0006\u0002\u0010!J,G-[2uS>tWj\u001c3fYB\u0011AgN\u0007\u0002k)\u0011a'F\u0001\u0007Y&t\u0017\r\\4\n\u0005a*$A\u0002,fGR|'/\u0001\u0004=S:LGO\u0010\u000b\u0003wq\u00022!\t\u0001%\u0011\u0015q\"\u00011\u0001!\u0003%\u0019G.Y:t\u001d\u0006lW-F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003mC:<'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013aa\u0015;sS:<\u0017AC2mCN\u001ch*Y7fA\u0005\tr-\u001a;NKR\fG-\u0019;b)>\u001c\u0016M^3\u0015\u0005)#\u0006CA&S\u001d\ta\u0005\u000b\u0005\u0002NW5\taJ\u0003\u0002P?\u00051AH]8pizJ!!U\u0016\u0002\rA\u0013X\rZ3g\u0013\t15K\u0003\u0002RW!)Q+\u0002a\u0001-\u0006\u00111o\u0019\t\u0003/bk\u0011aF\u0005\u00033^\u0011Ab\u00159be.\u001cuN\u001c;fqR\fAb]1wK6+G/\u00193bi\u0006$2\u0001X0b!\tQS,\u0003\u0002_W\t!QK\\5u\u0011\u0015\u0001g\u00011\u0001K\u0003\u0011\u0001\u0018\r\u001e5\t\u000bU3\u0001\u0019\u0001,\u0002\u0011M\fg/Z%na2$\"\u0001\u00183\t\u000b\u0001<\u0001\u0019\u0001&")
public class CatBoostModelWriter<Model extends PredictionModel<Vector, Model>>
extends MLWriter {
    private final CatBoostModelTrait<Model> instance;
    private final String className;

    private String className() {
        return this.className;
    }

    private String getMetadataToSave(SparkContext sc) {
        JsonAST.JObject basicMetadata;
        String uid = ((Identifiable)this.instance).uid();
        String cls = this.className();
        JsonAST.JObject x$1 = basicMetadata = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)cls), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sparkVersion"), (Object)sc.version()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uid"), (Object)uid), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        String metadataJson = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        return metadataJson;
    }

    private void saveMetadata(String path, SparkContext sc) {
        String metadataPath = new Path(path, "metadata").toString();
        String metadataJson = this.getMetadataToSave(sc);
        sc.parallelize((Seq)new .colon.colon((Object)metadataJson, (List)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(metadataPath);
    }

    public void saveImpl(String path) {
        SparkContext sc = BaseReadWrite.sparkSession$((BaseReadWrite)this).sparkContext();
        this.saveMetadata(path, sc);
        Path modelPath = new Path(path, "model");
        try (FSDataOutputStream outputStream = modelPath.getFileSystem(sc.hadoopConfiguration()).create(modelPath);){
            this.instance.nativeModel().write((DataOutput)outputStream);
        }
    }

    public CatBoostModelWriter(CatBoostModelTrait<Model> instance) {
        this.instance = instance;
        this.className = instance.getClass().getName();
    }
}

