/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark.impl.pyspark_wrapper_generator;

import ai.catboost.spark.CatBoostClassificationModel;
import ai.catboost.spark.CatBoostClassifier;
import ai.catboost.spark.CatBoostRegressionModel;
import ai.catboost.spark.CatBoostRegressor;
import ai.catboost.spark.Pool;
import ai.catboost.spark.impl.pyspark_wrapper_generator.Generator$;
import ai.catboost.spark.params.PoolLoadParams;
import ai.catboost.spark.params.QuantizationParams;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.Duration;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TFullModel;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Generator$ {
    public static Generator$ MODULE$;

    static {
        new Generator$();
    }

    public void generateCorePyPrologue(String sparkCompatVersion, PrintWriter out) {
        out.println("\nimport collections\nimport datetime\nfrom enum import Enum\n\nfrom py4j.java_gateway import JavaObject\n\nfrom pyspark import keyword_only, SparkContext\n");
        String string = sparkCompatVersion;
        if ("3.0".equals(string)) {
            out.println("\nfrom pyspark.ml.classification import JavaProbabilisticClassificationModel\nfrom pyspark.ml.regression import JavaRegressionModel\n");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = "3.1".equals(string) ? true : "3.2".equals(string);
            if (bl) {
                out.println("\nfrom pyspark.ml.classification import _JavaProbabilisticClassificationModel\nfrom pyspark.ml.regression import _JavaRegressionModel\n");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                out.println("\nfrom pyspark.ml.classification import JavaClassificationModel\nfrom pyspark.ml.util import JavaPredictionModel\nfrom pyspark.ml.wrapper import JavaModel\n");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        out.println("\nimport pyspark.ml.common\nfrom pyspark.ml.common import inherit_doc\nfrom pyspark.ml.param import Param, Params\nfrom pyspark.ml.util import JavaMLReader, JavaMLWriter, JavaMLWritable, MLReadable\n");
        out.println("\nimport pyspark.ml.wrapper\nfrom pyspark.ml.wrapper import JavaParams, JavaEstimator, JavaWrapper\nfrom pyspark.sql import DataFrame, SparkSession\n\n\n\"\"\"\n    original JavaParams._from_java has to be replaced because of hardcoded class names transformation\n\"\"\"\n\n@staticmethod\ndef _from_java_patched_for_catboost(java_stage):\n    \"\"\"\n    Given a Java object, create and return a Python wrapper of it.\n    Used for ML persistence.\n\n    Meta-algorithms such as Pipeline should override this method as a classmethod.\n    \"\"\"\n    def __get_class(clazz):\n        \"\"\"\n        Loads Python class from its name.\n        \"\"\"\n        parts = clazz.split('.')\n        module = \".\".join(parts[:-1])\n        m = __import__(module)\n        for comp in parts[1:]:\n            m = getattr(m, comp)\n        return m\n    stage_name = (\n        java_stage.getClass().getName()\n            .replace(\"org.apache.spark\", \"pyspark\")\n            .replace(\"ai.catboost.spark\", \"catboost_spark\")\n    )\n    # Generate a default new instance from the stage_name class.\n    py_type = __get_class(stage_name)\n    if issubclass(py_type, JavaParams):\n        # Load information from java_stage to the instance.\n        py_stage = py_type()\n        py_stage._java_obj = java_stage\n        py_stage._resetUid(java_stage.uid())\n        py_stage._transfer_params_from_java()\n    elif hasattr(py_type, \"_from_java\"):\n        py_stage = py_type._from_java(java_stage)\n    else:\n        raise NotImplementedError(\"This Java stage cannot be loaded into Python currently: %r\"\n                                  % stage_name)\n    return py_stage\n\nJavaParams._from_java = _from_java_patched_for_catboost\n\n\n\"\"\"\n    Adapt _py2java and _java2py for additional types present in CatBoost Params\n\"\"\"\n\n_standard_py2java = pyspark.ml.common._py2java\n_standard_java2py = pyspark.ml.common._java2py\n\ndef _py2java(sc, obj):\n    \"\"\" Convert Python object into Java \"\"\"\n    if isinstance(obj, SparkSession):\n        return obj._jsparkSession\n    if isinstance(obj, Enum):\n        return getattr(\n            getattr(\n                sc._jvm.ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl, \n                obj.__class__.__name__\n            ),\n            'swigToEnum'\n        )(obj.value)\n    if isinstance(obj, datetime.timedelta):\n        return sc._jvm.java.time.Duration.ofMillis(obj // datetime.timedelta(milliseconds=1))\n    if isinstance(obj, JavaParams):\n        return obj._to_java()\n    if isinstance(obj, collections.OrderedDict):\n        return sc._jvm.java.util.LinkedHashMap(obj)\n    return _standard_py2java(sc, obj)\n\ndef _java2py(sc, r, encoding=\"bytes\"):\n    if isinstance(r, JavaObject):\n        enumValues = r.getClass().getEnumConstants()\n        if (enumValues is not None) and (len(enumValues) > 0):\n            return globals()[r.getClass().getSimpleName()](r.swigValue())\n        \n        clsName = r.getClass().getName()\n        if clsName == 'java.time.Duration':\n            return datetime.timedelta(milliseconds=r.toMillis())\n        if clsName == 'ai.catboost.spark.Pool':\n            return Pool(r)\n        if clsName == 'java.util.LinkedHashMap':\n            return collections.OrderedDict(r)\n    return _standard_java2py(sc, r, encoding)\n\npyspark.ml.common._py2java = _py2java\npyspark.ml.common._java2py = _java2py\n\npyspark.ml.wrapper._py2java = _py2java\npyspark.ml.wrapper._java2py = _java2py\n\n\n@inherit_doc\nclass CatBoostMLReader(JavaMLReader):\n    \"\"\"\n    (Private) Specialization of :py:class:`JavaMLReader` for CatBoost types\n    \"\"\"\n\n    @classmethod\n    def _java_loader_class(cls, clazz):\n        \"\"\"\n        Returns the full class name of the Java ML instance.\n        \"\"\"\n        java_package = clazz.__module__.replace(\"catboost_spark.core\", \"ai.catboost.spark\")\n        print(\"CatBoostMLReader._java_loader_class. \", java_package + \".\" + clazz.__name__)\n        return java_package + \".\" + clazz.__name__\n\n");
    }

    public <T> String jvmToPyValueAsString(T obj) {
        String string;
        if (obj instanceof Duration) {
            long durationInMilliseconds = ((Duration)obj).toMillis();
            string = new StringBuilder(33).append("datetime.timedelta(milliseconds=").append(durationInMilliseconds).append(")").toString();
        } else {
            string = obj instanceof String ? new StringBuilder(2).append("\"").append(obj.toString().replace("\t", "\\t")).append("\"").toString() : obj.toString();
        }
        return string;
    }

    public String generateParamsKeywordArgs(Params params) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.params())).map((Function1 & Serializable & scala.Serializable)param -> {
            String string;
            Option option = params.getDefault(param);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object value = some.value();
                string = MODULE$.jvmToPyValueAsString(value);
            } else if (None$.MODULE$.equals(option)) {
                string = "None";
            } else {
                throw new MatchError((Object)option);
            }
            String value = string;
            return new StringBuilder(1).append(param.name()).append("=").append(value).toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
    }

    public <Params> Map<String, String> getParamNameToPythonTypeMap(Params obj, TypeTags.TypeTag<Params> evidence$1) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Regex paramReg = new StringOps(Predef$.MODULE$.augmentString(".*Param\\[([\\w\\.]+)\\]")).r();
        Regex enumParamReg = new StringOps(Predef$.MODULE$.augmentString(".*EnumParam\\[([\\w\\.]+)\\]")).r();
        ((TypeTags)package$.MODULE$.universe()).typeOf(evidence$1).members().foreach((Function1 & Serializable & scala.Serializable)member -> {
            BoxedUnit boxedUnit;
            Some pyType;
            Some some;
            String string = member.typeSignature().typeSymbol().name().toString();
            if ("BooleanParam".equals(string)) {
                some = new Some((Object)"bool");
            } else if ("IntParam".equals(string)) {
                some = new Some((Object)"int");
            } else if ("LongParam".equals(string)) {
                some = new Some((Object)"long");
            } else if ("FloatParam".equals(string)) {
                some = new Some((Object)"float");
            } else if ("DoubleParam".equals(string)) {
                some = new Some((Object)"double");
            } else if ("StringParam".equals(string)) {
                some = new Some((Object)"str");
            } else {
                boolean bl = "StringArrayParam".equals(string) ? true : ("IntArrayParam".equals(string) ? true : ("LongArrayParam".equals(string) ? true : ("ByteArrayParam".equals(string) ? true : "DoubleArrayParam".equals(string))));
                if (bl) {
                    some = new Some((Object)"list");
                } else {
                    boolean bl2 = "MapArrayParam".equals(string) ? true : ("MapParam".equals(string) ? true : "OrderedStringMapParam".equals(string));
                    if (bl2) {
                        some = new Some((Object)"dict");
                    } else if ("DurationParam".equals(string)) {
                        some = new Some((Object)"datetime.timedelta");
                    } else if ("Param".equals(string)) {
                        String pType;
                        String string2 = member.typeSignature().toString();
                        Option option = paramReg.unapplySeq((CharSequence)string2);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0 || !(pType = (String)((LinearSeqOptimized)option.get()).apply(0)).equals("String")) {
                            throw new RuntimeException(new StringBuilder(25).append("unexpected Param type: '").append(member.typeSignature().toString()).append("'").toString());
                        }
                        Some some2 = new Some((Object)"str");
                        some = some2;
                    } else if ("EnumParam".equals(string)) {
                        String string3 = member.typeSignature().toString();
                        Option option = enumParamReg.unapplySeq((CharSequence)string3);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                            throw new RuntimeException(new StringBuilder(23).append("EnumParam bad match: '").append(member.typeSignature().toString()).append("'").toString());
                        }
                        String enumType = (String)((LinearSeqOptimized)option.get()).apply(0);
                        Some some3 = new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])enumType.split("\\."))).last());
                        some = some3;
                    } else {
                        some = None$.MODULE$;
                    }
                }
            }
            Some some4 = pyType = some;
            if (some4 instanceof Some) {
                Some some5 = some4;
                String pyType2 = (String)some5.value();
                boxedUnit = result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)member.name().toString().trim()), (Object)pyType2));
            } else if (None$.MODULE$.equals(some4)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)some4);
            }
            return boxedUnit;
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    public <Params> Set<String> getEnumNamesUsedInParams(Params obj, TypeTags.TypeTag<Params> evidence$2) {
        HashSet result = new HashSet();
        Regex enumReg = new StringOps(Predef$.MODULE$.augmentString(".*EnumParam\\[([\\w\\.]+)\\]")).r();
        ((TypeTags)package$.MODULE$.universe()).typeOf(evidence$2).members().foreach((Function1 & Serializable & scala.Serializable)member -> {
            Generator$.$anonfun$getEnumNamesUsedInParams$1(result, enumReg, member);
            return BoxedUnit.UNIT;
        });
        return result.toSet();
    }

    /*
     * WARNING - void declaration
     */
    public String patchJvmToPyEnumValue(Object enumValue) {
        void var2_2;
        String valueAsString = enumValue.toString();
        return valueAsString.equals("None") ? "No" : var2_2;
    }

    public void generateEnumDefinitions(Set<String> enumNames, PrintWriter out) {
        Seq sortedEnumNames = (Seq)enumNames.toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        sortedEnumNames.foreach((Function1 & Serializable & scala.Serializable)enumName -> {
            Generator$.$anonfun$generateEnumDefinitions$1(out, enumName);
            return BoxedUnit.UNIT;
        });
    }

    public <ParamsClass> String generateParamsDocStrings(ParamsClass paramsClass, int tabShift, TypeTags.TypeTag<ParamsClass> evidence$3) {
        Map<String, String> paramNameToPythonTypeMap = this.getParamNameToPythonTypeMap(paramsClass, evidence$3);
        String tabOffset = new StringOps(Predef$.MODULE$.augmentString("    ")).$times(tabShift);
        Params params = (Params)paramsClass;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.params())).map((Function1 & Serializable & scala.Serializable)param -> {
            String string;
            Option option = params.getDefault(param);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object value = some.value();
                string = new StringBuilder(11).append(", default: ").append(MODULE$.jvmToPyValueAsString(value)).toString();
            } else if (None$.MODULE$.equals(option)) {
                string = "";
            } else {
                throw new MatchError((Object)option);
            }
            String defaultValueDescription = string;
            return new StringBuilder(8).append(tabOffset).append(param.name()).append(" : ").append(paramNameToPythonTypeMap.apply((Object)param.name())).append(defaultValueDescription).append("\n").append(tabOffset).append("    ").append(param.doc()).toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public String generateParamsInitialization(Params params) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.params())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Generator$.$anonfun$generateParamsInitialization$1(p))))).map((Function1 & Serializable & scala.Serializable)param -> {
            String string;
            String paramInit = new StringBuilder(35).append("        self.").append(param.name()).append(" = Param(self, \"").append(param.name()).append("\", \"").append(param.doc()).append("\")").toString();
            Option option = params.getDefault(param);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object value = some.value();
                string = (String)new StringOps(Predef$.MODULE$.augmentString(paramInit)).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(28).append("\n        self._setDefault(").append(param.name()).append("=").append(MODULE$.jvmToPyValueAsString(value)).append(")").toString())), Predef$.MODULE$.StringCanBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                string = paramInit;
            } else {
                throw new MatchError((Object)option);
            }
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public <ParamsClass> String generateParamsGettersAndSetters(ParamsClass paramsClass, TypeTags.TypeTag<ParamsClass> evidence$4) {
        Map<String, String> paramNameToPythonTypeMap = this.getParamNameToPythonTypeMap(paramsClass, evidence$4);
        Params params = (Params)paramsClass;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.params())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Generator$.$anonfun$generateParamsGettersAndSetters$1(p))))).map((Function1 & Serializable & scala.Serializable)param -> {
            String nameInMethods = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, param.name());
            return new StringBuilder(304).append("\n    def get").append(nameInMethods).append("(self):\n        \"\"\"\n        Returns\n        -------\n        ").append(paramNameToPythonTypeMap.apply((Object)param.name())).append("\n            ").append(param.doc()).append("\n        \"\"\"\n        return self.getOrDefault(self.").append(param.name()).append(")\n\n    def set").append(nameInMethods).append("(self, value):\n        \"\"\"\n        Parameters\n        ----------\n        value : ").append(paramNameToPythonTypeMap.apply((Object)param.name())).append("\n            ").append(param.doc()).append("\n        \"\"\"\n        self._set(").append(param.name()).append("=value)\n        return self\n\n").toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public <Params> String generateParamsPart(Params params, String paramsKeywordArgs, TypeTags.TypeTag<Params> evidence$5) {
        return new StringBuilder(335).append("\n    @keyword_only\n    def setParams(self, ").append(paramsKeywordArgs).append("):\n        \"\"\"\n        Set the (keyword only) parameters\n\n        Parameters\n        ----------\n").append(this.generateParamsDocStrings(params, 2, evidence$5)).append("\n        \"\"\"\n        if hasattr(self, \"_input_kwargs\"):\n            kwargs = self._input_kwargs\n        else:\n            kwargs = self.__init__._input_kwargs\n        return self._set(**kwargs)\n\n").append(this.generateParamsGettersAndSetters(params, evidence$5)).append("\n").toString();
    }

    public <ParamsClass> void generateStandardParamsWrapper(ParamsClass params, PrintWriter out, TypeTags.TypeTag<ParamsClass> evidence$6) {
        Params paramsAsParamsClass = (Params)params;
        String paramsKeywordArgs = this.generateParamsKeywordArgs(paramsAsParamsClass);
        String pyClassName = params.getClass().getSimpleName();
        out.println(new StringBuilder(377).append("\nclass ").append(pyClassName).append("(JavaParams):\n    \"\"\"\n    Parameters\n    ----------\n").append(this.generateParamsDocStrings(params, 1, evidence$6)).append("\n    \"\"\"\n\n    @keyword_only\n    def __init__(self, ").append(paramsKeywordArgs).append("):\n        super(").append(pyClassName).append(", self).__init__()\n        self._java_obj = self._new_java_obj(\"").append(params.getClass().getCanonicalName()).append("\")\n").append(this.generateParamsInitialization(paramsAsParamsClass)).append("\n\n        if hasattr(self, \"_input_kwargs\"):\n            kwargs = self._input_kwargs\n        else:\n            kwargs = self.__init__._input_kwargs\n        self.setParams(**kwargs)\n\n").append(this.generateParamsPart(params, paramsKeywordArgs, evidence$6)).append("\n").toString());
    }

    public String generateForwardedAccessors(Seq<Tuple2<String, String>> accessors) {
        return ((TraversableOnce)accessors.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String accessor = (String)tuple2._1();
            String docString = (String)tuple2._2();
            String string = new StringBuilder(85).append("\n    def ").append(accessor).append("(self):\n        \"\"\"\n        ").append(docString).append("\n        \"\"\"\n        return self._call_java(\"").append(accessor).append("\")\n").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public void generatePoolWrapper(PrintWriter out) {
        Pool pool = new Pool(null);
        String paramsKeywordArgs = this.generateParamsKeywordArgs((Params)pool);
        Seq forwardedAccessors = (Seq)new .colon.colon((Object)new Tuple2((Object)"isQuantized", (Object)"Returns whether the main `data` has already been quantized."), (List)new .colon.colon((Object)new Tuple2((Object)"getFeatureCount", (Object)"Returns the number of features."), (List)new .colon.colon((Object)new Tuple2((Object)"getFeatureNames", (Object)"Returns the list of feature names."), (List)new .colon.colon((Object)new Tuple2((Object)"count", (Object)"Returns the number of rows in the main `data` DataFrame."), (List)new .colon.colon((Object)new Tuple2((Object)"pairsCount", (Object)"Returns the number of rows in the `pairsData` DataFrame."), (List)new .colon.colon((Object)new Tuple2((Object)"getBaselineCount", (Object)"Returns the dimension of the baseline data (0 if not specified)."), (List)Nil$.MODULE$))))));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.catboost.spark.Pool").asType().toTypeConstructor();
            }

            public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$1() {
            }
        }
        out.println(new StringBuilder(4256).append("\nclass Pool(JavaParams):\n    \"\"\"\n    CatBoost's abstraction of a dataset.\n    Features data can be stored in raw (features column has pyspark.ml.linalg.Vector type)\n    or quantized (float feature values are quantized into integer bin values, features column has\n    Array[Byte] type) form.\n\n    Raw Pool can be transformed to quantized form using `quantize` method.\n    This is useful if this dataset is used for training multiple times and quantization parameters do not\n    change. Pre-quantized Pool allows to cache quantized features data and so do not re-run\n    feature quantization step at the start of an each training.\n    \"\"\"\n    def __init__(self, data_frame_or_java_object, pairs_data_frame=None):\n        \"\"\"\n        Construct Pool from DataFrame, optionally specifying pairs data in an additional DataFrame.\n        \"\"\"\n        if isinstance(data_frame_or_java_object, JavaObject):\n            java_obj = data_frame_or_java_object\n        else:\n            java_obj = JavaWrapper._new_java_obj(\"ai.catboost.spark.Pool\", data_frame_or_java_object, pairs_data_frame)\n\n        super(Pool, self).__init__(java_obj)\n").append(this.generateParamsInitialization((Params)pool)).append("\n      \n").append(this.generateParamsPart(pool, paramsKeywordArgs, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$1()))).append("\n\n    def _call_java(self, name, *args):\n        self._transfer_params_to_java()\n        return JavaWrapper._call_java(self, name, *args)\n\n").append(this.generateForwardedAccessors((Seq<Tuple2<String, String>>)forwardedAccessors)).append("\n\n    @property\n    def data(self):\n        \"\"\"\n        DataFrame with the main data (features, label, (optionally) weight etc.)\n        \"\"\"\n        return self._call_java(\"data\")\n\n    @property\n    def pairsData(self):\n        \"\"\"\n        DataFrame with the pairs data (groupId, winnerId, loserId and optionally weight).\n        Can be None.\n        \"\"\"\n        return self._call_java(\"pairsData\")\n\n    def quantize(self, quantizationParams = None):\n        \"\"\"Create Pool with quantized features from Pool with raw features\"\"\"\n        if quantizationParams is None:\n            quantizationParams = QuantizationParams()\n        return self._call_java(\"quantize\", quantizationParams)\n\n    def repartition(self, partitionCount, byGroupColumnsIfPresent):\n        \"\"\"\n        Repartion data to the specified number of partitions.\n        Useful to repartition data to create one partition per executor for training\n        (where each executor gets its' own CatBoost worker with a part of the training data).\n        \"\"\"\n        return self._call_java(\"repartition\", partitionCount, byGroupColumnsIfPresent)\n\n    @staticmethod\n    def load(sparkSession, dataPathWithScheme, columnDescription=None, poolLoadParams=None, pairsDataPathWithScheme=None):\n        \"\"\"\n        Load dataset in one of CatBoost's natively supported formats:\n           * dsv - https://catboost.ai/docs/concepts/input-data_values-file.html\n           * libsvm - https://catboost.ai/docs/concepts/input-data_libsvm.html\n        \n        Parameters\n        ----------\n        sparkSession : SparkSession\n        dataPathWithScheme : str\n            Path with scheme to dataset in CatBoost format.\n            For example, `dsv:///home/user/datasets/my_dataset/train.dsv` or\n            `libsvm:///home/user/datasets/my_dataset/train.libsvm`\n        columnDescription : str, optional\n            Path to column description file. See https://catboost.ai/docs/concepts/input-data_column-descfile.html \n        params : PoolLoadParams, optional\n            Additional params specifying data format.\n        pairsDataPathWithScheme : str, optional\n            Path with scheme to dataset pairs in CatBoost format.\n            Only \"dsv-grouped\" format is supported for now.\n            For example, `dsv-grouped:///home/user/datasets/my_dataset/train_pairs.dsv`\n        \n        Returns\n        -------\n           Pool\n               Pool containing loaded data\n        \"\"\"\n        if poolLoadParams is None:\n            poolLoadParams = PoolLoadParams()\n        sc = sparkSession.sparkContext\n        java_obj = sc._jvm.ai.catboost.spark.Pool.load(\n            _py2java(sc, sparkSession),\n            dataPathWithScheme,\n            (sc._jvm.java.nio.file.Paths.get(columnDescription, sc._gateway.new_array(sc._jvm.String, 0))\n             if columnDescription\n             else None\n            ),\n            _py2java(sc, poolLoadParams),\n            pairsDataPathWithScheme\n        )\n        return Pool(java_obj)\n\n").toString());
    }

    public <EstimatorClass, ModelClass> void generateEstimatorAndModelWrapper(EstimatorClass estimator, ModelClass model, String modelBaseClassName, String estimatorDoc, String modelDoc, String sparkCompatVersion, PrintWriter out, TypeTags.TypeTag<EstimatorClass> evidence$7, TypeTags.TypeTag<ModelClass> evidence$8) {
        block3: {
            String estimatorClassName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TypeTags)package$.MODULE$.universe()).typeOf(evidence$7).typeSymbol().name().toString().split("\\."))).last();
            Params estimatorAsParams = (Params)estimator;
            String estimatorParamsKeywordArgs = this.generateParamsKeywordArgs(estimatorAsParams);
            String modelClassName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TypeTags)package$.MODULE$.universe()).typeOf(evidence$8).typeSymbol().name().toString().split("\\."))).last();
            Params modelAsParams = (Params)model;
            String modelParamsKeywordArgs = this.generateParamsKeywordArgs(modelAsParams);
            out.println(new StringBuilder(3633).append("\n\n@inherit_doc\nclass ").append(estimatorClassName).append("(JavaEstimator, MLReadable, JavaMLWritable):\n    \"\"\"\n    ").append(estimatorDoc).append("\n\n    Init Parameters\n    ---------------\n").append(this.generateParamsDocStrings(estimator, 2, evidence$7)).append("\n    \"\"\"\n\n    @keyword_only\n    def __init__(self, ").append(estimatorParamsKeywordArgs).append("):\n        super(").append(estimatorClassName).append(", self).__init__()\n        self._java_obj = self._new_java_obj(\"ai.catboost.spark.").append(estimatorClassName).append("\")\n").append(this.generateParamsInitialization(estimatorAsParams)).append("\n\n        if hasattr(self, \"_input_kwargs\"):\n            kwargs = self._input_kwargs\n        else:\n            kwargs = self.__init__._input_kwargs\n        self.setParams(**kwargs)\n\n").append(this.generateParamsPart(estimator, estimatorParamsKeywordArgs, evidence$7)).append("\n\n    @classmethod\n    def read(cls):\n        \"\"\"Returns an MLReader instance for this class.\"\"\"\n        return CatBoostMLReader(cls)\n\n    def _create_model(self, java_model):\n        return ").append(modelClassName).append("(java_model)\n\n    def _fit_with_eval(self, trainDatasetAsJavaObject, evalDatasetsAsJavaObject, params=None):\n        \"\"\"\n        Implementation of fit with eval datasets with no more than one set of optional parameters\n        \"\"\"\n        if params:\n            return self.copy(params)._fit_with_eval(trainDatasetAsJavaObject, evalDatasetsAsJavaObject)\n        else:\n            self._transfer_params_to_java()\n            java_model = self._java_obj.fit(trainDatasetAsJavaObject, evalDatasetsAsJavaObject)\n            return ").append(modelClassName).append("(java_model)\n\n    def fit(self, dataset, params=None, evalDatasets=None):\n        \"\"\"\n        Extended variant of standard Estimator's fit method\n        that accepts CatBoost's Pool s and allows to specify additional\n        datasets for computing evaluation metrics and overfitting detection similarily to CatBoost's other APIs.\n        \n        Parameters\n        ---------- \n        dataset : Pool or DataFrame\n          The input training dataset.\n        params : dict or list or tuple, optional\n          an optional param map that overrides embedded params. If a list/tuple of\n          param maps is given, this calls fit on each param map and returns a list of\n          models.\n        evalDatasets : Pools, optional\n          The validation datasets used for the following processes:\n           - overfitting detector\n           - best iteration selection\n           - monitoring metrics' changes\n        \n        Returns\n        -------\n        trained model(s): ").append(modelClassName).append(" or a list of trained ").append(modelClassName).append("\n        \"\"\"\n        if (isinstance(dataset, DataFrame)):\n            if evalDatasets is not None:\n                raise RuntimeError(\"if dataset has type DataFrame no evalDatasets are supported\")\n            return JavaEstimator.fit(self, dataset, params)\n        else:\n            sc = SparkContext._active_spark_context\n\n            trainDatasetAsJavaObject = _py2java(sc, dataset)\n            evalDatasetCount = 0 if (evalDatasets is None) else len(evalDatasets)\n\n            # need to create it because default mapping for python list is ArrayList, not Array\n            evalDatasetsAsJavaObject = sc._gateway.new_array(sc._jvm.ai.catboost.spark.Pool, evalDatasetCount)\n            for i in range(evalDatasetCount):\n                evalDatasetsAsJavaObject[i] = _py2java(sc, evalDatasets[i])\n\n            def _fit_with_eval(params):\n                return self._fit_with_eval(trainDatasetAsJavaObject, evalDatasetsAsJavaObject, params)\n\n            if (params is None) or isinstance(params, dict):\n                return _fit_with_eval(params)\n            if isinstance(params, (list, tuple)):\n                models = []\n                for paramsInstance in params:\n                    models.append(_fit_with_eval(paramsInstance))\n                return models\n            else:\n                raise TypeError(\"Params must be either a param map or a list/tuple of param maps, \"\n                                \"but got %s.\" % type(params))\n\n@inherit_doc").toString());
            if (sparkCompatVersion.startsWith("3.")) {
                out.print(new StringBuilder(37).append("class ").append(modelClassName).append("(").append(modelBaseClassName).append(", MLReadable, JavaMLWritable):").toString());
            } else {
                out.print(new StringBuilder(48).append("class ").append(modelClassName).append("(JavaModel, ").append(modelBaseClassName).append(", MLReadable, JavaMLWritable):").toString());
            }
            out.println(new StringBuilder(10151).append("\n    \"\"\"\n    ").append(modelDoc).append("\n    \"\"\"\n    def __init__(self, java_model=None):\n        super(").append(modelClassName).append(", self).__init__(java_model)\n").append(this.generateParamsInitialization(modelAsParams)).append("\n        if java_model is not None:\n            self._transfer_params_from_java()\n\n").append(this.generateParamsPart(model, modelParamsKeywordArgs, evidence$8)).append("\n\n    @staticmethod\n    def _from_java(java_model):\n        return ").append(modelClassName).append("(java_model)\n\n    @classmethod\n    def read(cls):\n        \"\"\"Returns an MLReader instance for this class.\"\"\"\n        return CatBoostMLReader(cls)\n\n    def saveNativeModel(self, fileName, format=EModelType.CatboostBinary, exportParameters=None, pool=None):\n        \"\"\"\n        Save the model to a local file.\n        See https://catboost.ai/docs/concepts/python-reference_catboostclassifier_save_model.html\n        for detailed parameters description\n        \"\"\"\n        return self._call_java(\"saveNativeModel\", fileName, format, exportParameters, pool)\n\n    @staticmethod\n    def loadNativeModel(fileName, format=EModelType.CatboostBinary):\n        \"\"\"\n        Load the model from a local file.\n        See https://catboost.ai/docs/concepts/python-reference_catboostclassifier_load_model.html\n        for detailed parameters description\n        \"\"\"\n        sc = SparkContext._active_spark_context\n        java_model = sc._jvm.ai.catboost.spark.").append(modelClassName).append(".loadNativeModel(fileName, _py2java(sc, format))\n        return ").append(modelClassName).append("(java_model)\n\n\n    def transformPool(self, pool):\n        \"\"\"\n        This function is useful when the dataset has been already quantized but works with any Pool\n        \"\"\"\n        return self._call_java(\"transformPool\", pool)\n\n\n    def getFeatureImportance(self, \n                             fstrType=EFstrType.FeatureImportance,\n                             data=None,\n                             calcType=ECalcTypeShapValues.Regular\n                            ):\n        \"\"\"\n        Parameters\n        ----------\n        fstrType : EFstrType\n            Supported values are FeatureImportance, PredictionValuesChange, LossFunctionChange, PredictionDiff\n        data : Pool\n            if fstrType is PredictionDiff it is required and must contain 2 samples\n            if fstrType is PredictionValuesChange this param is required in case if model was explicitly trained\n            with flag to store no leaf weights.\n            otherwise it can be null\n        calcType : ECalcTypeShapValues\n            Used only for PredictionValuesChange. \n            Possible values:\n              - Regular\n                 Calculate regular SHAP values\n              - Approximate\n                 Calculate approximate SHAP values\n              - Exact\n                 Calculate exact SHAP values\n\n        Returns\n        -------\n        list of float\n            array of feature importances (index corresponds to the order of features in the model)\n        \"\"\"\n        return self._call_java(\"getFeatureImportance\", fstrType, data, calcType)\n\n    def getFeatureImportancePrettified(self, \n                                       fstrType=EFstrType.FeatureImportance,\n                                       data=None,\n                                       calcType=ECalcTypeShapValues.Regular\n                                      ):\n        \"\"\"\n        Parameters\n        ----------\n        fstrType : EFstrType\n            Supported values are FeatureImportance, PredictionValuesChange, LossFunctionChange, PredictionDiff\n        data : Pool\n            if fstrType is PredictionDiff it is required and must contain 2 samples\n            if fstrType is PredictionValuesChange this param is required in case if model was explicitly trained\n            with flag to store no leaf weights.\n            otherwise it can be null\n        calcType : ECalcTypeShapValues\n            Used only for PredictionValuesChange. \n            Possible values:\n\n              - Regular\n                 Calculate regular SHAP values\n              - Approximate\n                 Calculate approximate SHAP values\n              - Exact\n                 Calculate exact SHAP values\n\n        Returns\n        -------\n        list of FeatureImportance\n            array of feature importances sorted in descending order by importance\n        \"\"\"\n        return self._call_java(\"getFeatureImportancePrettified\", fstrType, data, calcType)\n\n    def getFeatureImportanceShapValues(self,\n                                       data,\n                                       preCalcMode=EPreCalcShapValues.Auto,\n                                       calcType=ECalcTypeShapValues.Regular,\n                                       modelOutputType=EExplainableModelOutput.Raw,\n                                       referenceData=None,\n                                       outputColumns=None\n                                      ):\n        \"\"\"\n        Parameters\n        ----------\n        data : Pool\n            dataset to calculate SHAP values for\n        preCalcMode : EPreCalcShapValues\n            Possible values:\n               - Auto\n                  Use direct SHAP Values calculation only if data size is smaller than average leaves number\n                  (the best of two strategies below is chosen).\n               - UsePreCalc\n                  Calculate SHAP Values for every leaf in preprocessing. Final complexity is\n                  O(NT(D+F))+O(TL^2 D^2) where N is the number of documents(objects), T - number of trees,\n                  D - average tree depth, F - average number of features in tree, L - average number of leaves in tree\n                  This is much faster (because of a smaller constant) than direct calculation when N >> L\n               - NoPreCalc\n                  Use direct SHAP Values calculation calculation with complexity O(NTLD^2). Direct algorithm\n                  is faster when N < L (algorithm from https://arxiv.org/abs/1802.03888)\n        calcType : ECalcTypeShapValues\n            Possible values:\n\n              - Regular\n                 Calculate regular SHAP values\n              - Approximate\n                 Calculate approximate SHAP values\n              - Exact\n                 Calculate exact SHAP values\n        referenceData : Pool\n            reference data for Independent Tree SHAP values from https://arxiv.org/abs/1905.04610v1\n            if referenceData is not null, then Independent Tree SHAP values are calculated\n        outputColumns : list of str\n            columns from data to add to output DataFrame, if None - add all columns\n\n        Returns\n        -------\n        DataFrame\n            - for regression and binclass models: \n              contains outputColumns and \"shapValues\" column with Vector of length (n_features + 1) with SHAP values\n            - for multiclass models:\n              contains outputColumns and \"shapValues\" column with Matrix of shape (n_classes x (n_features + 1)) with SHAP values\n        \"\"\"\n        return self._call_java(\n            \"getFeatureImportanceShapValues\", \n            data, \n            preCalcMode,\n            calcType,\n            modelOutputType,\n            referenceData,\n            outputColumns\n        )\n\n    def getFeatureImportanceShapInteractionValues(self,\n                                                  data,\n                                                  featureIndices=None,\n                                                  featureNames=None,\n                                                  preCalcMode=EPreCalcShapValues.Auto,\n                                                  calcType=ECalcTypeShapValues.Regular,\n                                                  outputColumns=None):\n        \"\"\"\n        SHAP interaction values are calculated for all features pairs if nor featureIndices nor featureNames \n          are specified.\n\n        Parameters\n        ----------\n        data : Pool\n            dataset to calculate SHAP interaction values\n        featureIndices : (int, int), optional\n            pair of features indices to calculate SHAP interaction values for.\n        featureNames : (str, str), optional\n            pair of features names to calculate SHAP interaction values for.\n        preCalcMode : EPreCalcShapValues\n            Possible values:\n\n            - Auto\n                Use direct SHAP Values calculation only if data size is smaller than average leaves number\n                (the best of two strategies below is chosen).\n            - UsePreCalc\n                Calculate SHAP Values for every leaf in preprocessing. Final complexity is\n                O(NT(D+F))+O(TL^2 D^2) where N is the number of documents(objects), T - number of trees,\n                D - average tree depth, F - average number of features in tree, L - average number of leaves in tree\n                This is much faster (because of a smaller constant) than direct calculation when N >> L\n            - NoPreCalc\n                Use direct SHAP Values calculation calculation with complexity O(NTLD^2). Direct algorithm\n                is faster when N < L (algorithm from https://arxiv.org/abs/1802.03888)\n        calcType : ECalcTypeShapValues\n            Possible values:\n\n              - Regular\n                  Calculate regular SHAP values\n              - Approximate\n                  Calculate approximate SHAP values\n              - Exact\n                  Calculate exact SHAP values\n        outputColumns : list of str\n            columns from data to add to output DataFrame, if None - add all columns\n\n        Returns\n        -------\n        DataFrame\n            - for regression and binclass models: \n              contains outputColumns and \"featureIdx1\", \"featureIdx2\", \"shapInteractionValue\" columns\n            - for multiclass models:\n              contains outputColumns and \"classIdx\", \"featureIdx1\", \"featureIdx2\", \"shapInteractionValue\" columns\n        \"\"\"\n        return self._call_java(\n            \"getFeatureImportanceShapInteractionValues\", \n            data,\n            featureIndices,\n            featureNames,\n            preCalcMode, \n            calcType,\n            outputColumns\n        )\n\n    def getFeatureImportanceInteraction(self):\n        \"\"\"\n        Returns\n        -------\n        list of FeatureInteractionScore\n        \"\"\"\n        return self._call_java(\"getFeatureImportanceInteraction\")\n\n").toString());
            if (sparkCompatVersion.startsWith("3.")) break block3;
            String string = modelBaseClassName;
            String string2 = "JavaClassificationModel";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                out.println("\n    def predictRaw(self, value):\n        \"\"\"\n        Raw prediction for each possible label.\n        \"\"\"\n        return self._call_java(\"predictRaw\", value)\n\n    def predictProbability(self, value):\n        \"\"\"\n        Predict the probability of each class given the features.\n        \"\"\"\n        return self._call_java(\"predictProbability\", value)\n");
            }
        }
    }

    public void generateVersionPy(File modulePath, String version) {
        try (PrintWriter versionPyWriter = new PrintWriter(new File(modulePath, "version.py"));){
            versionPyWriter.println(new StringBuilder(12).append("VERSION = '").append(version).append("'").toString());
        }
    }

    public void generateInitPy(File modulePath, Set<String> enumsUsedInParams) {
        Seq exportList = (Seq)((TraversableLike)new .colon.colon((Object)"PoolLoadParams", (List)new .colon.colon((Object)"QuantizationParams", (List)new .colon.colon((Object)"Pool", (List)new .colon.colon((Object)"CatBoostClassificationModel", (List)new .colon.colon((Object)"CatBoostClassifier", (List)new .colon.colon((Object)"CatBoostRegressionModel", (List)new .colon.colon((Object)"CatBoostRegressor", (List)Nil$.MODULE$)))))))).$plus$plus((GenTraversableOnce)enumsUsedInParams.toSeq().sorted((Ordering)Ordering.String$.MODULE$), Seq$.MODULE$.canBuildFrom());
        try (PrintWriter initPyWriter = new PrintWriter(new File(modulePath, "__init__.py"));){
            initPyWriter.print("\nfrom .version import VERSION as __version__  # noqa\nfrom .core import (\n");
            exportList.foreach((Function1 & Serializable & scala.Serializable)symbol -> {
                initPyWriter.println(new StringBuilder(5).append("    ").append(symbol).append(",").toString());
                return BoxedUnit.UNIT;
            });
            initPyWriter.print("\n)\n__all__ = [\n");
            exportList.foreach((Function1 & Serializable & scala.Serializable)symbol -> {
                initPyWriter.println(new StringBuilder(7).append("    '").append(symbol).append("',").toString());
                return BoxedUnit.UNIT;
            });
            initPyWriter.println("]");
        }
    }

    public void main(String[] args) {
        try {
            String sparkCompatVersion = args[2];
            File modulePath = new File(args[1]);
            modulePath.mkdirs();
            this.generateVersionPy(modulePath, args[0]);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            JavaUniverse $u4 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.catboost.spark.params.QuantizationParams").asType().toTypeConstructor();
                }

                public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$2() {
                }
            }
            public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.catboost.spark.Pool").asType().toTypeConstructor();
                }

                public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator2$1() {
                }
            }
            public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.catboost.spark.CatBoostClassifier").asType().toTypeConstructor();
                }

                public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator3$1() {
                }
            }
            public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.catboost.spark.CatBoostRegressor").asType().toTypeConstructor();
                }

                public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator4$1() {
                }
            }
            Set enumsUsedInParams = (Set)this.getEnumNamesUsedInParams(new QuantizationParams(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator1$2())).$plus$plus(this.getEnumNamesUsedInParams(new Pool(null), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator2$1()))).$plus$plus(this.getEnumNamesUsedInParams(new CatBoostClassifier(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator3$1()))).$plus$plus(this.getEnumNamesUsedInParams(new CatBoostRegressor(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator4$1()))).$plus((Object)"EModelType").$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EFstrType", "ECalcTypeShapValues", "EPreCalcShapValues", "EExplainableModelOutput"})));
            this.generateInitPy(modulePath, (Set<String>)enumsUsedInParams);
            try (PrintWriter corePyWriter = new PrintWriter(new File(modulePath, "core.py"));){
                String string;
                String string2;
                this.generateCorePyPrologue(sparkCompatVersion, corePyWriter);
                JavaUniverse $u5 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("ai.catboost.spark.params.PoolLoadParams").asType().toTypeConstructor();
                    }

                    public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator5$1() {
                    }
                }
                this.generateStandardParamsWrapper(new PoolLoadParams(), corePyWriter, ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator5$1()));
                JavaUniverse $u6 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("ai.catboost.spark.params.QuantizationParams").asType().toTypeConstructor();
                    }

                    public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator6$1() {
                    }
                }
                this.generateStandardParamsWrapper(new QuantizationParams(), corePyWriter, ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator6$1()));
                this.generatePoolWrapper(corePyWriter);
                this.generateEnumDefinitions((Set<String>)enumsUsedInParams, corePyWriter);
                CatBoostRegressor catBoostRegressor = new CatBoostRegressor();
                CatBoostRegressionModel catBoostRegressionModel = new CatBoostRegressionModel(new TFullModel());
                String string3 = sparkCompatVersion;
                if ("3.0".equals(string3)) {
                    string2 = "JavaRegressionModel";
                } else {
                    boolean bl = "3.1".equals(string3) ? true : "3.2".equals(string3);
                    string2 = bl ? "_JavaRegressionModel" : "JavaPredictionModel";
                }
                JavaUniverse $u7 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u8 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator7$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("ai.catboost.spark.CatBoostRegressor").asType().toTypeConstructor();
                    }

                    public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator7$1() {
                    }
                }
                public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator8$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("ai.catboost.spark.CatBoostRegressionModel").asType().toTypeConstructor();
                    }

                    public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator8$1() {
                    }
                }
                this.generateEstimatorAndModelWrapper(catBoostRegressor, catBoostRegressionModel, string2, "Class to train CatBoostRegressionModel", "Regression model trained by CatBoost. Use CatBoostRegressor to train it", sparkCompatVersion, corePyWriter, ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator7$1()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator8$1()));
                CatBoostClassifier catBoostClassifier = new CatBoostClassifier();
                CatBoostClassificationModel catBoostClassificationModel = new CatBoostClassificationModel(new TFullModel());
                String string4 = sparkCompatVersion;
                if ("3.0".equals(string4)) {
                    string = "JavaProbabilisticClassificationModel";
                } else {
                    boolean bl = "3.1".equals(string4) ? true : "3.2".equals(string4);
                    string = bl ? "_JavaProbabilisticClassificationModel" : "JavaClassificationModel";
                }
                JavaUniverse $u9 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u10 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator9$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("ai.catboost.spark.CatBoostClassifier").asType().toTypeConstructor();
                    }

                    public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator9$1() {
                    }
                }
                public final class Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("ai.catboost.spark.CatBoostClassificationModel").asType().toTypeConstructor();
                    }

                    public Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator10$1() {
                    }
                }
                this.generateEstimatorAndModelWrapper(catBoostClassifier, catBoostClassificationModel, string, "Class to train CatBoostClassificationModel", "Classification model trained by CatBoost. Use CatBoostClassifier to train it", sparkCompatVersion, corePyWriter, ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator9$1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Ai_catboost_spark_impl_pyspark_wrapper_generator_Generator$$typecreator10$1()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw scala.sys.package$.MODULE$.exit(1);
        }
        throw scala.sys.package$.MODULE$.exit(0);
    }

    public static final /* synthetic */ void $anonfun$getEnumNamesUsedInParams$1(HashSet result$2, Regex enumReg$1, Symbols.SymbolApi member) {
        None$ none$;
        String string = member.typeSignature().typeSymbol().name().toString();
        if ("EnumParam".equals(string)) {
            String string2 = member.typeSignature().toString();
            Option option = enumReg$1.unapplySeq((CharSequence)string2);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                throw new RuntimeException(new StringBuilder(23).append("EnumParam bad match: '").append(member.typeSignature().toString()).append("'").toString());
            }
            String enumType = (String)((LinearSeqOptimized)option.get()).apply(0);
            String string3 = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])enumType.split("\\."))).last();
            none$ = result$2.$plus$eq((Object)string3);
        } else {
            none$ = None$.MODULE$;
        }
        None$ none$2 = none$;
    }

    public static final /* synthetic */ boolean $anonfun$generateEnumDefinitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$generateEnumDefinitions$3(PrintWriter out$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object enumValue = tuple2._1();
        int idx = tuple2._2$mcI$sp();
        out$1.println(new StringBuilder(7).append("    ").append(MODULE$.patchJvmToPyEnumValue(enumValue)).append(" = ").append(idx).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateEnumDefinitions$1(PrintWriter out$1, String enumName) {
        Class<?> enumClass = Class.forName(new StringBuilder(63).append("ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.").append(enumName).toString());
        out$1.print(new StringBuilder(15).append("\nclass ").append(enumName).append("(Enum):\n").toString());
        Object[] enumValues = enumClass.getEnumConstants();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(enumValues)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Generator$.$anonfun$generateEnumDefinitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Generator$.$anonfun$generateEnumDefinitions$3(out$1, x$1);
            return BoxedUnit.UNIT;
        });
        out$1.println("");
    }

    public static final /* synthetic */ boolean $anonfun$generateParamsInitialization$1(Param p) {
        String string = p.name();
        String string2 = "classWeights";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$generateParamsGettersAndSetters$1(Param p) {
        String string = p.name();
        String string2 = "classWeights";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private Generator$() {
        MODULE$ = this;
    }
}

