/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.CatBoostError;
import ai.catboost.spark.DatasetForTraining;
import ai.catboost.spark.DatasetForTrainingWithPairs;
import ai.catboost.spark.DatasetLoadingContext;
import ai.catboost.spark.DatasetLoadingContext$;
import ai.catboost.spark.Pool;
import ai.catboost.spark.PoolFilesPaths;
import ai.catboost.spark.QuantizedFeaturesIndices;
import ai.catboost.spark.SelectedFeaturesOffsets;
import ai.catboost.spark.SelectedFeaturesOffsets$;
import ai.catboost.spark.UsualDatasetForTraining;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.EDatasetVisitorType;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.IQuantizedFeaturesDataVisitor;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.QuantizedFeaturesInfoPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TDataProviderBuilderOptions;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TDataProviderClosureForJVM;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TFeaturesLayoutPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TIntermediateDataMetaInfo;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TLocalExecutor;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TQuantizedObjectsDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TRawObjectsDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TDataProviderPtr;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TMaybeOwningConstArrayHolder_float;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TMaybeOwningConstArrayHolder_i32;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.TVector_TString;
import ru.yandex.catboost.spark.catboost4j_spark.core.src.native_impl.native_impl;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DataHelpers$ {
    public static DataHelpers$ MODULE$;

    static {
        new DataHelpers$();
    }

    public Seq<StructField> selectSchemaFields(StructType srcSchema, String[] fieldNames) {
        return fieldNames == null ? srcSchema.toSeq() : (Seq)srcSchema.filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)DataHelpers$.$anonfun$selectSchemaFields$1(fieldNames, field)));
    }

    public String[] selectSchemaFields$default$2() {
        return null;
    }

    public Dataset<Row> mapSampleIdxToPerGroupSampleIdx(Dataset<Row> data) {
        int groupIdIdx = data.schema().fieldIndex("groupId");
        int sampleIdIdx = data.schema().fieldIndex("sampleId");
        RDD resultAsRDD = data.rdd().groupBy((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToLong((long)row.getLong(groupIdIdx)), ClassTag$.MODULE$.Long()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable rows = (Iterable)tuple2._2();
            LongRef startSampleId = LongRef.create((long)Long.MAX_VALUE);
            Seq rowsCopy = ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> {
                startSampleId$1.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(startSampleId$1.elem), row.getLong(sampleIdIdx));
                return row;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            Seq seq = (Seq)rowsCopy.map((Function1 & Serializable & scala.Serializable)row -> {
                Object[] fields = (Object[])row.toSeq().toArray(ClassTag$.MODULE$.Any());
                fields[sampleIdIdx$1] = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)fields[sampleIdIdx]) - startSampleId$1.elem));
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)fields));
            }, Seq$.MODULE$.canBuildFrom());
            return seq;
        }, ClassTag$.MODULE$.apply(Row.class));
        return data.sparkSession().createDataFrame(resultAsRDD, data.schema());
    }

    public Metadata makeFeaturesMetadata(String[] initialFeatureNames) {
        String[] featureNames = new String[initialFeatureNames.length];
        HashSet featureNamesSet = new HashSet();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureNames)).size()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            String name = initialFeatureNames[i];
            if (name.isEmpty()) {
                String generatedName = ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                if (featureNamesSet.contains((Object)generatedName)) {
                    throw new CatBoostError(new StringBuilder(118).append("Unable to use generated name \"").append(generatedName).append("\" for feature with unspecified name because").append(" it has been already used for another feature").toString());
                }
                featureNames$1[i] = generatedName;
            } else {
                featureNames$1[i] = name;
            }
            return featureNamesSet.add((Object)featureNames[i]);
        });
        NumericAttribute defaultAttr = NumericAttribute$.MODULE$.defaultAttr();
        Attribute[] attrs = (Attribute[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureNames)).map((Function1 & Serializable & scala.Serializable)name -> defaultAttr.withName(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class))))).toArray(ClassTag$.MODULE$.apply(Attribute.class));
        AttributeGroup attrGroup = new AttributeGroup("userFeatures", attrs);
        return attrGroup.toMetadata();
    }

    public int[] getDistinctIntLabelValues(Dataset<Row> data, String labelColumn) {
        int[] nArray;
        Iterator iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(data.select(labelColumn, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().toLocalIterator()).asScala();
        DataType dataType = data.schema().apply(labelColumn).dataType();
        DataType dataType2 = DataTypes.IntegerType;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            nArray = (int[])((TraversableOnce)iterator.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)DataHelpers$.$anonfun$getDistinctIntLabelValues$1(x$7))).toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.Int());
        } else {
            DataType dataType4 = DataTypes.LongType;
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                nArray = (int[])((TraversableOnce)((TraversableLike)iterator.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)DataHelpers$.$anonfun$getDistinctIntLabelValues$2(x$8))).toSeq().sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$9 -> (int)x$9, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            } else {
                throw new CatBoostError("Unsupported data type for Integer Label");
            }
        }
        return nArray;
    }

    public float[] getDistinctFloatLabelValues(Dataset<Row> data, String labelColumn) {
        float[] fArray;
        Iterator iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(data.select(labelColumn, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().toLocalIterator()).asScala();
        DataType dataType = data.schema().apply(labelColumn).dataType();
        DataType dataType2 = DataTypes.FloatType;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            fArray = (float[])((TraversableOnce)iterator.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToFloat((float)DataHelpers$.$anonfun$getDistinctFloatLabelValues$1(x$10))).toSeq().sorted((Ordering)Ordering.Float$.MODULE$)).toArray(ClassTag$.MODULE$.Float());
        } else {
            DataType dataType4 = DataTypes.DoubleType;
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                fArray = (float[])((TraversableOnce)((TraversableLike)iterator.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)DataHelpers$.$anonfun$getDistinctFloatLabelValues$2(x$11))).toSeq().sorted((Ordering)Ordering.Double$.MODULE$)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$12 -> (float)x$12, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Float());
            } else {
                throw new CatBoostError("Unsupported data type for Float Label");
            }
        }
        return fArray;
    }

    public TVector_TString getDistinctStringLabelValues(Dataset<Row> data, String labelColumn) {
        Iterator iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(data.select(labelColumn, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().toLocalIterator()).asScala();
        DataType dataType = data.schema().apply(labelColumn).dataType();
        DataType dataType2 = DataTypes.StringType;
        DataType dataType3 = dataType;
        if (dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null) {
            throw new CatBoostError("Unsupported data type for String Label");
        }
        TVector_TString tVector_TString = new TVector_TString((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(((IterableLike)iterator.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.getString(0)).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).toIterable()).asJava());
        return tVector_TString;
    }

    public byte[] calcFeaturesHasNans(Dataset<Row> data, String featuresColumn, int featureCount) {
        int featuresColIdx = data.schema().fieldIndex(featuresColumn);
        Dataset partialResultDf = data.mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
            ObjectRef result = ObjectRef.create((Object)new byte[featureCount]);
            Arrays.fill((byte[])result.elem, (byte)0);
            rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
                DataHelpers$.$anonfun$calcFeaturesHasNans$2(featuresColIdx, featureCount, result, row);
                return BoxedUnit.UNIT;
            });
            return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])result.elem}));
        }, data.sparkSession().implicits().newByteArrayEncoder()).persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        ObjectRef result = ObjectRef.create((Object)new byte[featureCount]);
        Arrays.fill((byte[])result.elem, (byte)0);
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(partialResultDf.toLocalIterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partialResult -> {
            DataHelpers$.$anonfun$calcFeaturesHasNans$4(featureCount, result, partialResult);
            return BoxedUnit.UNIT;
        });
        partialResultDf.unpersist();
        return (byte[])result.elem;
    }

    public Tuple2<ArrayBuffer<Object[]>, TRawObjectsDataProviderPtr> processDatasetWithRawFeatures(Iterator<Row> rows, int featuresColumnIdx, TFeaturesLayoutPtr featuresLayout, int maxUniqCatFeatureValues, boolean keepRawFeaturesInDstRows, int dstRowLength, TLocalExecutor localExecutor) {
        ArrayBuffer dstRows = new ArrayBuffer();
        int[] availableFloatFeaturesFlatIndices = native_impl.GetAvailableFeaturesFlatIndices_Float(featuresLayout.__deref__()).toPrimitiveArray();
        int[] availableCatFeaturesFlatIndices = native_impl.GetAvailableFeaturesFlatIndices_Categorical(featuresLayout.__deref__()).toPrimitiveArray();
        ObjectRef availableFloatFeaturesData = ObjectRef.create((Object)new ArrayBuilder[new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableFloatFeaturesFlatIndices)).size()]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableFloatFeaturesData.elem))).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ((ArrayBuilder[])availableFloatFeaturesData$1.elem)[i] = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Float());
        });
        ObjectRef availableCatFeaturesData = ObjectRef.create((Object)new ArrayBuilder[new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableCatFeaturesFlatIndices)).size()]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableCatFeaturesData.elem))).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ((ArrayBuilder[])availableCatFeaturesData$1.elem)[i] = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        });
        rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
            Object[] rowFields = new Object[dstRowLength];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (i == featuresColumnIdx) {
                    Vector featuresValues = (Vector)row.getAs(i);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableFloatFeaturesFlatIndices)).size()).foreach((Function1 & Serializable & scala.Serializable)j -> DataHelpers$.$anonfun$processDatasetWithRawFeatures$5(availableFloatFeaturesData, featuresValues, availableFloatFeaturesFlatIndices, BoxesRunTime.unboxToInt((Object)j)));
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableCatFeaturesFlatIndices)).size()).foreach((Function1 & Serializable & scala.Serializable)j -> DataHelpers$.$anonfun$processDatasetWithRawFeatures$6(availableCatFeaturesData, featuresValues, availableCatFeaturesFlatIndices, BoxesRunTime.unboxToInt((Object)j)));
                    if (keepRawFeaturesInDstRows) {
                        rowFields$2[i] = row.apply(i);
                    }
                } else {
                    rowFields$2[i] = row.apply(i);
                }
            });
            return dstRows.$plus$eq((Object)rowFields);
        });
        TVector_TMaybeOwningConstArrayHolder_float availableFloatFeaturesDataForBuilder = new TVector_TMaybeOwningConstArrayHolder_float();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableFloatFeaturesData.elem))).foreach((Function1 & Serializable & scala.Serializable)featureData -> BoxesRunTime.boxToBoolean((boolean)DataHelpers$.$anonfun$processDatasetWithRawFeatures$7(availableFloatFeaturesDataForBuilder, featureData)));
        TVector_TMaybeOwningConstArrayHolder_i32 availableCatFeaturesDataForBuilder = new TVector_TMaybeOwningConstArrayHolder_i32();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ArrayBuilder[])availableCatFeaturesData.elem))).foreach((Function1 & Serializable & scala.Serializable)featureData -> BoxesRunTime.boxToBoolean((boolean)DataHelpers$.$anonfun$processDatasetWithRawFeatures$8(availableCatFeaturesDataForBuilder, featureData)));
        TRawObjectsDataProviderPtr rawObjectsDataProviderPtr = native_impl.CreateRawObjectsDataProvider(featuresLayout, dstRows.size(), availableFloatFeaturesDataForBuilder, availableCatFeaturesDataForBuilder, maxUniqCatFeatureValues, localExecutor);
        availableFloatFeaturesData.elem = null;
        availableCatFeaturesData.elem = null;
        System.gc();
        return new Tuple2((Object)dstRows, (Object)rawObjectsDataProviderPtr);
    }

    public DatasetForTraining prepareDatasetForTraining(Pool pool, byte datasetIdx, int workerCount) {
        DatasetForTraining datasetForTraining;
        if (pool.pairsData() != null) {
            RDD cogroupedData = this.getCogroupedMainAndPairsRDD(pool.data(), pool.data().schema().fieldIndex(pool.getOrDefault(pool.groupIdCol())), pool.pairsData(), datasetIdx, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)workerCount))).cache();
            datasetForTraining = new DatasetForTrainingWithPairs(pool, (RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>>)cogroupedData, pool.data().schema(), datasetIdx);
        } else {
            Pool repartitionedPool = pool.repartition(workerCount, true);
            Dataset data = repartitionedPool.data().withColumn("_datasetIdx", functions$.MODULE$.typedLit((Object)BoxesRunTime.boxToByte((byte)datasetIdx), ((TypeTags)package$.MODULE$.universe()).TypeTag().Byte())).cache();
            datasetForTraining = new UsualDatasetForTraining(pool, (Dataset<Row>)data, datasetIdx);
        }
        return datasetForTraining;
    }

    public Tuple2<TDataProviderClosureForJVM, IQuantizedFeaturesDataVisitor> getDataProviderBuilderAndVisitor(boolean hasFeatures, TLocalExecutor localExecutor) {
        TDataProviderBuilderOptions dataProviderBuilderOptions = new TDataProviderBuilderOptions();
        TDataProviderClosureForJVM dataProviderClosure = new TDataProviderClosureForJVM(EDatasetVisitorType.QuantizedFeatures, dataProviderBuilderOptions, hasFeatures, localExecutor);
        IQuantizedFeaturesDataVisitor visitor = dataProviderClosure.GetQuantizedVisitor();
        if (visitor == null) {
            throw new CatBoostError("Failure to create IQuantizedFeaturesDataVisitor");
        }
        return new Tuple2((Object)dataProviderClosure, (Object)visitor);
    }

    public Tuple3<TVector_TDataProviderPtr, TVector_TDataProviderPtr, ArrayBuffer<Object[]>[]> getLoadedDatasets(Seq<DatasetLoadingContext> datasetLoadingContexts, int[] objectCountPerDataset) {
        TVector_TDataProviderPtr dstDataProviders = new TVector_TDataProviderPtr();
        TVector_TDataProviderPtr dstEstimatedDataProviders = new TVector_TDataProviderPtr();
        ArrayBuffer[] dstDatasetsRows = new ArrayBuffer[datasetLoadingContexts.size()];
        ((TraversableLike)datasetLoadingContexts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataHelpers$.$anonfun$getLoadedDatasets$1(objectCountPerDataset, dstDataProviders, dstEstimatedDataProviders, dstDatasetsRows, x0$1);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple3((Object)dstDataProviders, (Object)dstEstimatedDataProviders, (Object)dstDatasetsRows);
    }

    public Tuple3<TVector_TDataProviderPtr, TVector_TDataProviderPtr, ArrayBuffer<Object[]>[]> loadQuantizedDatasets(int datasetCount, QuantizedFeaturesInfoPtr quantizedFeaturesInfo, HashMap<String, Object> columnIndexMap, TIntermediateDataMetaInfo dataMetaInfo, StructType schema, Option<Object> estimatedFeatureCount, TLocalExecutor localExecutor, Iterator<Row> rows, int[] dstRowsColumnIndices, int dstRowLength) {
        IndexedSeq datasetLoadingContexts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), datasetCount).map((Function1 & Serializable & scala.Serializable)x$15 -> DatasetLoadingContext$.MODULE$.apply(quantizedFeaturesInfo, (HashMap<String, Object>)columnIndexMap, dataMetaInfo, schema, null, (Option<Object>)estimatedFeatureCount, localExecutor, dstRowsColumnIndices, dstRowLength), IndexedSeq$.MODULE$.canBuildFrom());
        ObjectRef objectCountPerDataset = ObjectRef.create((Object)new int[datasetCount]);
        Arrays.fill((int[])objectCountPerDataset.elem, 0);
        int datasetIdxColumnIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.getOrElse((Object)"_datasetIdx", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
            DataHelpers$.$anonfun$loadQuantizedDatasets$3(datasetIdxColumnIdx, datasetLoadingContexts, objectCountPerDataset, row);
            return BoxedUnit.UNIT;
        });
        return this.getLoadedDatasets((Seq<DatasetLoadingContext>)datasetLoadingContexts, (int[])objectCountPerDataset.elem);
    }

    public int[] loadQuantizedDatasets$default$9() {
        return null;
    }

    public int loadQuantizedDatasets$default$10() {
        return 0;
    }

    public Tuple3<TVector_TDataProviderPtr, TVector_TDataProviderPtr, ArrayBuffer<Object[]>[]> loadQuantizedDatasetsWithPairs(int datasetOffset, int datasetCount, QuantizedFeaturesInfoPtr quantizedFeaturesInfo, HashMap<String, Object> columnIndexMap, TIntermediateDataMetaInfo dataMetaInfo, StructType datasetSchema, StructType pairsDatasetSchema, Option<Object> estimatedFeatureCount, TLocalExecutor localExecutor, Iterator<Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>> groupsIterator, int[] dstRowsColumnIndices, int dstRowLength) {
        IndexedSeq datasetLoadingContexts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), datasetCount).map((Function1 & Serializable & scala.Serializable)x$17 -> DatasetLoadingContext$.MODULE$.apply(quantizedFeaturesInfo, (HashMap<String, Object>)columnIndexMap, dataMetaInfo, datasetSchema, pairsDatasetSchema, (Option<Object>)estimatedFeatureCount, localExecutor, dstRowsColumnIndices, dstRowLength), IndexedSeq$.MODULE$.canBuildFrom());
        ObjectRef objectCountPerDataset = ObjectRef.create((Object)new int[datasetCount]);
        Arrays.fill((int[])objectCountPerDataset.elem, 0);
        ObjectRef groupIdxPerDataset = ObjectRef.create((Object)new int[datasetCount]);
        Arrays.fill((int[])groupIdxPerDataset.elem, 0);
        int sampleIdIdx = BoxesRunTime.unboxToInt((Object)columnIndexMap.apply((Object)"sampleId"));
        groupsIterator.foreach((Function1 & Serializable & scala.Serializable)group -> {
            DataHelpers$.$anonfun$loadQuantizedDatasetsWithPairs$2(datasetOffset, groupIdxPerDataset, datasetLoadingContexts, sampleIdIdx, objectCountPerDataset, group);
            return BoxedUnit.UNIT;
        });
        return this.getLoadedDatasets((Seq<DatasetLoadingContext>)datasetLoadingContexts, (int[])objectCountPerDataset.elem);
    }

    public int[] loadQuantizedDatasetsWithPairs$default$11() {
        return null;
    }

    public int loadQuantizedDatasetsWithPairs$default$12() {
        return 0;
    }

    public Tuple4<HashMap<String, Object>, String[], int[], Option<Object>> selectColumnsAndReturnIndex(Pool pool, Seq<String> columnTypeNames, boolean includeEstimatedFeatures, boolean includeDatasetIdx, Seq<String> dstColumnNames) {
        None$ none$;
        HashMap columnTypesMap = new HashMap();
        ObjectRef columnsList = ObjectRef.create((Object)new ArrayBuffer());
        IntRef i = IntRef.create((int)0);
        Function2 & Serializable & scala.Serializable updateColumnWithType = (Function2 & Serializable & scala.Serializable)(columnName, columnTypeName) -> {
            DataHelpers$.$anonfun$selectColumnsAndReturnIndex$1(columnsList, columnTypesMap, i, columnName, columnTypeName);
            return BoxedUnit.UNIT;
        };
        columnTypeNames.foreach((Function1 & Serializable & scala.Serializable)columnTypeName -> {
            DataHelpers$.$anonfun$selectColumnsAndReturnIndex$2(pool, updateColumnWithType, columnTypeName);
            return BoxedUnit.UNIT;
        });
        if (includeEstimatedFeatures && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pool.data().schema().fieldNames())).contains((Object)"_estimatedFeatures")) {
            updateColumnWithType.apply((Object)"_estimatedFeatures", (Object)"_estimatedFeatures");
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)pool.getEstimatedFeatureCount()));
        } else {
            none$ = None$.MODULE$;
        }
        None$ estimatedFeatureCount = none$;
        Object object = includeDatasetIdx ? updateColumnWithType.apply((Object)"_datasetIdx", (Object)"_datasetIdx") : BoxedUnit.UNIT;
        ArrayBuffer dstColumnIndices = new ArrayBuffer();
        dstColumnNames.foreach((Function1 & Serializable & scala.Serializable)dstColumnName -> {
            ArrayBuffer arrayBuffer;
            int selectedIdx = ((ArrayBuffer)columnsList$1.elem).indexOf(dstColumnName);
            if (selectedIdx == -1) {
                ((ArrayBuffer)columnsList$1.elem).$plus$eq(dstColumnName);
                dstColumnIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i$1.elem));
                ++i$1.elem;
                arrayBuffer = BoxedUnit.UNIT;
            } else {
                arrayBuffer = dstColumnIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)selectedIdx));
            }
            return arrayBuffer;
        });
        return new Tuple4((Object)columnTypesMap, ((ArrayBuffer)columnsList.elem).toArray(ClassTag$.MODULE$.apply(String.class)), dstColumnIndices.toArray(ClassTag$.MODULE$.Int()), (Object)estimatedFeatureCount);
    }

    public boolean selectColumnsAndReturnIndex$default$4() {
        return false;
    }

    public Seq<String> selectColumnsAndReturnIndex$default$5() {
        return (Seq)Nil$.MODULE$;
    }

    public Tuple3<DatasetForTraining, HashMap<String, Object>, Option<Object>> selectColumnsForTrainingAndReturnIndex(DatasetForTraining data, boolean includeFeatures, boolean includeSampleId, boolean includeEstimatedFeatures, boolean includeDatasetIdx) {
        DatasetForTraining datasetForTraining;
        ArrayBuffer columnTypeNames = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "weight", "groupWeight", "baseline", "groupId", "subgroupId", "timestamp"}));
        Object object = includeFeatures ? columnTypeNames.$plus$eq((Object)"features") : BoxedUnit.UNIT;
        Object object2 = includeSampleId ? columnTypeNames.$plus$eq((Object)"sampleId") : BoxedUnit.UNIT;
        Tuple4<HashMap<String, Object>, String[], int[], Option<Object>> tuple4 = this.selectColumnsAndReturnIndex(data.srcPool(), (Seq<String>)columnTypeNames.toSeq(), includeEstimatedFeatures, includeDatasetIdx && data instanceof UsualDatasetForTraining, this.selectColumnsAndReturnIndex$default$5());
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        HashMap columnIndexMap = (HashMap)tuple4._1();
        String[] selectedColumnNames = (String[])tuple4._2();
        Option estimatedFeatureCount = (Option)tuple4._4();
        Tuple3 tuple3 = new Tuple3((Object)columnIndexMap, (Object)selectedColumnNames, (Object)estimatedFeatureCount);
        Tuple3 tuple32 = tuple3;
        HashMap columnIndexMap2 = (HashMap)tuple32._1();
        String[] selectedColumnNames2 = (String[])tuple32._2();
        Option estimatedFeatureCount2 = (Option)tuple32._3();
        DatasetForTraining datasetForTraining2 = data;
        if (datasetForTraining2 instanceof UsualDatasetForTraining) {
            UsualDatasetForTraining usualDatasetForTraining = (UsualDatasetForTraining)datasetForTraining2;
            Pool srcPool = usualDatasetForTraining.srcPool();
            Dataset<Row> dataFrame = usualDatasetForTraining.data();
            byte datasetIdx = usualDatasetForTraining.datasetIdx();
            datasetForTraining = new UsualDatasetForTraining(srcPool, (Dataset<Row>)dataFrame.select((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedColumnNames2)).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedColumnNames2)).tail())), datasetIdx);
        } else if (datasetForTraining2 instanceof DatasetForTrainingWithPairs) {
            DatasetForTrainingWithPairs datasetForTrainingWithPairs = (DatasetForTrainingWithPairs)datasetForTraining2;
            Pool srcPool = datasetForTrainingWithPairs.srcPool();
            RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>> groupData = datasetForTrainingWithPairs.data();
            StructType mainDataSchema = datasetForTrainingWithPairs.mainDataSchema();
            byte datasetIdx = datasetForTrainingWithPairs.datasetIdx();
            int[] selectedColumnIndices = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedColumnNames2)).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)mainDataSchema.fieldIndex(x$20)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            RDD selectedGroupData = groupData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Tuple2 key;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        key = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Iterable mainPart = (Iterable)tuple2._1();
                Iterable pairsPart = (Iterable)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)key, (Object)new Tuple2(mainPart.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Iterable iterable = x0$2;
                    Iterable iterable2 = (Iterable)iterable.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Row row = x0$3;
                        Row row2 = Row$.MODULE$.fromSeq(Predef$.MODULE$.genericArrayOps(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedColumnIndices)).map((Function1 & Serializable & scala.Serializable)x$21 -> row.apply(BoxesRunTime.unboxToInt((Object)x$21)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq());
                        return row2;
                    }, Iterable$.MODULE$.canBuildFrom());
                    return iterable2;
                }, Iterable$.MODULE$.canBuildFrom()), (Object)pairsPart));
                return tuple23;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            datasetForTraining = new DatasetForTrainingWithPairs(srcPool, (RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>>)selectedGroupData, new StructType((StructField[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedColumnIndices)).map((Function1 & Serializable & scala.Serializable)x$22 -> mainDataSchema.apply(BoxesRunTime.unboxToInt((Object)x$22)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))), datasetIdx);
        } else {
            throw new MatchError((Object)datasetForTraining2);
        }
        UsualDatasetForTraining selectedData = datasetForTraining;
        return new Tuple3((Object)selectedData, (Object)columnIndexMap2, (Object)estimatedFeatureCount2);
    }

    public RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>> getCogroupedMainAndPairsRDD(Dataset<Row> mainData, int mainDataGroupIdFieldIdx, Dataset<Row> pairsData, byte datasetIdx, Option<Object> numPartitions) {
        RDD rDD;
        RDD groupedMainData = mainData.rdd().groupBy((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToByte((byte)datasetIdx), (Object)BoxesRunTime.boxToLong((long)row.getLong(mainDataGroupIdFieldIdx))), ClassTag$.MODULE$.apply(Tuple2.class));
        int pairsGroupIdx = pairsData.schema().fieldIndex("groupId");
        RDD groupedPairsData = pairsData.rdd().groupBy((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToByte((byte)datasetIdx), (Object)BoxesRunTime.boxToLong((long)row.getLong(pairsGroupIdx))), ClassTag$.MODULE$.apply(Tuple2.class));
        Option<Object> option = numPartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions2 = BoxesRunTime.unboxToInt((Object)some.value());
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(groupedMainData, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Iterable.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Byte$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).cogroup(groupedPairsData, numPartitions2);
        } else if (None$.MODULE$.equals(option)) {
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(groupedMainData, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Iterable.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Byte$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).cogroup(groupedPairsData);
        } else {
            throw new MatchError(option);
        }
        return rDD;
    }

    public byte getCogroupedMainAndPairsRDD$default$4() {
        return 0;
    }

    public Option<Object> getCogroupedMainAndPairsRDD$default$5() {
        return None$.MODULE$;
    }

    public PoolFilesPaths downloadQuantizedPoolToTempFiles(DatasetForTraining data, boolean includeFeatures, boolean includeEstimatedFeatures, TLocalExecutor localExecutor, String dataPartName, Logger log, String tmpFilePrefix, String tmpFileSuffix) {
        Tuple3<TVector_TDataProviderPtr, TVector_TDataProviderPtr, ArrayBuffer<Object[]>[]> tuple3;
        log.info(new StringBuilder(44).append("downloadQuantizedPoolToTempFiles for ").append(dataPartName).append(": start").toString());
        Tuple3<DatasetForTraining, HashMap<String, Object>, Option<Object>> tuple32 = this.selectColumnsForTrainingAndReturnIndex(data, includeFeatures, data instanceof DatasetForTrainingWithPairs, includeEstimatedFeatures, false);
        if (tuple32 == null) {
            throw new MatchError(tuple32);
        }
        DatasetForTraining selectedData = (DatasetForTraining)tuple32._1();
        HashMap columnIndexMap = (HashMap)tuple32._2();
        Option estimatedFeatureCount = (Option)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)selectedData, (Object)columnIndexMap, (Object)estimatedFeatureCount);
        Tuple3 tuple34 = tuple33;
        DatasetForTraining selectedData2 = (DatasetForTraining)tuple34._1();
        HashMap columnIndexMap2 = (HashMap)tuple34._2();
        Option estimatedFeatureCount2 = (Option)tuple34._3();
        DatasetForTraining datasetForTraining = selectedData2;
        if (datasetForTraining instanceof UsualDatasetForTraining) {
            UsualDatasetForTraining usualDatasetForTraining = (UsualDatasetForTraining)datasetForTraining;
            Pool srcPool = usualDatasetForTraining.srcPool();
            Dataset<Row> selectedDF = usualDatasetForTraining.data();
            log.info(new StringBuilder(33).append("loadQuantizedDatasets for ").append(dataPartName).append(": start").toString());
            Tuple3<TVector_TDataProviderPtr, TVector_TDataProviderPtr, ArrayBuffer<Object[]>[]> result = this.loadQuantizedDatasets(1, srcPool.quantizedFeaturesInfo(), (HashMap<String, Object>)columnIndexMap2, srcPool.createDataMetaInfo(srcPool.createDataMetaInfo$default$1()), selectedDF.schema(), (Option<Object>)estimatedFeatureCount2, localExecutor, (Iterator<Row>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(selectedDF.toLocalIterator()).asScala()), this.loadQuantizedDatasets$default$9(), this.loadQuantizedDatasets$default$10());
            log.info(new StringBuilder(34).append("loadQuantizedDatasets for ").append(dataPartName).append(": finish").toString());
            tuple3 = result;
        } else if (datasetForTraining instanceof DatasetForTrainingWithPairs) {
            DatasetForTrainingWithPairs datasetForTrainingWithPairs = (DatasetForTrainingWithPairs)datasetForTraining;
            Pool srcPool = datasetForTrainingWithPairs.srcPool();
            RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>> selectedGroupData = datasetForTrainingWithPairs.data();
            StructType selectedMainDataSchema = datasetForTrainingWithPairs.mainDataSchema();
            log.info(new StringBuilder(42).append("loadQuantizedDatasetsWithPairs for ").append(dataPartName).append(": start").toString());
            Tuple3<TVector_TDataProviderPtr, TVector_TDataProviderPtr, ArrayBuffer<Object[]>[]> result = this.loadQuantizedDatasetsWithPairs(data.datasetIdx(), 1, srcPool.quantizedFeaturesInfo(), (HashMap<String, Object>)columnIndexMap2, srcPool.createDataMetaInfo(srcPool.createDataMetaInfo$default$1()), selectedMainDataSchema, srcPool.pairsData().schema(), (Option<Object>)estimatedFeatureCount2, localExecutor, (Iterator<Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Iterable<Row>>, Iterable<Iterable<Row>>>>>)selectedGroupData.toLocalIterator(), this.loadQuantizedDatasetsWithPairs$default$11(), this.loadQuantizedDatasetsWithPairs$default$12());
            log.info(new StringBuilder(43).append("loadQuantizedDatasetsWithPairs for ").append(dataPartName).append(": finish").toString());
            tuple3 = result;
        } else {
            throw new MatchError((Object)datasetForTraining);
        }
        Tuple3<TVector_TDataProviderPtr, TVector_TDataProviderPtr, ArrayBuffer<Object[]>[]> tuple35 = tuple3;
        if (tuple35 == null) {
            throw new MatchError(tuple35);
        }
        TVector_TDataProviderPtr mainDataProviders = (TVector_TDataProviderPtr)tuple35._1();
        TVector_TDataProviderPtr estimatedDataProviders = (TVector_TDataProviderPtr)tuple35._2();
        Tuple2 tuple2 = new Tuple2((Object)mainDataProviders, (Object)estimatedDataProviders);
        Tuple2 tuple22 = tuple2;
        TVector_TDataProviderPtr mainDataProviders2 = (TVector_TDataProviderPtr)tuple22._1();
        TVector_TDataProviderPtr estimatedDataProviders2 = (TVector_TDataProviderPtr)tuple22._2();
        log.info(new StringBuilder(34).append(dataPartName).append(": save loaded data to files: start").toString());
        TDataProviderPtr mainDataProvider = mainDataProviders2.get(0);
        Path tmpMainFilePath = Files.createTempFile(tmpFilePrefix, tmpFileSuffix, new FileAttribute[0]);
        tmpMainFilePath.toFile().deleteOnExit();
        native_impl.SaveQuantizedPool(mainDataProvider, ((Object)tmpMainFilePath).toString());
        None$ tmpPairsDataFilePath = None$.MODULE$;
        if (data instanceof DatasetForTrainingWithPairs) {
            tmpPairsDataFilePath = new Some((Object)Files.createTempFile(tmpFilePrefix, tmpFileSuffix, new FileAttribute[0]));
            ((Path)tmpPairsDataFilePath.get()).toFile().deleteOnExit();
            native_impl.SavePairsInGroupedDsvFormat(mainDataProvider, tmpPairsDataFilePath.get().toString());
        }
        None$ tmpEstimatedFilePath = None$.MODULE$;
        if (estimatedFeatureCount2.isDefined()) {
            tmpEstimatedFilePath = new Some((Object)Files.createTempFile(tmpFilePrefix, tmpFileSuffix, new FileAttribute[0]));
            ((Path)tmpEstimatedFilePath.get()).toFile().deleteOnExit();
            native_impl.SaveQuantizedPool(estimatedDataProviders2.get(0), tmpEstimatedFilePath.get().toString());
        }
        log.info(new StringBuilder(35).append(dataPartName).append(": save loaded data to files: finish").toString());
        log.info(new StringBuilder(45).append("downloadQuantizedPoolToTempFiles for ").append(dataPartName).append(": finish").toString());
        return new PoolFilesPaths(tmpMainFilePath, (Option<Path>)tmpPairsDataFilePath, (Option<Path>)tmpEstimatedFilePath);
    }

    public String downloadQuantizedPoolToTempFiles$default$7() {
        return null;
    }

    public String downloadQuantizedPoolToTempFiles$default$8() {
        return null;
    }

    public TQuantizedObjectsDataProviderPtr downloadSubsetOfQuantizedFeatures(Pool pool, QuantizedFeaturesIndices quantizedFeaturesIndices, Set<Object> selectedFeaturesFlatIndices, TLocalExecutor localExecutor) {
        if (!pool.isQuantized()) {
            throw new CatBoostError("downloadSubsetOfQuantizedFeatures is applicable only for quantized pools");
        }
        SelectedFeaturesOffsets selectedFeaturesOffsets = SelectedFeaturesOffsets$.MODULE$.apply(pool.quantizedFeaturesInfo(), quantizedFeaturesIndices, selectedFeaturesFlatIndices);
        int selectedFeaturesByteSize = selectedFeaturesOffsets.getByteSize();
        StructType selectedFeaturesSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("features", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        ExpressionEncoder selectedFeaturesEncoder = RowEncoder$.MODULE$.apply(selectedFeaturesSchema);
        Dataset selectedFeaturesDf = pool.data().select(pool.getFeaturesCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
            byte[] buffer = new byte[selectedFeaturesByteSize];
            return rows.map((Function1 & Serializable & scala.Serializable)row -> {
                ByteBuffer srcByteBuffer = ByteBuffer.wrap((byte[])row.getAs(0));
                srcByteBuffer.order(ByteOrder.nativeOrder());
                ByteBuffer dstByteBuffer = ByteBuffer.wrap(buffer);
                dstByteBuffer.order(ByteOrder.nativeOrder());
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeaturesOffsets.ui8Offsets())).foreach((Function1 & Serializable & scala.Serializable)offset -> dstByteBuffer.put(srcByteBuffer.get(BoxesRunTime.unboxToInt((Object)offset))));
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeaturesOffsets.ui16Offsets())).foreach((Function1 & Serializable & scala.Serializable)offset -> dstByteBuffer.putShort(srcByteBuffer.getShort(BoxesRunTime.unboxToInt((Object)offset))));
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedFeaturesOffsets.ui32Offsets())).foreach((Function1 & Serializable & scala.Serializable)offset -> dstByteBuffer.putInt(srcByteBuffer.getInt(BoxesRunTime.unboxToInt((Object)offset))));
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer}));
            });
        }, (Encoder)selectedFeaturesEncoder);
        TIntermediateDataMetaInfo dataMetaInfo = new TIntermediateDataMetaInfo();
        dataMetaInfo.setFeaturesLayout(native_impl.CloneWithSelectedFeatures(pool.quantizedFeaturesInfo().GetFeaturesLayout().__deref__(), (int[])selectedFeaturesFlatIndices.toArray(ClassTag$.MODULE$.Int())));
        return ((TVector_TDataProviderPtr)this.loadQuantizedDatasets(1, pool.quantizedFeaturesInfo(), (HashMap<String, Object>)((HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)BoxesRunTime.boxToInteger((int)0))}))), dataMetaInfo, selectedFeaturesSchema, (Option<Object>)None$.MODULE$, localExecutor, (Iterator<Row>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(selectedFeaturesDf.toLocalIterator()).asScala()), this.loadQuantizedDatasets$default$9(), this.loadQuantizedDatasets$default$10())._1()).get(0).GetQuantizedObjectsDataProvider();
    }

    public static final /* synthetic */ boolean $anonfun$selectSchemaFields$1(String[] fieldNames$1, StructField field) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames$1)).contains((Object)field.name());
    }

    public static final /* synthetic */ int $anonfun$getDistinctIntLabelValues$1(Row x$7) {
        return BoxesRunTime.unboxToInt((Object)x$7.getAs(0));
    }

    public static final /* synthetic */ long $anonfun$getDistinctIntLabelValues$2(Row x$8) {
        return BoxesRunTime.unboxToLong((Object)x$8.getAs(0));
    }

    public static final /* synthetic */ float $anonfun$getDistinctFloatLabelValues$1(Row x$10) {
        return BoxesRunTime.unboxToFloat((Object)x$10.getAs(0));
    }

    public static final /* synthetic */ double $anonfun$getDistinctFloatLabelValues$2(Row x$11) {
        return BoxesRunTime.unboxToDouble((Object)x$11.getAs(0));
    }

    public static final /* synthetic */ void $anonfun$calcFeaturesHasNans$2(int featuresColIdx$1, int featureCount$1, ObjectRef result$2, Row row) {
        double[] featureValues = ((Vector)row.getAs(featuresColIdx$1)).toArray();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), featureCount$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (featureValues[i] == featureValues[i]) break block0;
                ((byte[])result$2.elem)[i] = (byte)1;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$calcFeaturesHasNans$4(int featureCount$1, ObjectRef result$3, byte[] partialResult) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), featureCount$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (partialResult[i] != (byte)1) break block0;
                ((byte[])result$3.elem)[i] = (byte)1;
            }
        });
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$processDatasetWithRawFeatures$5(ObjectRef availableFloatFeaturesData$1, Vector featuresValues$1, int[] availableFloatFeaturesFlatIndices$1, int j) {
        return (ArrayBuilder)((ArrayBuilder[])availableFloatFeaturesData$1.elem)[j].$plus$eq((Object)BoxesRunTime.boxToFloat((float)((float)featuresValues$1.apply(availableFloatFeaturesFlatIndices$1[j]))));
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$processDatasetWithRawFeatures$6(ObjectRef availableCatFeaturesData$1, Vector featuresValues$1, int[] availableCatFeaturesFlatIndices$1, int j) {
        return (ArrayBuilder)((ArrayBuilder[])availableCatFeaturesData$1.elem)[j].$plus$eq((Object)BoxesRunTime.boxToInteger((int)((int)featuresValues$1.apply(availableCatFeaturesFlatIndices$1[j]))));
    }

    public static final /* synthetic */ boolean $anonfun$processDatasetWithRawFeatures$7(TVector_TMaybeOwningConstArrayHolder_float availableFloatFeaturesDataForBuilder$1, ArrayBuilder featureData) {
        float[] result = (float[])featureData.result();
        return availableFloatFeaturesDataForBuilder$1.add(result);
    }

    public static final /* synthetic */ boolean $anonfun$processDatasetWithRawFeatures$8(TVector_TMaybeOwningConstArrayHolder_i32 availableCatFeaturesDataForBuilder$1, ArrayBuilder featureData) {
        int[] result = (int[])featureData.result();
        return availableCatFeaturesDataForBuilder$1.add(result);
    }

    public static final /* synthetic */ void $anonfun$getLoadedDatasets$1(int[] objectCountPerDataset$1, TVector_TDataProviderPtr dstDataProviders$1, TVector_TDataProviderPtr dstEstimatedDataProviders$1, ArrayBuffer[] dstDatasetsRows$1, Tuple2 x0$1) {
        Tuple3 tuple3;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i;
            DatasetLoadingContext datasetLoadingContext = (DatasetLoadingContext)tuple2._1();
            Tuple3<TDataProviderPtr, TDataProviderPtr, ArrayBuffer<Object[]>> tuple32 = datasetLoadingContext.postprocessAndGetResults(objectCountPerDataset$1[i = tuple2._2$mcI$sp()]);
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            TDataProviderPtr dataProvider = (TDataProviderPtr)tuple32._1();
            TDataProviderPtr estimatedDataProvider = (TDataProviderPtr)tuple32._2();
            ArrayBuffer dstRows = (ArrayBuffer)tuple32._3();
            tuple3 = new Tuple3((Object)dataProvider, (Object)estimatedDataProvider, (Object)dstRows);
        } else {
            throw new MatchError((Object)tuple2);
        }
        Tuple3 tuple33 = tuple3;
        TDataProviderPtr dataProvider = (TDataProviderPtr)tuple33._1();
        TDataProviderPtr estimatedDataProvider = (TDataProviderPtr)tuple33._2();
        ArrayBuffer dstRows = (ArrayBuffer)tuple33._3();
        dstDataProviders$1.add(dataProvider);
        Object object = estimatedDataProvider != null ? BoxesRunTime.boxToBoolean((boolean)dstEstimatedDataProviders$1.add(estimatedDataProvider)) : BoxedUnit.UNIT;
        dstDatasetsRows$1[i] = dstRows;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$loadQuantizedDatasets$3(int datasetIdxColumnIdx$1, IndexedSeq datasetLoadingContexts$1, ObjectRef objectCountPerDataset$2, Row row) {
        byte datasetIdx = datasetIdxColumnIdx$1 == -1 ? (byte)0 : BoxesRunTime.unboxToByte((Object)row.getAs(datasetIdxColumnIdx$1));
        ((DatasetLoadingContext)datasetLoadingContexts$1.apply((int)datasetIdx)).mainDataRowCallbacks().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.apply((Object)row);
            return BoxedUnit.UNIT;
        });
        ((int[])objectCountPerDataset$2.elem)[datasetIdx] = ((int[])objectCountPerDataset$2.elem)[datasetIdx] + 1;
    }

    public static final /* synthetic */ void $anonfun$loadQuantizedDatasetsWithPairs$4(IndexedSeq datasetLoadingContexts$2, int datasetIdx$1, int sampleIdIdx$2, HashMap sampleIdToIdxInGroup$1, IntRef objectIdxInGroup$1, Row row) {
        ((DatasetLoadingContext)datasetLoadingContexts$2.apply(datasetIdx$1)).mainDataRowCallbacks().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            x$18.apply((Object)row);
            return BoxedUnit.UNIT;
        });
        long sampleId = row.getLong(sampleIdIdx$2);
        sampleIdToIdxInGroup$1.put((Object)BoxesRunTime.boxToLong((long)sampleId), (Object)BoxesRunTime.boxToInteger((int)objectIdxInGroup$1.elem));
        ++objectIdxInGroup$1.elem;
    }

    public static final /* synthetic */ void $anonfun$loadQuantizedDatasetsWithPairs$7(IndexedSeq datasetLoadingContexts$2, int datasetIdx$1, int groupIdx$1, HashMap sampleIdToIdxInGroup$1, Row row) {
        ((DatasetLoadingContext)datasetLoadingContexts$2.apply(datasetIdx$1)).pairsDataRowCallback().apply((Object)BoxesRunTime.boxToInteger((int)groupIdx$1), (Object)sampleIdToIdxInGroup$1, (Object)row);
    }

    public static final /* synthetic */ void $anonfun$loadQuantizedDatasetsWithPairs$2(int datasetOffset$1, ObjectRef groupIdxPerDataset$1, IndexedSeq datasetLoadingContexts$2, int sampleIdIdx$2, ObjectRef objectCountPerDataset$3, Tuple2 group) {
        int datasetIdx = BoxesRunTime.unboxToByte((Object)((Tuple2)group._1())._1()) - datasetOffset$1;
        int groupIdx = ((int[])groupIdxPerDataset$1.elem)[datasetIdx];
        HashMap sampleIdToIdxInGroup = new HashMap();
        IntRef objectIdxInGroup = IntRef.create((int)0);
        ((IterableLike)((Tuple2)group._2())._1()).foreach((Function1 & Serializable & scala.Serializable)it -> {
            it.foreach((Function1 & Serializable & scala.Serializable)row -> {
                DataHelpers$.$anonfun$loadQuantizedDatasetsWithPairs$4(datasetLoadingContexts$2, datasetIdx$1, sampleIdIdx$2, sampleIdToIdxInGroup$1, objectIdxInGroup$1, row);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ((int[])objectCountPerDataset$3.elem)[datasetIdx] = ((int[])objectCountPerDataset$3.elem)[datasetIdx] + objectIdxInGroup.elem;
        ((IterableLike)((Tuple2)group._2())._2()).foreach((Function1 & Serializable & scala.Serializable)it -> {
            it.foreach((Function1 & Serializable & scala.Serializable)row -> {
                DataHelpers$.$anonfun$loadQuantizedDatasetsWithPairs$7(datasetLoadingContexts$2, datasetIdx$1, groupIdx$1, sampleIdToIdxInGroup$1, row);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ((int[])groupIdxPerDataset$1.elem)[datasetIdx] = groupIdx + 1;
    }

    public static final /* synthetic */ void $anonfun$selectColumnsAndReturnIndex$1(ObjectRef columnsList$1, HashMap columnTypesMap$1, IntRef i$1, String columnName, String columnTypeName) {
        ((ArrayBuffer)columnsList$1.elem).$plus$eq((Object)columnName);
        columnTypesMap$1.update((Object)columnTypeName, (Object)BoxesRunTime.boxToInteger((int)i$1.elem));
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$selectColumnsAndReturnIndex$2(Pool pool$1, Function2 updateColumnWithType$1, String columnTypeName) {
        block0: {
            Param<Object> param = pool$1.getParam(new StringBuilder(3).append(columnTypeName).append("Col").toString());
            if (!pool$1.isDefined(param)) break block0;
            updateColumnWithType$1.apply(pool$1.getOrDefault(param), (Object)columnTypeName);
        }
    }

    private DataHelpers$() {
        MODULE$ = this;
    }
}

