/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.CatBoostError;
import ai.catboost.spark.Pool;
import ai.catboost.spark.PoolWriter$;
import ai.catboost.spark.impl.SerializationHelpers$;
import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\u000f\u001e\u0001\u0011B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!A!\u0007\u0001BA\u0002\u0013%1\u0007\u0003\u0005C\u0001\t\u0005\r\u0011\"\u0003D\u0011!I\u0005A!A!B\u0013!\u0004\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011B&\t\u0011Q\u0003!\u0011!Q\u0001\n1C\u0001\"\u0016\u0001\u0003\u0002\u0004%IA\u0016\u0005\tE\u0002\u0011\t\u0019!C\u0005G\"AQ\r\u0001B\u0001B\u0003&q\u000bC\u0003g\u0001\u0011\u0005q\rC\u0003n\u0001\u0011%a\u000eC\u0003v\u0001\u0011%a\u000fC\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u0017\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011\u001d\tY\u0005\u0001C\u0001\u0003'Bq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002\u0000\u0001!\t!!!\b\u0013\u0005\u0015U$!A\t\u0002\u0005\u001de\u0001\u0003\u000f\u001e\u0003\u0003E\t!!#\t\r\u0019<B\u0011AAF\u0011%\tiiFI\u0001\n\u0003\ty\tC\u0005\u0002&^\t\n\u0011\"\u0001\u0002(\"I\u00111V\f\u0012\u0002\u0013\u0005\u0011Q\u0016\u0002\u000b!>|Gn\u0016:ji\u0016\u0014(B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0005dCR\u0014wn\\:u\u0015\u0005\u0011\u0013AA1j\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0011\u0001xn\u001c7\u0016\u00035\u0002\"AL\u0018\u000e\u0003uI!\u0001M\u000f\u0003\tA{w\u000e\\\u0001\u0006a>|G\u000eI\u0001\u001cI\u0006$\u0018M\u0012:b[\u0016\u001cxK]5uKJ4uN]7biZ\u000bG.^3\u0016\u0003Q\u00022AJ\u001b8\u0013\t1tE\u0001\u0004PaRLwN\u001c\t\u0003q}r!!O\u001f\u0011\u0005i:S\"A\u001e\u000b\u0005q\u001a\u0013A\u0002\u001fs_>$h(\u0003\u0002?O\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqt%A\u0010eCR\fgI]1nKN<&/\u001b;fe\u001a{'/\\1u-\u0006dW/Z0%KF$\"\u0001R$\u0011\u0005\u0019*\u0015B\u0001$(\u0005\u0011)f.\u001b;\t\u000f!#\u0011\u0011!a\u0001i\u0005\u0019\u0001\u0010J\u0019\u00029\u0011\fG/\u0019$sC6,7o\u0016:ji\u0016\u0014hi\u001c:nCR4\u0016\r\\;fA\u0005aB-\u0019;b\rJ\fW.Z:Xe&$XM](qi&|gn\u001d,bYV,W#\u0001'\u0011\t5\u0013vgN\u0007\u0002\u001d*\u0011q\nU\u0001\b[V$\u0018M\u00197f\u0015\t\tv%\u0001\u0006d_2dWm\u0019;j_:L!a\u0015(\u0003\u000f!\u000b7\u000f['ba\u0006iB-\u0019;b\rJ\fW.Z:Xe&$XM](qi&|gn\u001d,bYV,\u0007%\u0001\u0005tCZ,Wj\u001c3f+\u00059\u0006C\u0001-a\u001b\u0005I&B\u0001.\\\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003=qS!!\u00180\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0016aA8sO&\u0011\u0011-\u0017\u0002\t'\u00064X-T8eK\u0006a1/\u0019<f\u001b>$Wm\u0018\u0013fcR\u0011A\t\u001a\u0005\b\u0011&\t\t\u00111\u0001X\u0003%\u0019\u0018M^3N_\u0012,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006Q&T7\u000e\u001c\t\u0003]\u0001AQaK\u0006A\u00025BqAM\u0006\u0011\u0002\u0003\u0007A\u0007C\u0004K\u0017A\u0005\t\u0019\u0001'\t\u000fU[\u0001\u0013!a\u0001/\u0006\tr-\u001a;NKR\fG-\u0019;b)>\u001c\u0016M^3\u0015\u0005]z\u0007\"\u00029\r\u0001\u0004\t\u0018AA:d!\t\u00118/D\u0001\\\u0013\t!8L\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0007tCZ,W*\u001a;bI\u0006$\u0018\r\u0006\u0003EofT\b\"\u0002=\u000e\u0001\u00049\u0014\u0001\u00029bi\"DQ\u0001]\u0007A\u0002EDQa_\u0007A\u0002q\f!BZ5mKNK8\u000f^3n!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\u0005\u0019\u001c(bAA\u00029\u00061\u0001.\u00193p_BL1!a\u0002\u007f\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u0017I\u0006$\u0018M\u0012:b[\u0016\u001cxK]5uKJ4uN]7biR\u0019\u0001.!\u0004\t\r\u0005=a\u00021\u00018\u0003\u0019\u0019x.\u001e:dK\u00061B-\u0019;b\rJ\fW.Z:Xe&$XM](qi&|g\u000eF\u0003i\u0003+\tI\u0002\u0003\u0004\u0002\u0018=\u0001\raN\u0001\u0005]\u0006lW\rC\u0004\u0002\u001c=\u0001\r!!\b\u0002\u000bY\fG.^3\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005!A.\u00198h\u0015\t\t9#\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003C\u0011aa\u00142kK\u000e$\u0018a\u00063bi\u00064%/Y7fg^\u0013\u0018\u000e^3s\u001fB$\u0018n\u001c8t)\rA\u0017\u0011\u0007\u0005\b\u0003g\u0001\u0002\u0019AA\u001b\u0003\u001dy\u0007\u000f^5p]N\u0004b!a\u000e\u0002:]:T\"\u0001)\n\u0007\u0005m\u0002KA\u0002NCB$2\u0001[A \u0011\u001d\t\u0019$\u0005a\u0001\u0003\u0003\u0002b!a\u0011\u0002J]:TBAA#\u0015\u0011\t9%!\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003w\t)%\u0001\u0003n_\u0012,Gc\u00015\u0002P!1\u0011\u0011\u000b\nA\u0002]\n1b]1wK6{G-Z!sOR\u0019\u0001.!\u0016\t\r\u0005E3\u00031\u0001X\u00035\u0019\u0018M^3ECR\fgI]1nKR)A)a\u0017\u0002~!9\u0011Q\f\u000bA\u0002\u0005}\u0013!\u00033bi\u00064%/Y7f!\u0011\t\t'a\u001e\u000f\t\u0005\r\u00141\u000f\b\u0005\u0003K\n\tH\u0004\u0003\u0002h\u0005=d\u0002BA5\u0003[r1AOA6\u0013\u0005y\u0016BA/_\u0013\tqB,\u0003\u0002[7&\u0019\u0011QO-\u0002\u000fA\f7m[1hK&!\u0011\u0011PA>\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002veCQ\u0001\u001f\u000bA\u0002]\nAa]1wKR\u0019A)a!\t\u000ba,\u0002\u0019A\u001c\u0002\u0015A{w\u000e\\,sSR,'\u000f\u0005\u0002//M\u0011q#\n\u000b\u0003\u0003\u000f\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAAIU\r!\u00141S\u0016\u0003\u0003+\u0003B!a&\u0002\"6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*A\u0005v]\u000eDWmY6fI*\u0019\u0011qT\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0006e%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!++\u00071\u000b\u0019*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003_S3aVAJ\u0001")
public class PoolWriter {
    private final Pool pool;
    private Option<String> dataFramesWriterFormatValue;
    private final HashMap<String, String> dataFramesWriterOptionsValue;
    private SaveMode saveMode;

    public static SaveMode $lessinit$greater$default$4() {
        return PoolWriter$.MODULE$.$lessinit$greater$default$4();
    }

    public static HashMap<String, String> $lessinit$greater$default$3() {
        return PoolWriter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return PoolWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public Pool pool() {
        return this.pool;
    }

    private Option<String> dataFramesWriterFormatValue() {
        return this.dataFramesWriterFormatValue;
    }

    private void dataFramesWriterFormatValue_$eq(Option<String> x$1) {
        this.dataFramesWriterFormatValue = x$1;
    }

    private HashMap<String, String> dataFramesWriterOptionsValue() {
        return this.dataFramesWriterOptionsValue;
    }

    private SaveMode saveMode() {
        return this.saveMode;
    }

    private void saveMode_$eq(SaveMode x$1) {
        this.saveMode = x$1;
    }

    private String getMetadataToSave(SparkContext sc) {
        JsonAST.JObject basicMetadata;
        String uid = this.pool().uid();
        JsonAST.JObject x$1 = basicMetadata = JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonListAssoc$.MODULE$.$tilde$extension1(JsonDSL$.MODULE$.jobject2assoc(JsonAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionedByGroups"), (Object)BoxesRunTime.boxToBoolean((boolean)this.pool().partitionedByGroups())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uid"), (Object)uid), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))), JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sparkVersion"), (Object)sc.version()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        String metadataJson = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        return metadataJson;
    }

    private void saveMetadata(String path, SparkContext sc, FileSystem fileSystem) {
        Path metadataFsPath = new Path(path, "metadata");
        Object object = fileSystem.exists(metadataFsPath) ? BoxesRunTime.boxToBoolean((boolean)fileSystem.delete(metadataFsPath, true)) : BoxedUnit.UNIT;
        String metadataJson = this.getMetadataToSave(sc);
        sc.parallelize((Seq)new .colon.colon((Object)metadataJson, (List)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(metadataFsPath.toString());
    }

    public PoolWriter dataFramesWriterFormat(String source) {
        if (this.pool().isQuantized()) {
            String string = source;
            boolean bl = "csv".equals(string) ? true : "text".equals(string);
            if (bl) {
                String arg$macro$1 = source;
                throw new CatBoostError(new StringOps("format '%s' is not supported for quantized Pool serialization").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
            }
            if ("json".equals(string)) {
                String arg$macro$2 = source;
                throw new CatBoostError(new StringBuilder(32).append(new StringOps("format '%s' is not supported for quantized Pool serialization as 'features' are returned as ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2}))).append("StringType instead of BinaryType").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string = source;
            boolean bl = "csv".equals(string) ? true : "text".equals(string);
            if (bl) {
                String arg$macro$3 = source;
                throw new CatBoostError(new StringOps("format '%s' is not supported for Pool serialization").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3})));
            }
            boolean bl2 = "json".equals(string) ? true : "orc".equals(string);
            if (bl2) {
                String arg$macro$4 = source;
                throw new CatBoostError(new StringBuilder(33).append(new StringOps("format '%s' is not supported for Pool serialization as 'features' are returned as ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4}))).append("WrappedArray instead of VectorUDT").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.dataFramesWriterFormatValue_$eq((Option<String>)new Some((Object)source));
        return this;
    }

    public PoolWriter dataFramesWriterOption(String name, Object value) {
        this.dataFramesWriterOptionsValue().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)value.toString()));
        return this;
    }

    public PoolWriter dataFramesWriterOptions(Map<String, String> options) {
        this.dataFramesWriterOptionsValue().$plus$plus$eq(options);
        return this;
    }

    public PoolWriter dataFramesWriterOptions(java.util.Map<String, String> options) {
        this.dataFramesWriterOptionsValue().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala());
        return this;
    }

    public PoolWriter mode(String saveModeArg) {
        SaveMode saveMode;
        String string = saveModeArg.toLowerCase(Locale.ROOT);
        if ("ignore".equals(string)) {
            saveMode = SaveMode.Ignore;
        } else if ("overwrite".equals(string)) {
            saveMode = SaveMode.Overwrite;
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                saveMode = SaveMode.ErrorIfExists;
            } else {
                throw new IllegalArgumentException(new StringBuilder(93).append("Unknown save mode: ").append(saveModeArg).append(". ").append("Accepted save modes are 'ignore', 'overwrite', 'error', 'errorifexists'.").toString());
            }
        }
        this.saveMode_$eq(saveMode);
        return this;
    }

    public PoolWriter mode(SaveMode saveModeArg) {
        SaveMode saveMode = saveModeArg;
        if (SaveMode.Append.equals(saveMode)) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Unknown save mode: ").append(saveModeArg).append(". ").append("Accepted save modes are Ignore, Overwrite, ErrorIfExists.").toString());
        }
        SaveMode saveMode2 = saveModeArg;
        this.saveMode_$eq(saveMode2);
        return this;
    }

    private void saveDataFrame(Dataset<Row> dataFrame, String path) {
        DataFrameWriter dataFrameWriter = dataFrame.write().options(this.dataFramesWriterOptionsValue()).mode(this.saveMode());
        Object object = this.dataFramesWriterFormatValue().nonEmpty() ? dataFrameWriter.format((String)this.dataFramesWriterFormatValue().get()) : BoxedUnit.UNIT;
        dataFrameWriter.save(path);
    }

    public void save(String path) {
        Boolean bl;
        Path fsPath = new Path(path);
        SparkContext sc = this.pool().data().sparkSession().sparkContext();
        FileSystem fileSystem = fsPath.getFileSystem(sc.hadoopConfiguration());
        if (fileSystem.exists(fsPath)) {
            SaveMode saveMode = this.saveMode();
            SaveMode saveMode2 = SaveMode.Ignore;
            if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null)) {
                return;
            }
            SaveMode saveMode3 = this.saveMode();
            SaveMode saveMode4 = SaveMode.ErrorIfExists;
            if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null)) {
                throw new CatBoostError(new StringBuilder(30).append("Data at path '").append(path).append("' already exists").toString());
            }
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)fileSystem.mkdirs(fsPath));
        }
        this.saveMetadata(path, sc, fileSystem);
        this.saveDataFrame(this.pool().data(), new Path(path, "data").toString());
        if (this.pool().pairsData() != null) {
            this.saveDataFrame(this.pool().pairsData(), new Path(path, "pairsData").toString());
        }
        SerializationHelpers$.MODULE$.writeObject(fileSystem, new Path(path, "quantizedFeaturesInfo"), this.pool().quantizedFeaturesInfo());
        SerializationHelpers$.MODULE$.writeObject(fileSystem, new Path(path, "paramMap"), this.pool().extractParamMap());
    }

    public PoolWriter(Pool pool, Option<String> dataFramesWriterFormatValue, HashMap<String, String> dataFramesWriterOptionsValue, SaveMode saveMode) {
        this.pool = pool;
        this.dataFramesWriterFormatValue = dataFramesWriterFormatValue;
        this.dataFramesWriterOptionsValue = dataFramesWriterOptionsValue;
        this.saveMode = saveMode;
    }
}

