/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.CatBoostError;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;

public final class SparkHelpers$ {
    public static SparkHelpers$ MODULE$;

    static {
        new SparkHelpers$();
    }

    public long parseMemoryOverHeadOption(String memoryOverhead) {
        long l;
        Regex withUnitRE = new StringOps(Predef$.MODULE$.augmentString("^([\\d]+)(k|m|g|t|K|M|G|T)$")).r();
        Regex withoutUnitRE = new StringOps(Predef$.MODULE$.augmentString("^([\\d]+)$")).r();
        String string = memoryOverhead;
        Option option = withUnitRE.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            int n;
            String value = (String)((LinearSeqOptimized)option.get()).apply(0);
            String unit = (String)((LinearSeqOptimized)option.get()).apply(1);
            long l2 = new StringOps(Predef$.MODULE$.augmentString(value)).toLong();
            String string2 = unit;
            boolean bl = "k".equals(string2) ? true : "K".equals(string2);
            if (bl) {
                n = 10;
            } else {
                boolean bl2 = "m".equals(string2) ? true : "M".equals(string2);
                if (bl2) {
                    n = 20;
                } else {
                    boolean bl3 = "g".equals(string2) ? true : "G".equals(string2);
                    if (bl3) {
                        n = 30;
                    } else {
                        boolean bl4 = "t".equals(string2) ? true : "T".equals(string2);
                        if (bl4) {
                            n = 40;
                        } else {
                            throw new RuntimeException("Internal error: Incorrect regex matching");
                        }
                    }
                }
            }
            l = l2 << n;
        } else {
            Option option2 = withoutUnitRE.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String value = (String)((LinearSeqOptimized)option2.get()).apply(0);
                l = new StringOps(Predef$.MODULE$.augmentString(value)).toLong() << 20;
            } else {
                throw new CatBoostError(new StringBuilder(39).append("bad format for memory overhead string: ").append(memoryOverhead).toString());
            }
        }
        return l;
    }

    public int getThreadCountForDriver(SparkSession spark) {
        Option taskCpusConfig = spark.sparkContext().getConf().getOption("spark.driver.cores");
        return new StringOps(Predef$.MODULE$.augmentString((String)taskCpusConfig.getOrElse((Function0 & java.io.Serializable & Serializable)() -> "1"))).toInt();
    }

    public int getThreadCountForTask(SparkSession spark) {
        Option taskCpusConfig = spark.sparkContext().getConf().getOption("spark.task.cpus");
        return new StringOps(Predef$.MODULE$.augmentString((String)taskCpusConfig.getOrElse((Function0 & java.io.Serializable & Serializable)() -> "1"))).toInt();
    }

    public int getWorkerCount(SparkSession spark) {
        int n;
        if (spark.sparkContext().isLocal()) {
            n = 1;
        } else {
            int NumRetriesForExecutorsStartWait = 60;
            IntRef currentExecutorCount = IntRef.create((int)0);
            IntRef retryCount = IntRef.create((int)0);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
                while (true) {
                    if (retryCount$1.elem == NumRetriesForExecutorsStartWait) {
                        throw new RuntimeException(new StringBuilder(55).append("Unable to get the number of Spark executors in ").append(NumRetriesForExecutorsStartWait).append(" seconds").toString());
                    }
                    retryCount$1.elem = 0;
                    int executorCount = spark.sparkContext().statusTracker().getExecutorInfos().length;
                    if (executorCount > 1) {
                        if (executorCount == currentExecutorCount$1.elem) {
                            throw Breaks$.MODULE$.break();
                        }
                        currentExecutorCount$1.elem = executorCount;
                    }
                    Thread.sleep(1000L);
                    ++retryCount$1.elem;
                }
            });
            n = currentExecutorCount.elem - 1;
        }
        return n;
    }

    public String getDriverHost(SparkSession spark) {
        return (String)spark.sparkContext().getConf().getOption("spark.driver.host").get();
    }

    public Option<Object> getDriverNativeMemoryLimit(SparkSession spark) {
        Option optionalValue = spark.sparkContext().getConf().getOption("spark.driver.memoryOverhead");
        return optionalValue.isDefined() ? new Some((Object)BoxesRunTime.boxToLong((long)this.parseMemoryOverHeadOption((String)optionalValue.get()))) : None$.MODULE$;
    }

    public Option<Object> getExecutorNativeMemoryLimit(SparkSession spark) {
        Option optionalValue = spark.sparkContext().getConf().getOption("spark.executor.memoryOverhead");
        return optionalValue.isDefined() ? new Some((Object)BoxesRunTime.boxToLong((long)this.parseMemoryOverHeadOption((String)optionalValue.get()))) : None$.MODULE$;
    }

    private SparkHelpers$() {
        MODULE$ = this;
    }
}

