/*
 * Decompiled with CFR 0.152.
 */
package ai.catboost.spark;

import ai.catboost.CatBoostError;
import ai.catboost.spark.CatBoostTrainingDriverConnectException;
import ai.catboost.spark.WorkerInfo;
import ai.catboost.spark.impl.TimeHelpers$;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;
import sun.net.util.IPAddressUtil;

public final class TrainingDriver$
implements Logging {
    public static final TrainingDriver$ MODULE$ = new TrainingDriver$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Duration $lessinit$greater$default$4() {
        return Duration.ofMinutes(1L);
    }

    public Duration $lessinit$greater$default$5() {
        return Duration.ofMinutes(10L);
    }

    public Duration $lessinit$greater$default$6() {
        return Duration.ofSeconds(40L);
    }

    public Duration $lessinit$greater$default$7() {
        return Duration.ofMinutes(5L);
    }

    public void saveHostsListToFile(Path hostsFilePath, WorkerInfo[] workersInfo) {
        try (PrintWriter pw = new PrintWriter(hostsFilePath.toFile());){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])workersInfo), (Function1 & Serializable)workerInfo -> {
                TrainingDriver$.$anonfun$saveHostsListToFile$1(pw, workerInfo);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getWorkerPort() {
        void v0;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            void var2_2;
            int localPort = serverSocket.getLocalPort();
            this.log().info(new StringBuilder(34).append("Reserved port ").append(localPort).append(" for CatBoost worker").toString());
            v0 = var2_2;
        }
        return (int)v0;
    }

    public boolean isWorkerListening(String host, int port, Duration connectTimeout) {
        boolean connected;
        block2: {
            boolean bl;
            Socket socket = new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(host, port);
            try {
                socket.connect(socketAddress, (int)connectTimeout.toMillis());
                bl = true;
            }
            catch (Throwable throwable) {
                bl = connected = false;
            }
            if (!connected) break block2;
            socket.close();
        }
        return connected;
    }

    public void waitForListeningPortAndSendWorkerInfo(InetSocketAddress trainingDriverListeningAddress, int partitionId, int partitionSize, int workerPort, Duration connectTimeout, Duration workerInitializationTimeout) {
        if (workerInitializationTimeout.toMillis() < 10L) {
            throw new RuntimeException("workerInitializationTimeout must be >= 10 ms");
        }
        if (partitionSize > 0) {
            this.log().info(new StringBuilder(52).append("wait for CatBoost worker to start listening at port ").append(workerPort).toString());
            Instant initializationDeadline = Instant.now().plus(workerInitializationTimeout);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                do {
                    Thread.sleep(10L);
                    if (!MODULE$.isWorkerListening("localhost", workerPort, workerInitializationTimeout)) continue;
                    MODULE$.log().info(new StringBuilder(42).append("CatBoost worker started listening at port ").append(workerPort).toString());
                    throw Breaks$.MODULE$.break();
                } while (Instant.now().compareTo(initializationDeadline) <= 0);
                throw new CatBoostError(new StringBuilder(39).append("Initial worker wait timeout of ").append(TimeHelpers$.MODULE$.format(workerInitializationTimeout)).append(" expired").toString());
            });
        }
        this.log().info(new StringBuilder(47).append("send WorkerInfo to CatBoost training driver at ").append(trainingDriverListeningAddress).toString());
        Socket socket = new Socket();
        try {
            socket.connect(trainingDriverListeningAddress, (int)connectTimeout.toMillis());
        }
        catch (Throwable e) {
            throw new CatBoostTrainingDriverConnectException(e);
        }
        WorkerInfo workerInfo = new WorkerInfo(partitionId, partitionSize, socket.getLocalAddress().getHostAddress(), workerPort);
        this.log().info(new StringBuilder(11).append("WorkerInfo=").append(workerInfo).toString());
        try (OutputStream outputStream = socket.getOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            objectOutputStream.writeUnshared(workerInfo);
        }
        finally {
            socket.close();
        }
        this.log().info("WorkerInfo has been successfully sent to CatBoost training driver");
    }

    public static final /* synthetic */ void $anonfun$saveHostsListToFile$1(PrintWriter pw$1, WorkerInfo workerInfo) {
        block2: {
            if (workerInfo.partitionSize() <= 0) break block2;
            if (IPAddressUtil.isIPv6LiteralAddress(workerInfo.host())) {
                pw$1.println(new StringBuilder(3).append("[").append(workerInfo.host()).append("]:").append(workerInfo.port()).toString());
            } else {
                pw$1.println(new StringBuilder(1).append(workerInfo.host()).append(":").append(workerInfo.port()).toString());
            }
        }
    }

    private TrainingDriver$() {
    }
}

