package ai.causalfoundry.android.sdk.e_commerce.catalog

import ai.causalfoundry.android.sdk.core.CFSetup
import ai.causalfoundry.android.sdk.core.catalog.catalog_models.CatalogSubject
import ai.causalfoundry.android.sdk.core.utils.ExceptionManager
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.BloodCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.DrugCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.GroceryCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.MedicalEquipmentCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.OxygenCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.event_types.ItemType
import ai.causalfoundry.android.sdk.e_commerce.utils.ECommerceConstants
import com.google.gson.Gson

object CfEComCatalog {

    fun callCatalogAPI(itemId: String, itemtype: String, catalogModel: Any) {

        if (itemtype == ItemType.drug.name &&
            catalogModel is DrugCatalogModel
        ) {
            updateDrugCatalog(itemId, catalogModel)
        } else if (itemtype == ItemType.blood.name &&
            catalogModel is BloodCatalogModel
        ) {
            updateBloodCatalog(itemId, catalogModel)
        } else if (itemtype == ItemType.oxygen.name &&
            catalogModel is OxygenCatalogModel
        ) {
            updateOxygenCatalog(itemId, catalogModel)
        } else if (itemtype == ItemType.medical_equipment.name &&
            catalogModel is MedicalEquipmentCatalogModel
        ) {
            updateMedicalEquipmentCatalog(itemId, catalogModel)
        } else if (itemtype == ItemType.grocery.name &&
            catalogModel is GroceryCatalogModel
        ) {
            updateGroceryCatalog(itemId, catalogModel)
        } else {
            ExceptionManager.throwIllegalStateException(
                "Please use correct catalog properties with provided item type"
            )
        }
    }


    //////////////////////////////////////////////////////
    // Drug Catalog
    //////////////////////////////////////////////////////

    fun updateDrugCatalog(drugId: String, drugCatalogModel: String) {
        updateDrugCatalog(
            drugId,
            Gson().fromJson(drugCatalogModel, DrugCatalogModel::class.java)
        )
    }

    fun updateDrugCatalog(drugId: String, drugCatalogModel: DrugCatalogModel) {

        val drugInternalCatalog = ECommerceConstants.verifyCatalogForDrug(drugId, drugCatalogModel)

        CFSetup().updateCatalogItem(CatalogSubject.drug, drugInternalCatalog)

    }


    //////////////////////////////////////////////////////
    // Grocery Catalog
    //////////////////////////////////////////////////////

    fun updateGroceryCatalog(itemId: String, groceryCatalogModel: String) {
        updateGroceryCatalog(
            itemId,
            Gson().fromJson(groceryCatalogModel, GroceryCatalogModel::class.java)
        )
    }

    fun updateGroceryCatalog(itemId: String, groceryCatalogModel: GroceryCatalogModel) {

        val groceryInternalCatalog =
            ECommerceConstants.verifyCatalogForGrocery(itemId, groceryCatalogModel)

        CFSetup().updateCatalogItem(CatalogSubject.grocery, groceryInternalCatalog)

    }


    //////////////////////////////////////////////////////
    // Blood Catalog
    //////////////////////////////////////////////////////

    fun updateBloodCatalog(itemId: String, bloodCatalogModel: String) {
        updateBloodCatalog(
            itemId,
            Gson().fromJson(bloodCatalogModel, BloodCatalogModel::class.java)
        )
    }

    fun updateBloodCatalog(itemId: String, bloodCatalogModel: BloodCatalogModel) {

        val bloodInternalCatalog =
            ECommerceConstants.verifyCatalogForBlood(itemId, bloodCatalogModel)

        CFSetup().updateCatalogItem(CatalogSubject.blood, bloodInternalCatalog)

    }


    //////////////////////////////////////////////////////
    // Oxygen Catalog
    //////////////////////////////////////////////////////

    fun updateOxygenCatalog(itemId: String, oxygenCatalogModel: String) {
        updateOxygenCatalog(
            itemId,
            Gson().fromJson(oxygenCatalogModel, OxygenCatalogModel::class.java)
        )
    }

    fun updateOxygenCatalog(itemId: String, oxygenCatalogModel: OxygenCatalogModel) {

        val oxygenInternalCatalog =
            ECommerceConstants.verifyCatalogForOxygen(itemId, oxygenCatalogModel)

        CFSetup().updateCatalogItem(CatalogSubject.oxygen, oxygenInternalCatalog)

    }


    //////////////////////////////////////////////////////
    // Medical Equipment Catalog
    //////////////////////////////////////////////////////

    fun updateMedicalEquipmentCatalog(itemId: String, medicalEquipmentCatalogModel: String) {
        updateMedicalEquipmentCatalog(
            itemId,
            Gson().fromJson(medicalEquipmentCatalogModel, MedicalEquipmentCatalogModel::class.java)
        )
    }

    fun updateMedicalEquipmentCatalog(
        itemId: String,
        medicalEquipmentCatalogModel: MedicalEquipmentCatalogModel
    ) {

        val medicalInternalCatalog = ECommerceConstants.verifyCatalogForMedicalEquipment(
            itemId,
            medicalEquipmentCatalogModel
        )

        CFSetup().updateCatalogItem(CatalogSubject.medical_equipment, medicalInternalCatalog)

    }


}