package ai.causalfoundry.android.sdk.e_commerce.event_types

/**
 * Created by Moiz Hassan on 22 March, 2023
 */

enum class ItemType(private val value: String) {
    Blood("blood"),
    Oxygen("oxygen"),
    Drug("drug"),
    MedicalEquipment("medical_equipment"),
    Grocery("grocery"),
    Facility("facility"),
    Subscription("subscription"),
    ItemVerification("item_verification"),
    ItemReport("item_report"),
    Reward("reward"),
    Survey("survey"),
    Electronics("electronics"),
    Clothing("clothing"),
    Book("book"),
    Misc("misc");

    override fun toString(): String {
        return when (this) {
            Blood -> "blood"
            Oxygen -> "oxygen"
            Drug -> "drug"
            MedicalEquipment -> "medical_equipment"
            Grocery -> "grocery"
            Facility -> "facility"
            Subscription -> "subscription"
            ItemVerification -> "item_verification"
            ItemReport -> "item_report"
            Reward -> "reward"
            Survey -> "survey"
            Electronics -> "electronics"
            Clothing -> "clothing"
            Book -> "book"
            Misc -> "misc"
        }
    }
}