package ai.causalfoundry.android.sdk.e_commerce.event_types

/**
 * Created by Moiz Hassan on 22 March, 2023
 */

enum class EComEventType(private val value: String) {
    Item("item"),
    Delivery("delivery"),
    Checkout("checkout"),
    Cart("cart"),
    CancelCheckout("cancel_checkout"),
    ItemReport("item_report"),
    ItemVerification("item_verification"),
    ItemRequest("item_request");

    override fun toString(): String {
        return when (this) {
            Item -> "item"
            Delivery -> "delivery"
            Checkout -> "checkout"
            Cart -> "cart"
            CancelCheckout -> "cancel_checkout"
            ItemReport -> "item_report"
            ItemVerification -> "item_verification"
            ItemRequest -> "item_request"
        }
    }
}
