package ai.causalfoundry.android.sdk.e_commerce

import ai.causalfoundry.android.sdk.e_commerce.catalog.EComCatalogType
import ai.causalfoundry.android.sdk.e_commerce.event_types.EComEventType
import ai.causalfoundry.android.sdk.e_commerce.interactor.CFEComSetupInterface
import ai.causalfoundry.android.sdk.e_commerce.interactor.CFEComSetupInterfaceImpl


object CFEComEvent {

    private val setupInterface: CFEComSetupInterface
        get() = CFEComSetupInterfaceImpl()

    fun logIngest(
        eventType: EComEventType,
        logObject: Any,
        isUpdateImmediately: Boolean? = null,
        eventTime: Long? = null
    ) {
        setupInterface.trackSDKEvent(
            eventType = eventType,
            logObject = logObject,
            isUpdateImmediately = isUpdateImmediately,
            eventTime = eventTime
        )
    }

    fun logCatalog(ecomCatalogType: EComCatalogType, catalogModel: Any) {
        setupInterface.trackCatalogEvent(ecomCatalogType, catalogModel)
    }
}
