package ai.causalfoundry.android.sdk.e_commerce.catalog

import ai.causalfoundry.android.sdk.core.CFSetup
import ai.causalfoundry.android.sdk.core.catalog.catalog_models.CatalogSubject
import ai.causalfoundry.android.sdk.core.utils.ExceptionManager
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.BloodCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.DrugCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.FacilityCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.GroceryCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.MedicalEquipmentCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.OxygenCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.event_types.ItemType
import ai.causalfoundry.android.sdk.e_commerce.utils.ECommerceConstants
import com.google.gson.Gson

internal object CfEComCatalog {

    //////////////////////////////////////////////////////
    // Drug Catalog
    //////////////////////////////////////////////////////

    fun updateDrugCatalog(drugCatalogModel: DrugCatalogModel) {
        val drugInternalCatalog = ECommerceConstants.verifyCatalogForDrug(drugCatalogModel)
        CFSetup().updateCatalogItem(CatalogSubject.Drug, drugInternalCatalog)
    }

    //////////////////////////////////////////////////////
    // Grocery Catalog
    //////////////////////////////////////////////////////

    fun updateGroceryCatalog(groceryCatalogModel: GroceryCatalogModel) {
        val groceryInternalCatalog = ECommerceConstants.verifyCatalogForGrocery(groceryCatalogModel)
        CFSetup().updateCatalogItem(CatalogSubject.Grocery, groceryInternalCatalog)
    }


    //////////////////////////////////////////////////////
    // Blood Catalog
    //////////////////////////////////////////////////////

    fun updateBloodCatalog(bloodCatalogModel: BloodCatalogModel) {
        val bloodInternalCatalog = ECommerceConstants.verifyCatalogForBlood(bloodCatalogModel)
        CFSetup().updateCatalogItem(CatalogSubject.Blood, bloodInternalCatalog)
    }


    //////////////////////////////////////////////////////
    // Oxygen Catalog
    //////////////////////////////////////////////////////

    fun updateOxygenCatalog(oxygenCatalogModel: OxygenCatalogModel) {
        val oxygenInternalCatalog = ECommerceConstants.verifyCatalogForOxygen(oxygenCatalogModel)
        CFSetup().updateCatalogItem(CatalogSubject.Oxygen, oxygenInternalCatalog)
    }


    //////////////////////////////////////////////////////
    // Medical Equipment Catalog
    //////////////////////////////////////////////////////

    fun updateMedicalEquipmentCatalog(medicalEquipmentCatalogModel: MedicalEquipmentCatalogModel) {
        val medicalInternalCatalog = ECommerceConstants.verifyCatalogForMedicalEquipment(
            medicalEquipmentCatalogModel
        )
        CFSetup().updateCatalogItem(CatalogSubject.MedicalEquipment, medicalInternalCatalog)
    }

    //////////////////////////////////////////////////////
    // Facility Catalog
    //////////////////////////////////////////////////////

    fun updateFacilityCatalog(
        facilityCatalogModel: FacilityCatalogModel
    ) {
        val facilityInternalCatalog = ECommerceConstants.verifyCatalogForFacility(
            facilityCatalogModel
        )
        CFSetup().updateCatalogItem(CatalogSubject.Facility, facilityInternalCatalog)

    }


}