package ai.causalfoundry.android.sdk.e_commerce.catalog

/**
 * Created by Moiz Hassan on 09 December,2024
 */

enum class EComCatalogType(private val value: String) {
    Drug("drug"),
    Grocery("grocery"),
    Blood("blood"),
    Oxygen("oxygen"),
    MedicalEquipment("medical_equipment"),
    Facility("facility");

    companion object {
        fun fromValue(value: String): EComCatalogType? {
            return values().find { it.value == value }
        }
    }

    override fun toString(): String {
        return value
    }
}
