package ai.causalfoundry.android.sdk.e_commerce.event_models

import ai.causalfoundry.android.sdk.core.utils.Converters
import ai.causalfoundry.android.sdk.e_commerce.event_models.event_objects.CancelCheckoutObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.event_objects.CartObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.event_objects.CheckoutObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.event_objects.DeliveryObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.event_objects.ItemReportObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.event_objects.ItemVerificationObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.event_objects.ViewItemObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.item_objects.ItemInfoObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.item_objects.ItemModel
import ai.causalfoundry.android.sdk.e_commerce.event_models.item_objects.ItemTypeModel
import ai.causalfoundry.android.sdk.e_commerce.event_models.item_objects.SubscriptionObject


internal object EComEventMappers {

    fun mapViewItemEventToInternalViewItemEvent(viewItemObject: ViewItemObject): InternalViewItemObject {
        return InternalViewItemObject(
            action = viewItemObject.action.toString(),
            item = mapItemObjectToInternalItemObject(viewItemObject.item),
            meta = viewItemObject.meta

        )
    }

    fun mapCartObjectToInternalCartObject(cartObject: CartObject): InternalCartObject {
        return InternalCartObject(
            cartId = cartObject.cartId,
            action = cartObject.action.toString(),
            item = mapItemObjectToInternalItemObject(cartObject.item),
            cartPrice = cartObject.cartPrice,
            currency = cartObject.currency.name,
            meta = cartObject.meta
        )
    }

    fun mapCheckoutObjectToInternalCheckoutObject(checkoutObject: CheckoutObject): InternalCheckoutObject {
        return InternalCheckoutObject(
            orderId = checkoutObject.orderId,
            cartId = checkoutObject.cartId,
            isSuccessful = checkoutObject.isSuccessful,
            cartPrice = checkoutObject.cartPrice,
            currency = checkoutObject.currency.name,
            shopMode = checkoutObject.shopMode.toString(),
            itemList = checkoutObject.itemList.map { mapItemObjectToInternalItemObject(it) },
            meta = checkoutObject.meta
        )
    }

    fun mapCancelCheckoutObjectToInternalCancelCheckoutObject(cancelCheckoutObject: CancelCheckoutObject): InternalCancelCheckoutObject {
        return InternalCancelCheckoutObject(
            id = cancelCheckoutObject.checkoutId,
            type = cancelCheckoutObject.type.toString(),
            itemsList = cancelCheckoutObject.itemsList.map {
                mapItemTypeModelToInternalItemTypeModel(
                    it
                )
            },
            reason = cancelCheckoutObject.reason,
            meta = cancelCheckoutObject.meta
        )
    }

    fun mapDeliveryObjectToInternalDeliveryObject(deliveryObject: DeliveryObject): InternalDeliveryObject {
        return InternalDeliveryObject(
            id = deliveryObject.deliveryId,
            orderId = deliveryObject.orderId,
            action = deliveryObject.action.toString(),
            isUrgent = deliveryObject.isUrgent,
            deliveryTs = Converters.convertMillisToTimeString(deliveryObject.deliveryTs),
            deliveryCoordinates = deliveryObject.deliveryCoordinates,
            dispatchCoordinates = deliveryObject.dispatchCoordinates,
            meta = deliveryObject.meta
        )
    }

    fun mapItemReportObjectToInternalItemReportObject(itemReportObject: ItemReportObject): InternalItemReportObject {
        return InternalItemReportObject(
            item = mapItemTypeModelToInternalItemTypeModel(itemReportObject.item),
            storeInfo = itemReportObject.storeInfo,
            reportInfo = itemReportObject.reportInfo,
            meta = itemReportObject.meta
        )
    }

    fun mapItemVerificationToInternalItemVerificationObject(itemVerificationObject: ItemVerificationObject): InternalItemVerificationObject {
        return InternalItemVerificationObject(
            scanChannel = itemVerificationObject.scanChannel.toString(),
            scanType = itemVerificationObject.scanType.toString(),
            isSuccessful = itemVerificationObject.isSuccessful,
            itemInfo = itemVerificationObject.itemInfo?.let(::mapItemInfoObjectToInternalItemInfoModel),
            meta = itemVerificationObject.meta
        )
    }


///////////////////
// ITEM OBJECTS
///////////////////

    internal fun mapItemObjectToInternalItemObject(item: ItemModel): InternalItemModel {
        return InternalItemModel(
            id = item.id,
            quantity = item.quantity,
            price = item.price,
            currency = item.currency.name,
            type = item.type.toString(),
            discount = item.discount,
            stockStatus = item.stockStatus.toString(),
            promoId = item.promoId,
            facilityId = item.facilityId,
            subscription = mapSubscriptionObjectToInternalSubscriptionObject(item.subscription),
            meta = item.meta

        )
    }

    private fun mapItemTypeModelToInternalItemTypeModel(itemTypeModel: ItemTypeModel): InternalItemTypeModel {
        return InternalItemTypeModel(
            itemId = itemTypeModel.itemId,
            itemType = itemTypeModel.itemType.toString(),
            facilityId = itemTypeModel.facilityId
        )
    }

    private fun mapItemInfoObjectToInternalItemInfoModel(itemTypeModel: ItemInfoObject): InternalItemInfoObject {
        return InternalItemInfoObject(
            id = itemTypeModel.itemId,
            type = itemTypeModel.type.toString(),
            batchId = itemTypeModel.batchId,
            surveyId = itemTypeModel.surveyId,
            rewardId = itemTypeModel.rewardId,
            isFeatured = itemTypeModel.isFeatured,
            productionDate = itemTypeModel.productionDate,
            expiryDate = itemTypeModel.expiryDate,
            meta = itemTypeModel.meta
        )
    }

    private fun mapSubscriptionObjectToInternalSubscriptionObject(subscription: SubscriptionObject?): InternalSubscriptionObject? {
        return if (subscription == null) {
            null
        } else {
            InternalSubscriptionObject(
                status = subscription.status,
                type = subscription.type,
                subscriptionItems = subscription.subscriptionItems?.map {
                    mapItemTypeModelToInternalItemTypeModel(
                        it
                    )
                })
        }
    }

}