package ai.causalfoundry.android.sdk.e_commerce.event_models

import ai.causalfoundry.android.sdk.e_commerce.event_models.item_objects.CoordinatesObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.item_objects.ReportObject
import ai.causalfoundry.android.sdk.e_commerce.event_models.item_objects.StoreObject
import com.google.gson.annotations.SerializedName


internal data class InternalViewItemObject(
    @SerializedName("action")
    var action: String,
    @SerializedName("item")
    var item: InternalItemModel,
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalCartObject(
    @SerializedName("id")
    var cartId: String,
    @SerializedName("action")
    var action: String,
    @SerializedName("item")
    var item: InternalItemModel,
    @SerializedName("cart_price")
    var cartPrice: Double,
    @SerializedName("currency")
    var currency: String,
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalCheckoutObject(
    @SerializedName("id")
    var orderId: String,
    @SerializedName("cart_id")
    var cartId: String,
    @SerializedName("is_successful")
    var isSuccessful: Boolean,
    @SerializedName("cart_price")
    var cartPrice: Double,
    @SerializedName("currency")
    var currency: String,
    @SerializedName("shop_mode")
    var shopMode: String,
    @SerializedName("items")
    var itemList: List<InternalItemModel> = listOf(),
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalCancelCheckoutObject(
    @SerializedName("id")
    var id: String,
    @SerializedName("type")
    var type: String,
    @SerializedName("items")
    var itemsList: List<InternalItemTypeModel> = listOf(),
    @SerializedName("reason")
    var reason: String? = "",
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalDeliveryObject(
    @SerializedName("id")
    var id: String,
    @SerializedName("order_id")
    var orderId: String,
    @SerializedName("action")
    var action: String,
    @SerializedName("is_urgent")
    var isUrgent: Boolean,
    @SerializedName("est_delivery_ts")
    var deliveryTs: String,
    @SerializedName("delivery_coordinates")
    var deliveryCoordinates: CoordinatesObject?,
    @SerializedName("dispatch_coordinates")
    var dispatchCoordinates: CoordinatesObject?,
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalItemReportObject(
    @SerializedName("item")
    var item: InternalItemTypeModel,
    @SerializedName("store_info")
    var storeInfo: StoreObject,
    @SerializedName("report_info")
    var reportInfo: ReportObject,
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalItemVerificationObject(
    @SerializedName("scan_channel")
    var scanChannel: String,
    @SerializedName("scan_type")
    var scanType: String,
    @SerializedName("is_successful")
    var isSuccessful: Boolean,
    @SerializedName("item_info")
    var itemInfo: InternalItemInfoObject? = null,
    @SerializedName("meta")
    var meta: Any? = null
)


///////////////////
// ITEM OBJECTS
///////////////////

internal data class InternalItemModel(
    @SerializedName("id")
    var id: String,
    @SerializedName("quantity")
    var quantity: Int,
    @SerializedName("price")
    var price: Double,
    @SerializedName("currency")
    var currency: String,
    @SerializedName("type")
    var type: String,
    @SerializedName("discount")
    var discount: Double? = 0.0,
    @SerializedName("stock_status")
    var stockStatus: String? = "",
    @SerializedName("promo_id")
    var promoId: String? = "",
    @SerializedName("facility_id")
    var facilityId: String? = "",
    @SerializedName("subscription")
    var subscription: InternalSubscriptionObject? = null,
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalItemTypeModel(
    @SerializedName("id")
    var itemId: String,
    @SerializedName("type")
    var itemType: String,
    @SerializedName("facility_id")
    var facilityId: String? = ""
)

internal data class InternalSubscriptionObject(
    @SerializedName("status")
    var status: String,
    @SerializedName("type")
    var type: String,
    @SerializedName("subscription_items")
    var subscriptionItems: List<InternalItemTypeModel>? = listOf()
)

internal data class InternalItemInfoObject(
    @SerializedName("id")
    var id: String,
    @SerializedName("type")
    var type: String,
    @SerializedName("batch_id")
    var batchId: String? = "",
    @SerializedName("survey_id")
    var surveyId: String? = "",
    @SerializedName("reward_id")
    var rewardId: String? = "",
    @SerializedName("is_featured")
    var isFeatured: Boolean? = false,
    @SerializedName("production_date")
    var productionDate: Long? = 0L,
    @SerializedName("expiry_date")
    var expiryDate: Long? = 0L,
    @SerializedName("meta")
    var meta: Any? = null
)


