package ai.causalfoundry.android.sdk.e_commerce.interactor

import ai.causalfoundry.android.sdk.core.CFSetup
import ai.causalfoundry.android.sdk.core.event_types.ContentBlock
import ai.causalfoundry.android.sdk.core.utils.CoreConstants
import ai.causalfoundry.android.sdk.core.utils.ExceptionManager
import ai.causalfoundry.android.sdk.e_commerce.catalog.CfEComCatalog
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.BloodCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.DrugCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.EComCatalogType
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.FacilityCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.GroceryCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.MedicalEquipmentCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.catalog.catalog_models.OxygenCatalogModel
import ai.causalfoundry.android.sdk.e_commerce.event_types.EComEventType
import ai.causalfoundry.android.sdk.e_commerce.validators.EComEventValidator

internal class CFEComSetupInterfaceImpl() : CFEComSetupInterface {
    override fun trackSDKEvent(eventType: EComEventType,
                               logObject: Any,
                               isUpdateImmediately: Boolean?,
                               eventTime: Long?) {
        if(CoreConstants.pauseSDK){
            return
        }
        CFSetup().track(
            contentBlockName = ContentBlock.ECommerce.toString(),
            eventType =  eventType.toString(),
            logObject = validateEComEvent(eventType, logObject),
            updateImmediately = isUpdateImmediately ?: CoreConstants.updateImmediately,
            eventTime = eventTime ?: 0
        )
    }

    override fun trackCatalogEvent(ecomCatalogType: EComCatalogType, catalogModel: Any) {
        if(CoreConstants.pauseSDK){
            return
        }
        validateEComCatalogEvent(ecomCatalogType, catalogModel)
    }

    fun validateEComEvent(eventType: EComEventType, logObject: Any) : Any?{
        return when (eventType) {
            EComEventType.Item -> {
                EComEventValidator.validateItemObject(logObject = logObject)
            }
            EComEventType.Cart -> {
                EComEventValidator.validateCartObject(logObject = logObject)
            }
            EComEventType.Checkout -> {
                EComEventValidator.validateCheckoutObject(logObject = logObject)
            }
            EComEventType.CancelCheckout -> {
                EComEventValidator.validateCancelCheckoutObject(logObject = logObject)
            }
            EComEventType.Delivery -> {
                EComEventValidator.validateDeliveryObject(logObject = logObject)
            }
            EComEventType.ItemReport -> {
                EComEventValidator.validateItemReportObject(logObject = logObject)
            }
            EComEventType.ItemRequest -> {
                EComEventValidator.validateItemRequestObject(logObject = logObject)
            }
            EComEventType.ItemVerification -> {
                EComEventValidator.validateItemVerificationObject(logObject = logObject)
            }
        }
    }

    fun validateEComCatalogEvent(ecomCatalogType: EComCatalogType, catalogObject: Any) : Any? {
        return when (ecomCatalogType) {
            EComCatalogType.Drug -> {
                when (catalogObject) {
                    is DrugCatalogModel -> {
                        CfEComCatalog.updateDrugCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            EComCatalogType.Drug.toString(),
                            DrugCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }
            EComCatalogType.Grocery -> {
                when (catalogObject) {
                    is GroceryCatalogModel -> {
                        CfEComCatalog.updateGroceryCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            EComCatalogType.Grocery.toString(),
                            GroceryCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }
            EComCatalogType.Blood -> {
                when (catalogObject) {
                    is BloodCatalogModel -> {
                        CfEComCatalog.updateBloodCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            EComCatalogType.Blood.toString(),
                            BloodCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }
            EComCatalogType.Oxygen -> {
                when (catalogObject) {
                    is OxygenCatalogModel -> {
                        CfEComCatalog.updateOxygenCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            EComCatalogType.Oxygen.toString(),
                            OxygenCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }
            EComCatalogType.MedicalEquipment -> {
                when (catalogObject) {
                    is MedicalEquipmentCatalogModel -> {
                        CfEComCatalog.updateMedicalEquipmentCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            EComCatalogType.MedicalEquipment.toString(),
                            MedicalEquipmentCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }
            EComCatalogType.Facility -> {
                when (catalogObject) {
                    is FacilityCatalogModel -> {
                        CfEComCatalog.updateFacilityCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            EComCatalogType.Facility.toString(),
                            FacilityCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }

        }
    }

}