package ai.causalfoundry.android.sdk.loyalty.catalog

import ai.causalfoundry.android.sdk.core.CFSetup
import ai.causalfoundry.android.sdk.core.catalog.catalog_models.CatalogSubject
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.SurveyCatalogModel
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.internal_catalog_models.InternalRewardModel
import ai.causalfoundry.android.sdk.core.event_types.CountryCode
import ai.causalfoundry.android.sdk.core.event_types.EducationalLevel
import ai.causalfoundry.android.sdk.core.event_types.LanguageCode
import ai.causalfoundry.android.sdk.core.retrofit.data.PaperObject
import ai.causalfoundry.android.sdk.core.utils.CoreConstants
import ai.causalfoundry.android.sdk.core.utils.ExceptionManager
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.RewardCatalogModel
import ai.causalfoundry.android.sdk.loyalty.utils.LoyaltyConstants
import com.google.gson.Gson

object CfLoyaltyCatalog {


    //////////////////////////////////////////////////////
    // Survey Catalog
    //////////////////////////////////////////////////////

    fun updateSurveyCatalog(surveyId : String, surveyCatalogModel: String){
        updateSurveyCatalog(surveyId,
                Gson().fromJson(surveyCatalogModel, SurveyCatalogModel::class.java))
    }

    fun updateSurveyCatalog(surveyId : String, surveyCatalogModel : SurveyCatalogModel) {
        CFSetup().updateCatalogItem(
            CatalogSubject.survey,
            LoyaltyConstants.verifyCatalogForSurvey(surveyId, surveyCatalogModel))
    }


    //////////////////////////////////////////////////////
    // Reward Catalog
    //////////////////////////////////////////////////////

    fun updateRewardCatalog(rewardId : String, rewardCatalogModel: String){
        updateRewardCatalog(rewardId,
            Gson().fromJson(rewardCatalogModel, RewardCatalogModel::class.java))
    }

    fun updateRewardCatalog(rewardId : String, rewardCatalogModel : RewardCatalogModel) {
        CFSetup().updateCatalogItem(
            CatalogSubject.reward,
            LoyaltyConstants.verifyCatalogForReward(rewardId, rewardCatalogModel))
    }

}