package ai.causalfoundry.android.sdk.loyalty.event_types

/**
 * Created by Moiz Hassan on 04 April, 2023
 */

enum class SurveyType(private val value: String) {
    OpenEnded("open_ended"),
    ClosedEnded("closed_ended"),
    Nominal("nominal"),
    LikertScale("likert_scale"),
    RatingScale("rating_scale"),
    YesNo("yes_no"),
    Interview("interview"),
    Other("other");

    override fun toString(): String {
        return when (this) {
            OpenEnded -> "open_ended"
            ClosedEnded -> "closed_ended"
            Nominal -> "nominal"
            LikertScale -> "likert_scale"
            RatingScale -> "rating_scale"
            YesNo -> "yes_no"
            Interview -> "interview"
            Other -> "other"
        }
    }
}
