package ai.causalfoundry.android.sdk.loyalty.catalog

import ai.causalfoundry.android.sdk.core.CFSetup
import ai.causalfoundry.android.sdk.core.catalog.catalog_models.CatalogSubject
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.RewardCatalogModel
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.SurveyCatalogModel
import ai.causalfoundry.android.sdk.loyalty.utils.LoyaltyConstants
import com.google.gson.Gson

object CfLoyaltyCatalog {


    //////////////////////////////////////////////////////
    // Survey Catalog
    //////////////////////////////////////////////////////

    fun updateSurveyCatalog(surveyId: String, surveyCatalogModel: String) {
        updateSurveyCatalog(
            surveyId,
            Gson().fromJson(surveyCatalogModel, SurveyCatalogModel::class.java)
        )
    }

    fun updateSurveyCatalog(surveyId: String, surveyCatalogModel: SurveyCatalogModel) {
        val surveyCatalogObject =
            LoyaltyConstants.verifyCatalogForSurvey(surveyId, surveyCatalogModel)
        CFSetup().updateCatalogItem(
            CatalogSubject.Survey, surveyCatalogObject
        )
    }


    //////////////////////////////////////////////////////
    // Reward Catalog
    //////////////////////////////////////////////////////

    fun updateRewardCatalog(rewardId: String, rewardCatalogModel: String) {
        updateRewardCatalog(
            rewardId,
            Gson().fromJson(rewardCatalogModel, RewardCatalogModel::class.java)
        )
    }

    fun updateRewardCatalog(rewardId: String, rewardCatalogModel: RewardCatalogModel) {
        val rewardCatalogObject =
            LoyaltyConstants.verifyCatalogForReward(rewardId, rewardCatalogModel)
        CFSetup().updateCatalogItem(
            CatalogSubject.Reward, rewardCatalogObject
        )
    }

}