package ai.causalfoundry.android.sdk.loyalty

import ai.causalfoundry.android.sdk.loyalty.catalog.LoyaltyCatalogSubject
import ai.causalfoundry.android.sdk.loyalty.event_types.LoyaltyEventType
import ai.causalfoundry.android.sdk.loyalty.interactor.CFLoyaltySetupInterface
import ai.causalfoundry.android.sdk.loyalty.interactor.CFLoyaltySetupInterfaceImpl


object CFLoyaltyEvent {

    private val setupInterface: CFLoyaltySetupInterface
        get() = CFLoyaltySetupInterfaceImpl()

    fun logIngest(
        eventType: LoyaltyEventType,
        logObject: Any,
        isUpdateImmediately: Boolean? = null,
        eventTime: Long? = null
    ) {
        setupInterface.trackSDKEvent(
            eventType = eventType,
            logObject = logObject,
            isUpdateImmediately = isUpdateImmediately,
            eventTime = eventTime
        )
    }

    fun logCatalog(loyaltyCatalogType: LoyaltyCatalogSubject, catalogModel: Any) {
        setupInterface.trackCatalogEvent(loyaltyCatalogType, catalogModel)
    }
}
