package ai.causalfoundry.android.sdk.loyalty.catalog

import ai.causalfoundry.android.sdk.core.CFSetup
import ai.causalfoundry.android.sdk.core.catalog.catalog_models.CatalogSubject
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.RewardCatalogModel
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.SurveyCatalogModel
import ai.causalfoundry.android.sdk.loyalty.utils.LoyaltyConstants
import com.google.gson.Gson

internal object CfLoyaltyCatalog {

    //////////////////////////////////////////////////////
    // Survey Catalog
    //////////////////////////////////////////////////////

    fun updateSurveyCatalog(surveyCatalogModel: SurveyCatalogModel) {
        val surveyCatalogObject =
            LoyaltyConstants.verifySurveyCatalog(surveyCatalogModel)
        CFSetup().updateCatalogItem(
            CatalogSubject.Survey, surveyCatalogObject
        )
    }


    //////////////////////////////////////////////////////
    // Reward Catalog
    //////////////////////////////////////////////////////

    fun updateRewardCatalog(rewardCatalogModel: RewardCatalogModel) {
        val rewardCatalogObject =
            LoyaltyConstants.verifyRewardCatalog(rewardCatalogModel)
        CFSetup().updateCatalogItem(
            CatalogSubject.Reward, rewardCatalogObject
        )
    }

}