package ai.causalfoundry.android.sdk.loyalty.event_models

import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.MilestoneObject
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.PromoObject
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.RewardEventObject
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.SurveyEventObject
import ai.causalfoundry.android.sdk.loyalty.event_models.item_objects.PromoItem
import ai.causalfoundry.android.sdk.loyalty.event_models.item_objects.RedeemItem
import ai.causalfoundry.android.sdk.loyalty.event_models.item_objects.SurveyItem
import ai.causalfoundry.android.sdk.loyalty.event_models.item_objects.SurveyResponseItem


internal object LoyaltyEventMappers {

    fun mapMilestoneEventToInternalMilestoneEvent(logObject: MilestoneObject): InternalMilestoneObject {
        return InternalMilestoneObject(
            id = logObject.id,
            action = logObject.action.toString(),
            meta = logObject.meta
        )
    }

    fun mapPromoEventToInternalPromoEvent(logObject: PromoObject): InternalPromoObject {
        return InternalPromoObject(
            promoId = logObject.promoId,
            promoAction = logObject.promoAction.toString(),
            promoTitle = logObject.promoTitle,
            promoType = logObject.promoType.toString(),
            promoItemsList = logObject.promoItemsList.map { mapPromoItemToInternalPromoItem(it) },
            meta = logObject.meta
        )
    }

    private fun mapPromoItemToInternalPromoItem(logObject: PromoItem): InternalPromoItem {
        return InternalPromoItem(
            itemId = logObject.itemId,
            itemType = logObject.itemType.toString()
        )
    }

    fun mapRewardEventToInternalRewardEvent(logObject: RewardEventObject): InternalRewardEventObject {
        return InternalRewardEventObject(
            rewardId = logObject.rewardId,
            action = logObject.action.toString(),
            accPoints = logObject.accPoints,
            totalPoints = logObject.totalPoints,
            redeem = mapRedeemItemToInternalRedeemItem(logObject.redeem),
            meta = logObject.meta
        )
    }

    private fun mapRedeemItemToInternalRedeemItem(logObject: RedeemItem?): InternalRedeemItem? {
        if (logObject == null) {
            return null
        }
        return InternalRedeemItem(
            type = logObject.type.toString(),
            pointsWithdrawn = logObject.pointsWithdrawn,
            convertedValue = logObject.convertedValue,
            currency = logObject.currency?.name,
            isSuccessful = logObject.isSuccessful
        )
    }

    fun mapSurveyEventToInternalSurveyEvent(logObject: SurveyEventObject): InternalSurveyEventObject {
        return InternalSurveyEventObject(
            action = logObject.action.toString(),
            survey = mapSurveyObjectToInternalSurveyObject(logObject.survey),
            responseList = logObject.responseList.map { mapResponseItemToInternalResponseItem(it) },
            meta = logObject.meta
        )
    }

    private fun mapSurveyObjectToInternalSurveyObject(logObject: SurveyItem): InternalSurveyItem {
        return InternalSurveyItem(
            id = logObject.id,
            isCompleted = logObject.isCompleted,
            rewardId = logObject.rewardId,
            type = logObject.type.toString()
        )
    }

    private fun mapResponseItemToInternalResponseItem(logObject: SurveyResponseItem): InternalSurveyResponseItem {
        return InternalSurveyResponseItem(
            id = logObject.id,
            question = logObject.question,
            response = logObject.response,
            type = logObject.type.toString()
        )
    }


}