package ai.causalfoundry.android.sdk.loyalty.event_models

import com.google.gson.annotations.SerializedName

internal data class InternalMilestoneObject(
    @SerializedName("id")
    var id: String,
    @SerializedName("action")
    var action: String,
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalPromoObject(
    @SerializedName("id")
    var promoId: String,
    @SerializedName("action")
    var promoAction: String,
    @SerializedName("title")
    var promoTitle: String,
    @SerializedName("type")
    var promoType: String,
    @SerializedName("items")
    var promoItemsList: List<InternalPromoItem> = listOf(),
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalPromoItem(
    @SerializedName("id")
    var itemId: String,
    @SerializedName("type")
    var itemType: String
)

internal data class InternalRewardEventObject(
    @SerializedName("id")
    var rewardId: String,
    @SerializedName("action")
    var action: String,
    @SerializedName("acc_points")
    var accPoints: Float? = 0f,
    @SerializedName("total_points")
    var totalPoints: Float? = 0f,
    @SerializedName("redeem")
    var redeem: InternalRedeemItem? = null,
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalRedeemItem(
    @SerializedName("type")
    var type: String,
    @SerializedName("points_withdrawn")
    var pointsWithdrawn: Float? = 0f,
    @SerializedName("converted_value")
    var convertedValue: Float? = 0f,
    @SerializedName("currency")
    var currency: String? = null,
    @SerializedName("is_successful")
    var isSuccessful: Boolean? = null
)

internal data class InternalSurveyEventObject(
    @SerializedName("action")
    var action: String,
    @SerializedName("survey")
    var survey: InternalSurveyItem,
    @SerializedName("response")
    var responseList: List<InternalSurveyResponseItem> = listOf(),
    @SerializedName("meta")
    var meta: Any? = null
)

internal data class InternalSurveyItem(
    @SerializedName("id")
    var id: String,
    @SerializedName("is_completed")
    var isCompleted: Boolean,
    @SerializedName("reward_id")
    var rewardId: String? = null,
    @SerializedName("type")
    var type: String
)

internal data class InternalSurveyResponseItem(
    @SerializedName("id")
    var id: String,
    @SerializedName("question")
    var question: String,
    @SerializedName("response")
    var response: String,
    @SerializedName("type")
    var type: String
)
