package ai.causalfoundry.android.sdk.loyalty.interactor

import ai.causalfoundry.android.sdk.core.CFSetup
import ai.causalfoundry.android.sdk.core.event_types.ContentBlock
import ai.causalfoundry.android.sdk.core.utils.CoreConstants
import ai.causalfoundry.android.sdk.core.utils.ExceptionManager
import ai.causalfoundry.android.sdk.loyalty.catalog.CfLoyaltyCatalog
import ai.causalfoundry.android.sdk.loyalty.catalog.LoyaltyCatalogSubject
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.RewardCatalogModel
import ai.causalfoundry.android.sdk.loyalty.catalog.catalog_models.SurveyCatalogModel
import ai.causalfoundry.android.sdk.loyalty.event_types.LoyaltyEventType
import ai.causalfoundry.android.sdk.loyalty.validators.LoyaltyEventValidator

internal class CFLoyaltySetupInterfaceImpl : CFLoyaltySetupInterface {

    override fun trackSDKEvent(
        eventType: LoyaltyEventType,
        logObject: Any,
        isUpdateImmediately: Boolean?,
        eventTime: Long?
    ) {
        if (CoreConstants.pauseSDK) {
            return
        }
        CFSetup().track(
            contentBlockName = ContentBlock.Loyalty.toString(),
            eventType = eventType.toString(),
            logObject = validateLoyaltyEvent(eventType, logObject),
            updateImmediately = isUpdateImmediately ?: CoreConstants.updateImmediately,
            eventTime = eventTime ?: 0
        )
    }

    override fun trackCatalogEvent(loyaltyCatalogType: LoyaltyCatalogSubject, catalogModel: Any) {
        if(CoreConstants.pauseSDK){
            return
        }
        validateLoyaltyCatalog(loyaltyCatalogType, catalogModel)
    }

    fun validateLoyaltyEvent(eventType: LoyaltyEventType, logObject: Any): Any? {
        return when (eventType) {
            LoyaltyEventType.Level -> {
                LoyaltyEventValidator.validateLevelEvent(logObject = logObject)
            }
            LoyaltyEventType.Milestone -> {
                LoyaltyEventValidator.validateMilestoneEvent(logObject = logObject)
            }
            LoyaltyEventType.Promo -> {
                LoyaltyEventValidator.validatePromoEvent(logObject = logObject)
            }
            LoyaltyEventType.Reward -> {
                LoyaltyEventValidator.validateRewardEvent(logObject = logObject)
            }
            LoyaltyEventType.Survey -> {
                LoyaltyEventValidator.validateSurveyEvent(logObject = logObject)
            }
        }
    }

    fun validateLoyaltyCatalog(loyaltyCatalogType: LoyaltyCatalogSubject, catalogObject: Any) : Any? {
        return when (loyaltyCatalogType) {
            LoyaltyCatalogSubject.Reward -> {
                when (catalogObject) {
                    is RewardCatalogModel -> {
                        CfLoyaltyCatalog.updateRewardCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            LoyaltyCatalogSubject.Reward.toString(),
                            RewardCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }
            LoyaltyCatalogSubject.Survey -> {
                when (catalogObject) {
                    is SurveyCatalogModel -> {
                        CfLoyaltyCatalog.updateSurveyCatalog(catalogObject)
                    }
                    else -> {
                        ExceptionManager.throwInvalidException(
                            LoyaltyCatalogSubject.Survey.toString(),
                            SurveyCatalogModel::class.java.simpleName
                        )
                        null
                    }
                }
            }

        }
    }

}