package ai.causalfoundry.android.sdk.loyalty.validators

import ai.causalfoundry.android.sdk.core.utils.ExceptionManager
import ai.causalfoundry.android.sdk.loyalty.event_models.InternalMilestoneObject
import ai.causalfoundry.android.sdk.loyalty.event_models.InternalPromoObject
import ai.causalfoundry.android.sdk.loyalty.event_models.InternalRewardEventObject
import ai.causalfoundry.android.sdk.loyalty.event_models.InternalSurveyEventObject
import ai.causalfoundry.android.sdk.loyalty.event_models.LoyaltyEventMappers
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.LevelObject
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.MilestoneObject
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.PromoObject
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.RewardEventObject
import ai.causalfoundry.android.sdk.loyalty.event_models.event_objects.SurveyEventObject
import ai.causalfoundry.android.sdk.loyalty.event_types.LoyaltyEventType
import ai.causalfoundry.android.sdk.loyalty.utils.LoyaltyConstants

internal object LoyaltyEventValidator {

    fun validateLevelEvent(logObject: Any): LevelObject? {
        if (logObject !is LevelObject) {
            ExceptionManager.throwInvalidException(
                LoyaltyEventType.Level.toString(),
                LevelObject::class.java.simpleName
            )
            return null
        }
        return if (LoyaltyConstants.isValidLevelEvent(logObject)) {
            logObject
        } else {
            null
        }
    }

    fun validateMilestoneEvent(logObject: Any): InternalMilestoneObject? {
        if (logObject !is MilestoneObject) {
            ExceptionManager.throwInvalidException(
                LoyaltyEventType.Milestone.toString(),
                MilestoneObject::class.java.simpleName
            )
            return null
        }
        return if (LoyaltyConstants.isValidMilestoneEvent(logObject)) {
            LoyaltyEventMappers.mapMilestoneEventToInternalMilestoneEvent(logObject)
        } else {
            null
        }
    }

    fun validatePromoEvent(logObject: Any): InternalPromoObject? {
        if (logObject !is PromoObject) {
            ExceptionManager.throwInvalidException(
                LoyaltyEventType.Promo.toString(),
                PromoObject::class.java.simpleName
            )
            return null
        }
        return if (LoyaltyConstants.isValidPromoObject(logObject)) {
            LoyaltyEventMappers.mapPromoEventToInternalPromoEvent(logObject)
        } else {
            null
        }
    }

    fun validateRewardEvent(logObject: Any): InternalRewardEventObject? {
        if (logObject !is RewardEventObject) {
            ExceptionManager.throwInvalidException(
                LoyaltyEventType.Reward.toString(),
                RewardEventObject::class.java.simpleName
            )
            return null
        }
        return if (LoyaltyConstants.isValidRewardEvent(logObject)) {
            LoyaltyEventMappers.mapRewardEventToInternalRewardEvent(logObject)
        } else {
            null
        }
    }

    fun validateSurveyEvent(logObject: Any): InternalSurveyEventObject? {
        if (logObject !is SurveyEventObject) {
            ExceptionManager.throwInvalidException(
                LoyaltyEventType.Survey.toString(),
                SurveyEventObject::class.java.simpleName
            )
            return null
        }
        return if (LoyaltyConstants.isValidSurveyEvent(logObject)) {
            LoyaltyEventMappers.mapSurveyEventToInternalSurveyEvent(logObject)
        } else {
            null
        }
    }

}