/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.client.GrpcHeaders;
import ai.chalk.client.ServerType;
import ai.chalk.client.TokenRefresher;
import ai.chalk.protos.chalk.server.v1.GetTokenResponse;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatedHeaderClientInterceptor
implements ClientInterceptor {
    private final Map<Metadata.Key<String>, String> allHeaders;
    private final TokenRefresher tokenRefresher;

    public AuthenticatedHeaderClientInterceptor(@NonNull ServerType serverType, @NonNull Map<String, String> additionalHeaders, @NonNull TokenRefresher tokenRefresher, @NonNull String environmentId, @Nullable String deploymentTag) {
        this.tokenRefresher = tokenRefresher;
        this.allHeaders = new HashMap<Metadata.Key<String>, String>(Map.of(GrpcHeaders.SERVER_TYPE_KEY, serverType.headerName(), GrpcHeaders.ENVIRONMENT_ID_KEY, environmentId));
        for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
            this.allHeaders.put((Metadata.Key<String>)Metadata.Key.of((String)entry.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), entry.getValue());
        }
        if (serverType.equals((Object)ServerType.ENGINE)) {
            this.allHeaders.put(GrpcHeaders.DEPLOYMENT_TYPE, "engine-grpc");
        }
        if (deploymentTag != null) {
            this.allHeaders.put(GrpcHeaders.DEPLOYMENT_TAG, deploymentTag);
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                GetTokenResponse token = AuthenticatedHeaderClientInterceptor.this.tokenRefresher.getToken();
                for (Map.Entry<Metadata.Key<String>, String> entry : AuthenticatedHeaderClientInterceptor.this.allHeaders.entrySet()) {
                    headers.put(entry.getKey(), (Object)entry.getValue());
                }
                headers.put(GrpcHeaders.AUTHORIZATION_KEY, (Object)("Bearer " + token.getAccessToken()));
                super.start(responseListener, headers);
            }
        };
    }
}

