/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.client.BuilderImpl;
import ai.chalk.exceptions.ChalkException;
import ai.chalk.models.OnlineQueryParamsComplete;
import ai.chalk.models.OnlineQueryResult;
import java.net.http.HttpClient;

public interface ChalkClient
extends AutoCloseable {
    public static Builder builder() {
        return new BuilderImpl();
    }

    public static ChalkClient create() throws ChalkException {
        return ChalkClient.builder().build();
    }

    public static ChalkClient createGrpc() throws ChalkException {
        return ChalkClient.builder().withGrpc().build();
    }

    public OnlineQueryResult onlineQuery(OnlineQueryParamsComplete var1) throws ChalkException;

    public void printConfig();

    public static interface Builder {
        public Builder withClientId(String var1);

        public Builder withClientSecret(String var1);

        public Builder withApiServer(String var1);

        public Builder withEnvironmentId(String var1);

        public Builder withBranch(String var1);

        public Builder withDeploymentTag(String var1);

        public Builder withHttpClient(HttpClient var1);

        public Builder withGrpc();

        public String getClientId();

        public String getClientSecret();

        public String getApiServer();

        public String getEnvironmentId();

        public String getBranch();

        public String getDeploymentTag();

        public HttpClient getHttpClient();

        public ChalkClient build() throws ChalkException;
    }
}

