/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.client.AuthenticatedHeaderClientInterceptor;
import ai.chalk.client.BuilderImpl;
import ai.chalk.client.ChalkClient;
import ai.chalk.client.GrpcSerializer;
import ai.chalk.client.ResolvedConfig;
import ai.chalk.client.ServerType;
import ai.chalk.client.TokenRefresher;
import ai.chalk.client.UnauthenticatedHeaderClientInterceptor;
import ai.chalk.exceptions.ChalkException;
import ai.chalk.exceptions.ClientException;
import ai.chalk.exceptions.ServerError;
import ai.chalk.internal.arrow.FeatherProcessor;
import ai.chalk.internal.config.Loader;
import ai.chalk.internal.config.models.ProjectToken;
import ai.chalk.models.OnlineQueryParamsComplete;
import ai.chalk.models.OnlineQueryResult;
import ai.chalk.models.QueryMeta;
import ai.chalk.protos.chalk.common.v1.ExplainOptions;
import ai.chalk.protos.chalk.common.v1.FeatherBodyType;
import ai.chalk.protos.chalk.common.v1.FeatureEncodingOptions;
import ai.chalk.protos.chalk.common.v1.OnlineQueryBulkRequest;
import ai.chalk.protos.chalk.common.v1.OnlineQueryBulkResponse;
import ai.chalk.protos.chalk.common.v1.OnlineQueryContext;
import ai.chalk.protos.chalk.common.v1.OnlineQueryResponseOptions;
import ai.chalk.protos.chalk.common.v1.OutputExpr;
import ai.chalk.protos.chalk.engine.v1.QueryServiceGrpc;
import ai.chalk.protos.chalk.server.v1.AuthServiceGrpc;
import ai.chalk.protos.chalk.server.v1.GetTokenResponse;
import ai.chalk.protos.chalk.server.v1.TeamServiceGrpc;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.TlsChannelCredentials;
import io.grpc.stub.MetadataUtils;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.table.Table;

public class GRPCClient
implements ChalkClient,
AutoCloseable {
    private final AuthServiceGrpc.AuthServiceBlockingStub authStub;
    private final TeamServiceGrpc.TeamServiceBlockingStub teamStub;
    private final QueryServiceGrpc.QueryServiceBlockingStub queryStub;
    private static final Metadata.Key<String> CHALK_TRACE_ID_KEY = Metadata.Key.of((String)"x-chalk-trace-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final System.Logger logger = System.getLogger(GRPCClient.class.getName());
    private final RootAllocator allocator = new RootAllocator(5000000000000L);

    public GRPCClient() throws ChalkException {
        this(new BuilderImpl());
    }

    public GRPCClient(BuilderImpl builder) throws ChalkException {
        String engineHost;
        ProjectToken chalkYamlConfig = new ProjectToken();
        try {
            String projectRoot = Loader.loadProjectDirectory();
            chalkYamlConfig = Loader.getChalkYamlConfig(projectRoot);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResolvedConfig resolvedConfig = ResolvedConfig.fromBuilder(builder, chalkYamlConfig);
        if (resolvedConfig.clientId().value().isEmpty() || resolvedConfig.clientSecret().value().isEmpty()) {
            throw new IllegalArgumentException("Client ID and Client Secret are required");
        }
        String grpcHost = resolvedConfig.grpcHost();
        ChannelCredentials channelCreds = grpcHost.startsWith("localhost") || grpcHost.startsWith("127.0.0.1") ? InsecureChannelCredentials.create() : TlsChannelCredentials.create();
        ManagedChannelBuilder unauthenticatedChannelBuilder = Grpc.newChannelBuilder((String)grpcHost, (ChannelCredentials)channelCreds).maxInboundMessageSize(0x6400000);
        this.authStub = AuthServiceGrpc.newBlockingStub((Channel)unauthenticatedChannelBuilder.intercept(new ClientInterceptor[]{new UnauthenticatedHeaderClientInterceptor(Map.of())}).build());
        TokenRefresher tokenRefresher = new TokenRefresher(resolvedConfig.clientId().value(), resolvedConfig.clientSecret().value(), this.authStub);
        GetTokenResponse token = tokenRefresher.getToken();
        String environmentId = resolvedConfig.environmentId().value();
        if (environmentId.isEmpty() && !token.getPrimaryEnvironment().isEmpty()) {
            environmentId = token.getPrimaryEnvironment();
        }
        if (environmentId.isEmpty()) {
            throw new IllegalArgumentException("Environment ID is required");
        }
        if (!token.containsEnvironmentIdToName(environmentId)) {
            ArrayList<String> environmentIds = new ArrayList<String>();
            for (Map.Entry<String, String> entry : token.getEnvironmentIdToNameMap().entrySet()) {
                if (!entry.getValue().equals(environmentId)) continue;
                environmentIds.add(entry.getKey());
            }
            if (environmentIds.isEmpty()) {
                throw new IllegalArgumentException("Environment name %s not found".formatted(environmentId));
            }
            if (environmentIds.size() > 1) {
                throw new IllegalArgumentException("Environment name %s is ambiguous among %s".formatted(environmentId, environmentIds));
            }
            environmentId = (String)environmentIds.get(0);
        }
        ManagedChannel authenticatedServerChannel = Grpc.newChannelBuilder((String)grpcHost, (ChannelCredentials)channelCreds).maxInboundMessageSize(0x6400000).intercept(new ClientInterceptor[]{new AuthenticatedHeaderClientInterceptor(ServerType.SERVER, Map.of(), tokenRefresher, environmentId, null)}).build();
        this.teamStub = TeamServiceGrpc.newBlockingStub((Channel)authenticatedServerChannel);
        try {
            engineHost = token.getEnginesOrThrow(environmentId).replaceFirst("^https?://", "");
        }
        catch (Exception e) {
            throw new ClientException("Error getting engine URI for environment %s".formatted(environmentId), e);
        }
        ManagedChannel authenticatedEngineChannel = Grpc.newChannelBuilder((String)engineHost, (ChannelCredentials)channelCreds).maxInboundMessageSize(524288000).intercept(new ClientInterceptor[]{new AuthenticatedHeaderClientInterceptor(ServerType.ENGINE, Map.of(), tokenRefresher, environmentId, builder.getDeploymentTag())}).build();
        this.queryStub = QueryServiceGrpc.newBlockingStub((Channel)authenticatedEngineChannel);
    }

    private QueryServiceGrpc.QueryServiceBlockingStub queryStubWithTrailers(AtomicReference<Metadata> trailersRef) {
        AtomicReference headersRef = new AtomicReference();
        return (QueryServiceGrpc.QueryServiceBlockingStub)this.queryStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newCaptureMetadataInterceptor(headersRef, trailersRef)});
    }

    @Override
    public void printConfig() {
        logger.log(System.Logger.Level.ERROR, "Config printing for GRPC client not yet implemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OnlineQueryResult onlineQuery(OnlineQueryParamsComplete params) throws ChalkException {
        byte[] bodyBytes;
        try (BufferAllocator childAllocator = this.allocator.newChildAllocator("grpc_online_query_params", 0L, 1000000000L);){
            bodyBytes = FeatherProcessor.inputsToArrowBytes(params.getInputs(), childAllocator);
        }
        catch (Exception e) {
            throw new ClientException("Failed to serialize OnlineQueryParams", e);
        }
        ArrayList<OutputExpr> outputs = new ArrayList<OutputExpr>();
        for (String string : params.getOutputs()) {
            outputs.add(OutputExpr.newBuilder().setFeatureFqn(string).build());
        }
        ArrayList<Timestamp> now = new ArrayList<Timestamp>();
        if (params.getNow() != null) {
            for (ZonedDateTime n : params.getNow()) {
                now.add(Timestamp.newBuilder().setSeconds(n.toEpochSecond()).setNanos(n.getNano()).build());
            }
        }
        OnlineQueryContext.Builder builder = OnlineQueryContext.newBuilder();
        if (params.getBranch() != null) {
            builder.setBranchId(params.getBranch());
        }
        if (params.getCorrelationId() != null) {
            builder.setCorrelationId(params.getCorrelationId());
        }
        if (params.getPreviewDeploymentId() != null) {
            builder.setDeploymentId(params.getPreviewDeploymentId());
        }
        if (params.getEnvironmentId() != null) {
            builder.setEnvironment(params.getEnvironmentId());
        }
        if (params.getQueryName() != null) {
            builder.setQueryName(params.getQueryName());
        }
        if (params.getQueryNameVersion() != null) {
            builder.setQueryNameVersion(params.getQueryNameVersion());
        }
        if (params.getTags() != null) {
            builder.addAllTags(params.getTags());
        }
        if (params.getRequiredResolverTags() != null) {
            builder.addAllRequiredResolverTags(params.getRequiredResolverTags());
        }
        OnlineQueryResponseOptions.Builder options = OnlineQueryResponseOptions.newBuilder().setIncludeMeta(params.isIncludeMeta() || params.isExplain()).setEncodingOptions(FeatureEncodingOptions.newBuilder().setEncodeStructsAsObjects(true).build());
        if (params.isExplain()) {
            options.setExplain(ExplainOptions.newBuilder().build());
        }
        if (params.getMeta() != null) {
            options.putAllMetadata(params.getMeta());
        }
        OnlineQueryBulkRequest request = OnlineQueryBulkRequest.newBuilder().setInputsFeather(ByteString.copyFrom((byte[])bodyBytes)).addAllOutputs(outputs).addAllNow(now).setBodyType(FeatherBodyType.FEATHER_BODY_TYPE_TABLE).setContext(builder).setResponseOptions(options).build();
        AtomicReference<Metadata> trailersRef = new AtomicReference<Metadata>();
        OnlineQueryBulkResponse response = this.queryStubWithTrailers(trailersRef).onlineQueryBulk(request);
        QueryMeta meta = GrpcSerializer.toQueryMeta(response.getResponseMeta(), (String)trailersRef.get().get(CHALK_TRACE_ID_KEY));
        ServerError[] errors = new ServerError[response.getErrorsCount()];
        for (int i = 0; i < response.getErrorsCount(); ++i) {
            errors[i] = GrpcSerializer.toServerError(response.getErrors(i));
        }
        Table scalars = null;
        HashMap<String, Table> groups = new HashMap<String, Table>();
        BufferAllocator responseAlloc = this.allocator.newChildAllocator("grpc_online_query_response", 0L, 10000000000L);
        try {
            if (!response.getScalarsData().isEmpty()) {
                try {
                    scalars = FeatherProcessor.convertBytesToTable(response.getScalarsData().toByteArray(), responseAlloc);
                }
                catch (Exception e) {
                    throw new ClientException("Failed to convert scalar data bytes to table", e);
                }
            }
            for (Map.Entry<String, ByteString> entry : response.getGroupsDataMap().entrySet()) {
                String fqn = entry.getKey();
                try {
                    groups.put(fqn, FeatherProcessor.convertBytesToTable(entry.getValue().toByteArray(), responseAlloc));
                }
                catch (Exception e) {
                    throw new ClientException(String.format("Failed to convert bytes to table for feature '%s'", fqn), e);
                    return new OnlineQueryResult(scalars, groups, errors, meta, responseAlloc);
                }
            }
        }
        catch (Exception e) {
            if (scalars != null) {
                scalars.close();
            }
            for (Table table : groups.values()) {
                table.close();
            }
            responseAlloc.close();
        }
        return new OnlineQueryResult(scalars, groups, errors, meta, responseAlloc);
    }

    @Override
    public void close() {
        this.allocator.close();
    }
}

