/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.client;

import ai.chalk.exceptions.ServerError;
import ai.chalk.models.QueryMeta;
import ai.chalk.models.ResolverException;
import ai.chalk.protos.chalk.common.v1.ChalkError;
import ai.chalk.protos.chalk.common.v1.ChalkException;
import ai.chalk.protos.chalk.common.v1.ErrorCode;
import ai.chalk.protos.chalk.common.v1.ErrorCodeCategory;
import ai.chalk.protos.chalk.common.v1.OnlineQueryMetadata;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;

public class GrpcSerializer {
    private static final Map<ErrorCode, ai.chalk.models.ErrorCode> errorCodeMap = Map.ofEntries(Map.entry(ErrorCode.ERROR_CODE_INTERNAL_SERVER_ERROR_UNSPECIFIED, ai.chalk.models.ErrorCode.INTERNAL_SERVER_ERROR), Map.entry(ErrorCode.ERROR_CODE_PARSE_FAILED, ai.chalk.models.ErrorCode.PARSE_FAILED), Map.entry(ErrorCode.ERROR_CODE_RESOLVER_NOT_FOUND, ai.chalk.models.ErrorCode.RESOLVER_NOT_FOUND), Map.entry(ErrorCode.ERROR_CODE_INVALID_QUERY, ai.chalk.models.ErrorCode.INVALID_QUERY), Map.entry(ErrorCode.ERROR_CODE_VALIDATION_FAILED, ai.chalk.models.ErrorCode.VALIDATION_FAILED), Map.entry(ErrorCode.ERROR_CODE_RESOLVER_FAILED, ai.chalk.models.ErrorCode.RESOLVER_FAILED), Map.entry(ErrorCode.ERROR_CODE_RESOLVER_TIMED_OUT, ai.chalk.models.ErrorCode.RESOLVER_TIMED_OUT), Map.entry(ErrorCode.ERROR_CODE_UPSTREAM_FAILED, ai.chalk.models.ErrorCode.UPSTREAM_FAILED), Map.entry(ErrorCode.ERROR_CODE_UNAUTHENTICATED, ai.chalk.models.ErrorCode.UNAUTHENTICATED), Map.entry(ErrorCode.ERROR_CODE_UNAUTHORIZED, ai.chalk.models.ErrorCode.UNAUTHORIZED), Map.entry(ErrorCode.ERROR_CODE_CANCELLED, ai.chalk.models.ErrorCode.CANCELLED), Map.entry(ErrorCode.ERROR_CODE_DEADLINE_EXCEEDED, ai.chalk.models.ErrorCode.DEADLINE_EXCEEDED));
    private static final Map<ErrorCodeCategory, ai.chalk.models.ErrorCodeCategory> errorCategoryMap = Map.ofEntries(Map.entry(ErrorCodeCategory.ERROR_CODE_CATEGORY_NETWORK_UNSPECIFIED, ai.chalk.models.ErrorCodeCategory.NETWORK), Map.entry(ErrorCodeCategory.ERROR_CODE_CATEGORY_REQUEST, ai.chalk.models.ErrorCodeCategory.REQUEST), Map.entry(ErrorCodeCategory.ERROR_CODE_CATEGORY_FIELD, ai.chalk.models.ErrorCodeCategory.FIELD));

    public static ResolverException toException(ChalkException e) {
        return new ResolverException(e.getKind(), e.getMessage(), e.getStacktrace(), e.getInternalStacktrace());
    }

    public static ServerError toServerError(ChalkError e) {
        ResolverException exception = null;
        if (e.hasException()) {
            exception = GrpcSerializer.toException(e.getException());
        }
        return new ServerError(errorCodeMap.get((Object)e.getCode()), errorCategoryMap.get((Object)e.getCategory()), e.getMessage(), exception, e.getFeature(), e.getResolver());
    }

    public static QueryMeta toQueryMeta(OnlineQueryMetadata meta, String traceId) {
        ZonedDateTime queryTimestamp = null;
        if (meta.hasQueryTimestamp()) {
            Timestamp ts = meta.getQueryTimestamp();
            queryTimestamp = ZonedDateTime.ofInstant(Instant.ofEpochSecond(ts.getSeconds(), ts.getNanos()), ZoneOffset.UTC);
        }
        return new QueryMeta((double)meta.getExecutionDuration().getSeconds() + (double)meta.getExecutionDuration().getNanos() / 1.0E9, meta.getDeploymentId(), meta.getEnvironmentId(), meta.getEnvironmentName(), meta.getQueryId(), queryTimestamp, meta.getQueryHash(), traceId);
    }
}

