/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.arrow;

import ai.chalk.internal.arrow.StructEntry;
import java.lang.reflect.Field;
import java.nio.channels.SeekableByteChannel;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.BitWriter;
import org.apache.arrow.vector.complex.writer.Float8Writer;
import org.apache.arrow.vector.complex.writer.LargeVarBinaryWriter;
import org.apache.arrow.vector.complex.writer.LargeVarCharWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroWriter;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.holders.TimeStampMicroHolder;
import org.apache.arrow.vector.holders.TimeStampMicroTZHolder;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;

public class FeatherProcessor {
    public static final long ALLOCATOR_SIZE_REQUEST = 1000000000L;
    public static final long ALLOCATOR_SIZE_RESPONSE = 10000000000L;
    public static final long ALLOCATOR_SIZE_ROOT = 5000000000000L;
    public static final long ALLOCATOR_SIZE_TEST = 100000000L;

    public static ArrayList<StructEntry> getEntriesFromMap(Map<String, ?> obj) {
        ArrayList<StructEntry> entries = new ArrayList<StructEntry>();
        for (Map.Entry<String, ?> entry : obj.entrySet()) {
            entries.add(new StructEntry(entry.getKey(), entry.getValue()));
        }
        return entries;
    }

    public static ArrayList<StructEntry> getEntriesFromObject(Object obj) throws Exception {
        Field[] fields;
        ArrayList<StructEntry> pairs = new ArrayList<StructEntry>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            Object value = field.get(obj);
            pairs.add(new StructEntry(field.getName(), value));
        }
        return pairs;
    }

    public static ArrayList<StructEntry> getEntries(Object obj) throws Exception {
        if (obj instanceof Map) {
            Map mapObj = (Map)obj;
            return FeatherProcessor.getEntriesFromMap(mapObj);
        }
        return FeatherProcessor.getEntriesFromObject(obj);
    }

    public static void writeValue(BaseWriter writer, Object value, BufferAllocator allocator) throws Exception {
        if (value instanceof Integer) {
            if (!(writer instanceof BigIntWriter)) {
                throw new Exception(String.format("Have `Integer` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BigIntWriter intWriter = (BigIntWriter)writer;
            intWriter.writeBigInt((long)((Integer)value).intValue());
        } else if (value instanceof Long) {
            if (!(writer instanceof BigIntWriter)) {
                throw new Exception(String.format("Have `Long` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BigIntWriter intWriter = (BigIntWriter)writer;
            intWriter.writeBigInt(((Long)value).longValue());
        } else if (value instanceof Double) {
            if (!(writer instanceof Float8Writer)) {
                throw new Exception(String.format("Have `Double` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            Float8Writer floatWriter = (Float8Writer)writer;
            floatWriter.writeFloat8(((Double)value).doubleValue());
        } else if (value instanceof String) {
            String stringValue = (String)value;
            if (!(writer instanceof LargeVarCharWriter)) {
                throw new Exception(String.format("Have `String` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            LargeVarCharWriter stringWriter = (LargeVarCharWriter)writer;
            byte[] bytesValue = stringValue.getBytes();
            try (ArrowBuf tempBuf = allocator.buffer((long)bytesValue.length);){
                tempBuf.setBytes(0L, bytesValue);
                stringWriter.writeLargeVarChar(0L, (long)bytesValue.length, tempBuf);
            }
        } else if (value instanceof Boolean) {
            if (!(writer instanceof BitWriter)) {
                throw new Exception(String.format("Have `Boolean` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BitWriter boolWriter = (BitWriter)writer;
            boolWriter.writeBit((Boolean)value != false ? 1 : 0);
        } else if (value instanceof byte[]) {
            byte[] binaryValue = (byte[])value;
            if (!(writer instanceof LargeVarBinaryWriter)) {
                throw new Exception(String.format("Have `byte[]` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            LargeVarBinaryWriter binaryWriter = (LargeVarBinaryWriter)writer;
            try (ArrowBuf tempBuf = allocator.buffer((long)binaryValue.length);){
                tempBuf.setBytes(0L, binaryValue);
                binaryWriter.writeLargeVarBinary(0L, (long)binaryValue.length, tempBuf);
            }
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDt = (ZonedDateTime)value;
            if (!(writer instanceof TimeStampMicroTZWriter)) {
                throw new Exception(String.format("Have `ZonedDateTime` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            TimeStampMicroTZWriter timestampWriter = (TimeStampMicroTZWriter)writer;
            TimeStampMicroTZHolder holder = new TimeStampMicroTZHolder();
            holder.value = zonedDt.toInstant().getEpochSecond() * 1000000L + (long)(zonedDt.getNano() / 1000);
            holder.timezone = zonedDt.getZone().toString();
            timestampWriter.write(holder);
        } else if (value instanceof LocalDateTime) {
            LocalDateTime localDt = (LocalDateTime)value;
            if (!(writer instanceof TimeStampMicroWriter)) {
                throw new Exception(String.format("Have `LocalDateTime` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            TimeStampMicroWriter timestampWriter = (TimeStampMicroWriter)writer;
            TimeStampMicroHolder holder = new TimeStampMicroHolder();
            holder.value = localDt.atZone(ZoneId.of("UTC")).toInstant().getEpochSecond() * 1000000L + (long)(localDt.getNano() / 1000);
            timestampWriter.write(holder);
        } else if (value instanceof List) {
            if (!(writer instanceof BaseWriter.ListWriter)) {
                throw new Exception(String.format("Have `List` value but mismatched writer type '%s': ", writer.getClass().getSimpleName()));
            }
            BaseWriter.ListWriter listWriter = (BaseWriter.ListWriter)writer;
            if (((List)value).size() == 0) {
                throw new Exception("Input values is an `Array` or a `List` of length 0");
            }
            Object firstItem = ((List)value).get(0);
            Object innerWriter = firstItem instanceof Integer ? listWriter.bigInt() : (firstItem instanceof Long ? listWriter.bigInt() : (firstItem instanceof Double ? listWriter.float8() : (firstItem instanceof String ? listWriter.largeVarChar() : (firstItem instanceof Boolean ? listWriter.bit() : (firstItem instanceof byte[] ? listWriter.largeVarBinary() : (firstItem instanceof ZonedDateTime ? listWriter.timeStampMicroTZ() : (firstItem instanceof LocalDateTime ? listWriter.timeStampMicro() : (firstItem instanceof List ? listWriter.list() : listWriter.struct()))))))));
            listWriter.startList();
            for (Object item : (List)value) {
                FeatherProcessor.writeValue((BaseWriter)innerWriter, item, allocator);
            }
            listWriter.endList();
        } else if (writer instanceof NullableStructWriter) {
            NullableStructWriter structWriter = (NullableStructWriter)writer;
            structWriter.start();
            for (StructEntry pair : FeatherProcessor.getEntries(value)) {
                Object fieldVal = pair.value();
                String fieldName = pair.key();
                if (fieldVal instanceof Integer) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.bigInt(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof Long) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.bigInt(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof Double) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.float8(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof String) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.largeVarChar(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof Boolean) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.bit(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof byte[]) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.largeVarBinary(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof ZonedDateTime) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.timeStampMicroTZ(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof LocalDateTime) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.timeStampMicro(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof List) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.list(fieldName), fieldVal, allocator);
                    continue;
                }
                throw new Exception("Unsupported data type: " + fieldVal.getClass().getSimpleName());
            }
            structWriter.end();
        } else if (writer instanceof UnionListWriter) {
            UnionListWriter structWriter = (UnionListWriter)writer;
            structWriter.start();
            for (StructEntry pair : FeatherProcessor.getEntries(value)) {
                Object fieldVal = pair.value();
                String fieldName = pair.key();
                if (fieldVal instanceof Integer) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.bigInt(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof Long) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.bigInt(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof Double) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.float8(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof String) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.largeVarChar(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof Boolean) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.bit(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof ZonedDateTime) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.timeStampMicroTZ(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof LocalDateTime) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.timeStampMicro(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof byte[]) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.largeVarBinary(fieldName), fieldVal, allocator);
                    continue;
                }
                if (fieldVal instanceof List) {
                    FeatherProcessor.writeValue((BaseWriter)structWriter.list(fieldName), fieldVal, allocator);
                    continue;
                }
                throw new Exception("Unsupported data type: " + fieldVal.getClass().getSimpleName());
            }
            structWriter.end();
        } else {
            throw new Exception("Unsupported data type: " + value.getClass().getSimpleName());
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] inputsToArrowBytes(Map<String, List<?>> inputs, BufferAllocator allocator) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Table getTableIfBatchSizeOne(byte[] bytes, BufferAllocator allocator) throws Exception {
        try (SeekableReadChannel seekableReadChannelBatchCounter = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(bytes));
             ArrowFileReader arrowFileReaderBatchCounter = new ArrowFileReader(seekableReadChannelBatchCounter, allocator, (CompressionCodec.Factory)new CommonsCompressionFactory());
             VectorSchemaRoot readerRootBatchCounter = arrowFileReaderBatchCounter.getVectorSchemaRoot();){
            int numBatches = 0;
            Table firstTable = null;
            while (arrowFileReaderBatchCounter.loadNextBatch()) {
                if (firstTable == null) {
                    firstTable = new Table(readerRootBatchCounter);
                }
                ++numBatches;
            }
            if (numBatches == 1) {
                Table table = firstTable;
                return table;
            }
            if (firstTable != null) {
                firstTable.close();
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Table convertBytesToTable(byte[] bytes, BufferAllocator allocator) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

