/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.request.models;

import ai.chalk.exceptions.ChalkException;
import ai.chalk.exceptions.ClientException;
import ai.chalk.exceptions.ServerError;
import ai.chalk.internal.arrow.FeatherProcessor;
import ai.chalk.internal.bytes.BytesConsumer;
import ai.chalk.models.QueryMeta;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.table.Table;

public record OnlineQueryResultFeather(Boolean hasData, Table scalarData, Map<String, Table> groupsData, ServerError[] errors, QueryMeta meta, BufferAllocator allocator) implements AutoCloseable
{
    private static final Set<String> REQUIRED_KEYS = Set.of("has_data", "scalar_data", "groups_data", "errors", "meta");

    public static OnlineQueryResultFeather fromBytes(byte[] bytes, BufferAllocator allocator) throws ChalkException {
        QueryMeta meta;
        ServerError[] errors;
        Map<String, Object> res;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mapper.registerModule((Module)new JavaTimeModule());
        try {
            res = BytesConsumer.unmarshal(bytes);
        }
        catch (Exception e) {
            throw new ClientException("failed to unmarshal bytes into OnlineQueryResultFeather", e);
        }
        StringJoiner missingKeys = new StringJoiner(", ");
        for (String key : REQUIRED_KEYS) {
            if (res.containsKey(key)) continue;
            missingKeys.add(key);
        }
        if (missingKeys.length() != 0) {
            throw new ClientException("missing keys '[%s]' in unmarshalled bytes".formatted(missingKeys.toString()));
        }
        Object errorsObj = res.get("errors");
        if (errorsObj == null) {
            errors = null;
        } else {
            if (!(errorsObj instanceof ArrayList)) {
                throw new ClientException(String.format("malformed value 'errors' in unmarshalled bytes - expected `ArrayList` or `null` found `%s`", errorsObj.getClass().getSimpleName()));
            }
            ArrayList errorsStrList = (ArrayList)errorsObj;
            errors = new ServerError[errorsStrList.size()];
            for (int i = 0; i < errorsStrList.size(); ++i) {
                Object errorStrObj = errorsStrList.get(i);
                if (!(errorStrObj instanceof String)) {
                    throw new ClientException(String.format("malformed value 'errors' in unmarshalled bytes - expected an array of `String` found an array of `%s`", errorStrObj.getClass().getSimpleName()));
                }
                String errorStr = (String)errorStrObj;
                try {
                    errors[i] = (ServerError)mapper.readValue(errorStr, ServerError.class);
                    continue;
                }
                catch (Exception e) {
                    throw new ClientException(String.format("failed to unmarshal an individual error string: %s", errorStr), e);
                }
            }
        }
        Object metaStrObj = res.get("meta");
        if (metaStrObj == null) {
            meta = null;
        } else {
            if (!(metaStrObj instanceof String)) {
                throw new ClientException(String.format("malformed value 'meta' in unmarshalled bytes - expected `String` or `null` found `%s`", metaStrObj.getClass().getSimpleName()));
            }
            String metaStr = (String)metaStrObj;
            try {
                meta = (QueryMeta)mapper.readValue(metaStr, QueryMeta.class);
            }
            catch (Exception e) {
                throw new ClientException(String.format("failed to unmarshal query meta: %s", metaStr), e);
            }
        }
        Object hasDataObj = res.get("has_data");
        if (!(hasDataObj instanceof Boolean)) {
            throw new ClientException("malformed value 'has_data' in unmarshalled bytes");
        }
        Boolean hasDataBool = (Boolean)hasDataObj;
        Table scalarData = null;
        HashMap<String, Table> groupsData = new HashMap<String, Table>();
        try {
            if (hasDataBool.booleanValue()) {
                Map<String, Object> groupsDataMap;
                Object scalarDataBytesObj = res.get("scalar_data");
                if (!(scalarDataBytesObj instanceof byte[])) {
                    throw new ClientException("malformed value 'scalar_data' in unmarshalled bytes");
                }
                byte[] scalarDataBytes = (byte[])scalarDataBytesObj;
                try {
                    scalarData = FeatherProcessor.convertBytesToTable(scalarDataBytes, allocator);
                }
                catch (Exception e) {
                    throw new ClientException("failed to convert scalar data bytes to VectorSchemaRoot", e);
                }
                Object groupsDataBytesObj = res.get("groups_data");
                if (!(groupsDataBytesObj instanceof byte[])) {
                    throw new ClientException(String.format("malformed value 'groups_data' in unmarshalled bytes - expected `byte[]` found `%s`", groupsDataBytesObj.getClass().getName()));
                }
                byte[] groupsDataBytes = (byte[])groupsDataBytesObj;
                try {
                    groupsDataMap = BytesConsumer.unmarshal(groupsDataBytes);
                }
                catch (Exception e) {
                    throw new ClientException("failed to unmarshal groups data bytes", e);
                }
                for (Map.Entry<String, Object> entry : groupsDataMap.entrySet()) {
                    String key = entry.getKey();
                    Object object = entry.getValue();
                    if (!(object instanceof byte[])) {
                        throw new ClientException(String.format("malformed value 'groups_data' in unmarshalled bytes - expected `byte[]` found `%s`", entry.getValue().getClass().getSimpleName()));
                    }
                    byte[] value = (byte[])object;
                    try {
                        Table table = FeatherProcessor.convertBytesToTable(value, allocator);
                        groupsData.put(key, table);
                    }
                    catch (Exception e) {
                        throw new ClientException(String.format("failed to convert data for has-many feature '%s' bytes to VectorSchemaRoot", key), e);
                    }
                }
            }
            return new OnlineQueryResultFeather(hasDataBool, scalarData, groupsData, errors, meta, allocator);
        }
        catch (Exception e) {
            if (scalarData != null) {
                scalarData.close();
            }
            for (Table table : groupsData.values()) {
                table.close();
            }
            allocator.close();
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.scalarData != null) {
            this.scalarData.close();
        }
        for (Table table : this.groupsData.values()) {
            table.close();
        }
        this.allocator.close();
    }
}

