/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.arrow;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Array;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.apache.arrow.vector.util.VectorSchemaRootAppender;

public class FeatherProcessor {
    private static Map<Class<?>, ArrowType> javaToArrowType = new HashMap();

    private static Object[] convertArrayElementsToObject(Object array) throws Exception {
        if (!array.getClass().isArray()) {
            throw new Exception("Value is not an array");
        }
        if (Array.getLength(array) == 0) {
            throw new Exception("Array is empty");
        }
        Object[] result = new Object[Array.getLength(array)];
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object element;
            result[i] = element = Array.get(array, i);
        }
        return result;
    }

    public static byte[] inputsToArrowBytes(Map<String, Object> inputs) throws Exception {
        int n;
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<BigIntVector> fieldVectors = new ArrayList<BigIntVector>();
        HashMap<String, Object[]> fqnToArray = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            Object[] array;
            Object value = entry.getValue();
            try {
                array = FeatherProcessor.convertArrayElementsToObject(value);
            }
            catch (Exception e) {
                throw new Exception(String.format("error converting '%s' value to array: %s", entry.getKey(), e.getMessage()));
            }
            fqnToArray.put(entry.getKey(), array);
        }
        for (Map.Entry<String, Object> entry : fqnToArray.entrySet()) {
            ArrowType arrowType = javaToArrowType.get(Array.get(entry.getValue(), 0).getClass());
            if (arrowType == null) {
                throw new Exception("Unsupported data type: " + Array.get(entry.getValue(), 0).getClass().getSimpleName());
            }
            Field field = new Field(entry.getKey(), FieldType.nullable((ArrowType)arrowType), null);
            fields.add(field);
            fieldVectors.add(switch (field.getType().getTypeID()) {
                case ArrowType.ArrowTypeID.Int -> new BigIntVector(field.getName(), (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                case ArrowType.ArrowTypeID.FloatingPoint -> {
                    ArrowType.FloatingPoint fpType = (ArrowType.FloatingPoint)field.getType();
                    if (fpType.getPrecision() == FloatingPointPrecision.SINGLE) {
                        yield new Float4Vector(field.getName(), (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                    }
                    yield new Float8Vector(field.getName(), (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                }
                case ArrowType.ArrowTypeID.Utf8 -> new VarCharVector(field.getName(), (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                case ArrowType.ArrowTypeID.Bool -> new BitVector(field.getName(), (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                default -> throw new Exception("Unsupported arrow type: " + field.getType().getTypeID());
            });
        }
        VectorSchemaRoot root = new VectorSchemaRoot(fields, fieldVectors, 0);
        boolean bl = false;
        for (Field field : fields) {
            Object[] values = (Object[])fqnToArray.get(field.getName());
            FieldVector vector = root.getVector(field.getName());
            n = values.length;
            switch (field.getType().getTypeID()) {
                case Int: {
                    int i;
                    BigIntVector intVector = (BigIntVector)vector;
                    intVector.allocateNew(values.length);
                    for (i = 0; i < values.length; ++i) {
                        intVector.set(i, Long.valueOf(values[i].toString()).longValue());
                    }
                    intVector.setValueCount(values.length);
                    break;
                }
                case FloatingPoint: {
                    int i;
                    ArrowType.FloatingPoint fpType = (ArrowType.FloatingPoint)field.getType();
                    if (fpType.getPrecision() == FloatingPointPrecision.SINGLE) {
                        Float4Vector floatVector = (Float4Vector)vector;
                        floatVector.allocateNew(values.length);
                        for (i = 0; i < values.length; ++i) {
                            floatVector.set(i, ((Float)values[i]).floatValue());
                        }
                        floatVector.setValueCount(values.length);
                        break;
                    }
                    Float8Vector doubleVector = (Float8Vector)vector;
                    doubleVector.allocateNew(values.length);
                    for (i = 0; i < values.length; ++i) {
                        doubleVector.set(i, ((Double)values[i]).doubleValue());
                    }
                    doubleVector.setValueCount(values.length);
                    break;
                }
                case Utf8: {
                    int i;
                    VarCharVector varcharVector = (VarCharVector)vector;
                    varcharVector.allocateNew(values.length);
                    for (i = 0; i < values.length; ++i) {
                        varcharVector.set(i, ((String)values[i]).getBytes());
                    }
                    varcharVector.setValueCount(values.length);
                    break;
                }
                case Bool: {
                    int i;
                    BitVector boolVector = (BitVector)vector;
                    boolVector.allocateNew(values.length);
                    for (i = 0; i < values.length; ++i) {
                        boolVector.set(i, (Boolean)values[i] != false ? 1 : 0);
                    }
                    boolVector.setValueCount(values.length);
                }
            }
        }
        root.setRowCount(n);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(out));){
                writer.start();
                writer.writeBatch();
                writer.end();
                writer.close();
                root.close();
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public static Table getTableIfBatchSizeOne(byte[] bytes) throws Exception {
        SeekableReadChannel seekableReadChannelBatchCounter = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(bytes));
        ArrowFileReader arrowFileReaderBatchCounter = new ArrowFileReader(seekableReadChannelBatchCounter, (BufferAllocator)new RootAllocator(Long.MAX_VALUE), (CompressionCodec.Factory)new CommonsCompressionFactory());
        int numBatches = 0;
        try (VectorSchemaRoot readerRootBatchCounter = arrowFileReaderBatchCounter.getVectorSchemaRoot();){
            Table firstTable = null;
            while (arrowFileReaderBatchCounter.loadNextBatch()) {
                if (firstTable == null) {
                    firstTable = new Table(readerRootBatchCounter);
                }
                ++numBatches;
            }
            if (numBatches == 1) {
                Table table = firstTable;
                return table;
            }
            if (firstTable != null) {
                firstTable.close();
            }
        }
        arrowFileReaderBatchCounter.close();
        return null;
    }

    public static Table convertBytesToTable(byte[] bytes) throws Exception {
        Table maybeSingleBatchTable = FeatherProcessor.getTableIfBatchSizeOne(bytes);
        if (maybeSingleBatchTable != null) {
            return maybeSingleBatchTable;
        }
        SeekableReadChannel seekableReadChannel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(bytes));
        ArrowFileReader arrowFileReader = new ArrowFileReader(seekableReadChannel, (BufferAllocator)new RootAllocator(Long.MAX_VALUE), (CompressionCodec.Factory)new CommonsCompressionFactory());
        try (VectorSchemaRoot readerRoot = arrowFileReader.getVectorSchemaRoot();){
            Table table;
            block14: {
                VectorSchemaRoot collectorRoot = VectorSchemaRoot.create((Schema)readerRoot.getSchema(), (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
                try {
                    collectorRoot.allocateNew();
                    while (arrowFileReader.loadNextBatch()) {
                        VectorSchemaRootAppender.append((VectorSchemaRoot)collectorRoot, (VectorSchemaRoot[])new VectorSchemaRoot[]{readerRoot});
                    }
                    Table table2 = new Table(collectorRoot);
                    arrowFileReader.close();
                    table = table2;
                    if (collectorRoot == null) break block14;
                }
                catch (Throwable throwable) {
                    if (collectorRoot != null) {
                        try {
                            collectorRoot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                collectorRoot.close();
            }
            return table;
        }
    }

    static {
        javaToArrowType.put(Byte.class, (ArrowType)new ArrowType.Int(64, true));
        javaToArrowType.put(Short.class, (ArrowType)new ArrowType.Int(64, true));
        javaToArrowType.put(Integer.class, (ArrowType)new ArrowType.Int(64, true));
        javaToArrowType.put(Long.class, (ArrowType)new ArrowType.Int(64, true));
        javaToArrowType.put(Float.class, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
        javaToArrowType.put(Double.class, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
        javaToArrowType.put(String.class, (ArrowType)ArrowType.Utf8.INSTANCE);
        javaToArrowType.put(Boolean.class, (ArrowType)ArrowType.Bool.INSTANCE);
    }
}

