/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.arrow;

import ai.chalk.exceptions.ClientException;
import ai.chalk.features.Feature;
import ai.chalk.features.FeaturesClass;
import ai.chalk.features.HasMany;
import ai.chalk.features.StructFeaturesClass;
import ai.chalk.internal.Constants;
import ai.chalk.internal.Utils;
import ai.chalk.internal.codegen.Initializer;
import ai.chalk.models.OnlineQueryResult;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.Text;

public class Unmarshaller {
    public static <T extends FeaturesClass> T[] unmarshalOnlineQueryResult(OnlineQueryResult result, Class<T> target) throws ClientException {
        try {
            FeaturesClass[] rootFeatureClasses = Unmarshaller.unmarshalTable((Table)result.getScalarsTable(), target);
            Unmarshaller.unmarshalHasMany(result.getGroupsTables(), rootFeatureClasses);
            return rootFeatureClasses;
        }
        catch (Exception e) {
            throw new ClientException("Failed to unmarshal online query result into Java classes", e);
        }
    }

    public static void unmarshalHasMany(Map<String, Table> tables, FeaturesClass[] targets) throws Exception {
        if (targets.length == 0) {
            return;
        }
        for (Map.Entry<String, Table> entry : tables.entrySet()) {
            Class<?> localClass = targets[0].getClass();
            String fqn = entry.getKey();
            Table table = entry.getValue();
            java.lang.reflect.Field hasManyField = Utils.getFieldFromFqn(targets[0].getClass(), fqn);
            Class<?> hasManyClass = Utils.getListFeatureInnerType(hasManyField);
            if (!hasManyField.isAnnotationPresent(HasMany.class)) {
                throw new Exception("Field " + fqn + " is not annotated as a has-many field");
            }
            HasMany hm = hasManyField.getAnnotation(HasMany.class);
            String localFqn = Utils.toSnakeCase(localClass.getSimpleName()) + "." + hm.localKey();
            String foreignFqn = Utils.toSnakeCase(hasManyClass.getSimpleName()) + "." + hm.foreignKey();
            FeaturesClass[] objects = Unmarshaller.unmarshalTable((Table)table, hasManyClass.asSubclass(FeaturesClass.class));
            HashMap grouped = new HashMap();
            for (FeaturesClass obj : objects) {
                java.lang.reflect.Field foreignField = Utils.getFieldFromFqn(hasManyClass, foreignFqn);
                Feature foreignKeyFeature = (Feature)foreignField.get(obj);
                if (foreignKeyFeature == null) {
                    throw new Exception("Error while grouping has-many result: foreign join key is null");
                }
                String v = foreignKeyFeature.getValue().toString();
                if (!grouped.containsKey(v)) {
                    grouped.put(v, new ArrayList());
                }
                ((List)grouped.get(v)).add(obj);
            }
            for (FeaturesClass target : targets) {
                java.lang.reflect.Field localField = Utils.getFieldFromFqn(localClass, localFqn);
                Feature localKeyFeature = (Feature)localField.get(target);
                if (localKeyFeature == null) {
                    throw new Exception("Error while grouping has-many result: local join key is null");
                }
                java.lang.reflect.Field hmField = Utils.getFieldFromFqn(target.getClass(), fqn);
                Feature hmFieldFeature = (Feature)hmField.get(target);
                String v = localKeyFeature.getValue().toString();
                if (grouped.containsKey(v)) {
                    List group = (List)grouped.get(v);
                    hmFieldFeature.setValue(group);
                    continue;
                }
                hmFieldFeature.setValue(new ArrayList());
            }
        }
    }

    public static <T extends FeaturesClass> T[] unmarshalTable(Table table, Class<T> target) throws Exception {
        ArrayList<FeaturesClass> result = new ArrayList<FeaturesClass>();
        for (Row row : table) {
            Map<String, Feature<?>> featureMap;
            FeaturesClass obj = (FeaturesClass)target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                featureMap = Initializer.initResult(obj);
            }
            catch (Exception e) {
                throw new Exception("Failed to initialize result object", e);
            }
            for (Field arrowField : table.getSchema().getFields()) {
                String fqn = arrowField.getName();
                String[] fqnsToSkip = new String[]{Constants.tsFeatureFqn};
                if (Arrays.asList(fqnsToSkip).contains(fqn)) continue;
                Feature<?> feature = featureMap.get(fqn);
                if (feature == null && arrowField.getType().getTypeID() != ArrowType.ArrowTypeID.Struct) {
                    throw new Exception(String.format("Target field not found for unmarshalling feature with FQN: '%s'", fqn));
                }
                block2 : switch (arrowField.getType().getTypeID()) {
                    case Int: {
                        ArrowType.Int castInt = (ArrowType.Int)arrowField.getFieldType().getType();
                        int bitWidth = castInt.getBitWidth();
                        if (bitWidth == 32) {
                            int val = row.getInt(fqn);
                            feature.setValue(val);
                            break;
                        }
                        if (bitWidth == 64) {
                            long val = row.getBigInt(fqn);
                            feature.setValue(val);
                            break;
                        }
                        if (bitWidth == 16) {
                            short val = row.getSmallInt(fqn);
                            feature.setValue(val);
                            break;
                        }
                        if (bitWidth == 8) {
                            byte val = row.getTinyInt(fqn);
                            feature.setValue(val);
                            break;
                        }
                        throw new Exception("Unsupported bitwidth found while converting from Arrow to Java: " + bitWidth);
                    }
                    case FloatingPoint: {
                        ArrowType.FloatingPoint castFloatingPoint = (ArrowType.FloatingPoint)arrowField.getFieldType().getType();
                        FloatingPointPrecision precision = castFloatingPoint.getPrecision();
                        if (precision == FloatingPointPrecision.SINGLE) {
                            float val2 = row.getFloat4(fqn);
                            feature.setValue(Float.valueOf(val2));
                            break;
                        }
                        if (precision == FloatingPointPrecision.DOUBLE) {
                            double val2 = row.getFloat8(fqn);
                            feature.setValue(val2);
                            break;
                        }
                        throw new Exception("Unsupported precision found while converting from Arrow to Java: " + precision);
                    }
                    case Bool: {
                        boolean boolVal = row.getBit(fqn) == 1;
                        feature.setValue(boolVal);
                        break;
                    }
                    case Utf8: {
                        String strVal = row.getVarCharObj(fqn);
                        feature.setValue(strVal);
                        break;
                    }
                    case LargeUtf8: {
                        String strVal = row.getLargeVarCharObj(fqn);
                        feature.setValue(strVal);
                        break;
                    }
                    case Date: {
                        ArrowType.Date castDate = (ArrowType.Date)arrowField.getFieldType().getType();
                        if (castDate.getUnit() == DateUnit.DAY) {
                            int epochDays = row.getDateDay(fqn);
                            feature.setValue(LocalDate.ofEpochDay(epochDays));
                            break;
                        }
                        if (castDate.getUnit() == DateUnit.MILLISECOND) {
                            long epochSeconds = row.getDateMilli(fqn);
                            Feature<?> dateMillisFeature = featureMap.get(fqn);
                            LocalDate localDate = Instant.ofEpochSecond(epochSeconds).atZone(ZoneOffset.UTC).toLocalDate();
                            dateMillisFeature.setValue(localDate);
                            break;
                        }
                        throw new Exception("Unsupported date unit found while converting from Arrow to Java: " + castDate.getUnit());
                    }
                    case Timestamp: {
                        ArrowType.Timestamp cast = (ArrowType.Timestamp)arrowField.getFieldType().getType();
                        String timezone = cast.getTimezone();
                        ZoneId zoneId = null;
                        if (timezone != null) {
                            zoneId = ZoneId.of(timezone);
                        }
                        boolean hasTimezone = zoneId != null;
                        switch (cast.getUnit()) {
                            case SECOND: {
                                long epochSeconds;
                                if (hasTimezone) {
                                    epochSeconds = row.getTimeStampSecTZ(fqn);
                                    feature.setValue(Instant.ofEpochSecond(epochSeconds).atZone(zoneId));
                                    break block2;
                                }
                                epochSeconds = row.getTimeStampSec(fqn);
                                feature.setValue(Instant.ofEpochSecond(epochSeconds).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                            case MILLISECOND: {
                                long epochMilli;
                                if (hasTimezone) {
                                    epochMilli = row.getTimeStampMilliTZ(fqn);
                                    feature.setValue(Instant.ofEpochMilli(epochMilli).atZone(zoneId));
                                    break block2;
                                }
                                epochMilli = row.getTimeStampMilli(fqn);
                                feature.setValue(Instant.ofEpochMilli(epochMilli).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                            case MICROSECOND: {
                                long epochNanoRemainder;
                                long epochSecondsTruncated;
                                long epochMicro;
                                if (hasTimezone) {
                                    epochMicro = row.getTimeStampMicroTZ(fqn);
                                    epochSecondsTruncated = epochMicro / 1000000L;
                                    epochNanoRemainder = epochMicro % 1000000L * 1000L;
                                    feature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(zoneId));
                                    break block2;
                                }
                                epochMicro = row.getTimeStampMicro(fqn);
                                epochSecondsTruncated = epochMicro / 1000000L;
                                epochNanoRemainder = epochMicro % 1000000L * 1000L;
                                Feature<?> timestampFeature = featureMap.get(fqn);
                                timestampFeature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                            case NANOSECOND: {
                                long epochNano;
                                long epochNanoRemainder;
                                long epochSecondsTruncated;
                                if (hasTimezone) {
                                    epochNano = row.getTimeStampNanoTZ(fqn);
                                    epochSecondsTruncated = epochNano / 1000000000L;
                                    epochNanoRemainder = epochNano % 1000000000L;
                                    feature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(zoneId));
                                    break block2;
                                }
                                epochNano = row.getTimeStampNano(fqn);
                                epochSecondsTruncated = epochNano / 1000000000L;
                                epochNanoRemainder = epochNano % 1000000000L;
                                feature.setValue(Instant.ofEpochSecond(epochSecondsTruncated, epochNanoRemainder).atZone(ZoneOffset.UTC).toLocalDateTime());
                                break block2;
                            }
                        }
                        throw new Exception("Unsupported timestamp unit found while converting from Arrow to Java: " + cast.getUnit());
                    }
                    case Struct: {
                        Object structObj = row.getStruct(fqn);
                        Unmarshaller.unmarshalNested((HashMap)structObj, featureMap, fqn);
                        break;
                    }
                    case List: 
                    case LargeList: {
                        List originalList;
                        if (arrowField.getType().getTypeID() == ArrowType.ArrowTypeID.LargeList) {
                            LargeListVector largeListVector = (LargeListVector)table.getVectorCopy(fqn);
                            originalList = largeListVector.getObject(row.getRowNumber());
                        } else {
                            originalList = row.getList(fqn);
                        }
                        ArrayList<Object> resultList = new ArrayList<Object>();
                        for (Object rawObj : originalList) {
                            if (rawObj instanceof Text) {
                                resultList.add(rawObj.toString());
                                continue;
                            }
                            if (rawObj instanceof Map) {
                                Class<?> dataclass;
                                try {
                                    java.lang.reflect.Field field = Utils.getFieldFromFqn(target, fqn);
                                    dataclass = Utils.getListFeatureInnerType(field);
                                }
                                catch (Exception e) {
                                    throw new Exception("Could not get the inner type of list feature: " + fqn, e);
                                }
                                StructFeaturesClass dataclassInstance = (StructFeaturesClass)dataclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                Map<String, Feature<?>> dataclassFeatureMap = Initializer.initResult(dataclassInstance);
                                for (Map.Entry entry : ((Map)rawObj).entrySet()) {
                                    String dataclassRootFqn = Utils.toSnakeCase(dataclass.getSimpleName());
                                    String childFqn = dataclassRootFqn + "." + (String)entry.getKey();
                                    Object value = entry.getValue();
                                    if (value instanceof Map) {
                                        Unmarshaller.unmarshalNested((Map)value, dataclassFeatureMap, childFqn);
                                        continue;
                                    }
                                    Feature<?> childFeature = dataclassFeatureMap.get(childFqn);
                                    childFeature.setValue(value);
                                }
                                resultList.add(dataclassInstance);
                                continue;
                            }
                            resultList.add(rawObj);
                        }
                        feature.setValue(resultList);
                        break;
                    }
                    case Duration: {
                        Duration duration = row.getDurationObj(fqn);
                        feature.setValue(Duration.ofSeconds(duration.getSeconds(), duration.getNano()));
                        break;
                    }
                    case Time: {
                        ArrowType.Time cast = (ArrowType.Time)arrowField.getFieldType().getType();
                        switch (cast.getUnit()) {
                            case SECOND: {
                                int time = row.getTimeSec(fqn);
                                feature.setValue(LocalTime.ofSecondOfDay(time));
                                break block2;
                            }
                            case MILLISECOND: {
                                int time = row.getTimeMilli(fqn);
                                feature.setValue(LocalTime.ofNanoOfDay((long)time * 1000000L));
                                break block2;
                            }
                            case MICROSECOND: {
                                long time = row.getTimeMicro(fqn);
                                feature.setValue(LocalTime.ofNanoOfDay(time * 1000L));
                                break block2;
                            }
                            case NANOSECOND: {
                                long time = row.getTimeNano(fqn);
                                feature.setValue(LocalTime.ofNanoOfDay(time));
                                break block2;
                            }
                        }
                        throw new Exception("Unsupported time unit found while converting from Arrow to Java: " + cast.getUnit());
                    }
                    default: {
                        throw new Exception("Unsupported type found while unmarshalling Arrow Table: " + arrowField.getType().getTypeID());
                    }
                }
            }
            result.add(obj);
        }
        return (FeaturesClass[])Utils.listToArray(result, target);
    }

    private static void unmarshalNested(Map<String, Object> struct, Map<String, Feature<?>> featureMap, String fqn) {
        for (Map.Entry<String, Object> entry : struct.entrySet()) {
            String childFqn = fqn + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Unmarshaller.unmarshalNested((Map)value, featureMap, childFqn);
                continue;
            }
            Feature<?> childFeature = featureMap.get(childFqn);
            childFeature.setValue(value);
        }
    }
}

