/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.bytes;

import ai.chalk.internal.arrow.FeatherProcessor;
import ai.chalk.models.OnlineQueryParamsComplete;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class BytesProducer {
    public static byte[] convertOnlineQueryParamsToBytes(OnlineQueryParamsComplete params) throws Exception {
        byte[] arrowBytes;
        if (params.getInputs() == null) {
            throw new Exception("`inputs` cannot be null - please use OnlineQueryParams.builder().input(...).build()");
        }
        if (params.getOutputs() == null) {
            throw new Exception("`outputs` cannot be null - please use OnlineQueryParams.builder().outputs(...).build()");
        }
        try {
            arrowBytes = FeatherProcessor.inputsToArrowBytes(params.getInputs());
        }
        catch (Exception e) {
            throw new Exception("failed to convert inputs to Arrow bytes", e);
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        DataOutputStream ioWriter = new DataOutputStream(result);
        String magicString = "chal1";
        byte[] magicStringBytes = magicString.getBytes(StandardCharsets.UTF_8);
        ioWriter.write(magicStringBytes);
        byte[] placeholder = new byte[8];
        Map<String, List<String>> jsonHeader = Map.of("outputs", params.getOutputs());
        byte[] jsonBytes = new ObjectMapper().writeValueAsBytes(jsonHeader);
        ioWriter.write(placeholder);
        ioWriter.write(jsonBytes);
        ioWriter.write(placeholder);
        ioWriter.write(arrowBytes);
        ioWriter.flush();
        byte[] resultBytes = result.toByteArray();
        int nonBodyLength = magicStringBytes.length + 8 + jsonBytes.length + 8;
        int bodyLength = resultBytes.length - nonBodyLength;
        ByteBuffer wrapped = ByteBuffer.wrap(resultBytes).order(ByteOrder.BIG_ENDIAN);
        wrapped.putLong(magicStringBytes.length, jsonBytes.length);
        wrapped.putLong(magicStringBytes.length + 8 + jsonBytes.length, bodyLength);
        return wrapped.array();
    }
}

