/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.models;

import ai.chalk.features.Feature;
import ai.chalk.features.StructFeaturesClass;
import ai.chalk.features.WindowedFeaturesClass;
import ai.chalk.internal.Utils;
import ai.chalk.models.OnlineQueryParamsComplete;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OnlineQueryParams {
    private Map<String, Object> inputs;
    private List<String> outputs;
    private Map<String, Duration> staleness;
    private Map<String, String> meta;
    private List<String> tags;
    private boolean includeMeta;
    private boolean includeMetrics;
    private String environmentId;
    private String previewDeploymentId;
    private String queryName;
    private String correlationId;
    private String branch;

    public static BuilderSeed builder() {
        return new BuilderSeed();
    }

    public OnlineQueryParams(Map<String, Object> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean includeMetrics, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.staleness = staleness;
        this.meta = meta;
        this.tags = tags;
        this.includeMeta = includeMeta;
        this.includeMetrics = includeMetrics;
        this.environmentId = environmentId;
        this.previewDeploymentId = previewDeploymentId;
        this.queryName = queryName;
        this.correlationId = correlationId;
        this.branch = branch;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public List<String> getOutputs() {
        return this.outputs;
    }

    public Map<String, Duration> getStaleness() {
        return this.staleness;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean isIncludeMeta() {
        return this.includeMeta;
    }

    public boolean isIncludeMetrics() {
        return this.includeMetrics;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getPreviewDeploymentId() {
        return this.previewDeploymentId;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getBranch() {
        return this.branch;
    }

    public static class BuilderSeed
    extends Builder<BuilderSeed> {
        public BuilderSeed(Map<String, Object> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean includeMetrics, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, includeMetrics, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        public BuilderWithInputs newBuilderWithInputs() {
            return new BuilderWithInputs(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.includeMetrics, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderWithOutputs newBuilderWithOutputs() {
            return new BuilderWithOutputs(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.includeMetrics, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderWithInputs withInput(String fqn, Object ... values) {
            return this.newBuilderWithInputs().withInput(fqn, values);
        }

        public BuilderWithInputs withInputs(Map<String, Object> inputs) {
            return this.newBuilderWithInputs().withInputs(inputs);
        }

        @SafeVarargs
        public final <T> BuilderWithInputs withInput(Feature<T> feature, T ... value) {
            return this.newBuilderWithInputs().withInput(feature, value);
        }

        public BuilderWithOutputs withOutputs(String ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(Feature<?> ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(WindowedFeaturesClass ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(StructFeaturesClass ... outputs) {
            return this.newBuilderWithOutputs().withOutputs(outputs);
        }

        public BuilderSeed() {
        }
    }

    public static class BuilderWithOutputs
    extends Builder<BuilderWithOutputs> {
        public BuilderWithOutputs(Map<String, Object> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean includeMetrics, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, includeMetrics, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        public BuilderComplete newBuilderComplete() {
            return new BuilderComplete(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.includeMetrics, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderComplete withInput(String fqn, Object ... values) {
            return (BuilderComplete)this.newBuilderComplete()._withInput(fqn, values);
        }

        @SafeVarargs
        public final <T> BuilderComplete withInput(Feature<T> feature, T ... values) {
            return (BuilderComplete)this.newBuilderComplete()._withInput(feature.getFqn(), values);
        }

        public final <T> BuilderComplete withInputs(Map<String, Object> inputs) {
            return (BuilderComplete)this.newBuilderComplete()._withInputs(inputs);
        }

        public BuilderWithOutputs withOutputs(String ... outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(Feature<?> ... outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(WindowedFeaturesClass ... outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }

        public BuilderWithOutputs withOutputs(StructFeaturesClass ... outputs) {
            return (BuilderWithOutputs)this._withOutputs(outputs);
        }
    }

    public static class BuilderWithInputs
    extends Builder<BuilderWithInputs> {
        public BuilderWithInputs(Map<String, Object> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean includeMetrics, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, includeMetrics, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        private BuilderComplete newBuilderComplete() {
            return new BuilderComplete(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.includeMetrics, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public BuilderWithInputs withInput(String fqn, Object ... values) {
            return (BuilderWithInputs)this._withInput(fqn, values);
        }

        public BuilderWithInputs withInputs(Map<String, Object> inputs) {
            return (BuilderWithInputs)this._withInputs(inputs);
        }

        @SafeVarargs
        public final <T> BuilderWithInputs withInput(Feature<T> feature, T ... values) {
            return (BuilderWithInputs)this._withInput(feature.getFqn(), values);
        }

        public BuilderComplete withOutputs(String ... outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(Feature<?> ... outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(WindowedFeaturesClass ... outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(StructFeaturesClass ... outputs) {
            return (BuilderComplete)this.newBuilderComplete()._withOutputs(outputs);
        }
    }

    public static class BuilderComplete
    extends Builder<BuilderComplete> {
        public BuilderComplete(Map<String, Object> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean includeMetrics, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            super(inputs, outputs, staleness, meta, tags, includeMeta, includeMetrics, environmentId, previewDeploymentId, queryName, correlationId, branch);
        }

        public BuilderComplete withInput(String fqn, Object ... values) {
            return (BuilderComplete)this._withInput(fqn, values);
        }

        public BuilderComplete withInputs(Map<String, Object> inputs) {
            return (BuilderComplete)this._withInputs(inputs);
        }

        @SafeVarargs
        public final <T> BuilderComplete withInput(Feature<T> feature, T ... values) {
            return (BuilderComplete)this._withInput(feature.getFqn(), values);
        }

        public BuilderComplete withOutputs(String ... outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(Feature<?> ... outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(WindowedFeaturesClass ... outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        public BuilderComplete withOutputs(StructFeaturesClass ... outputs) {
            return (BuilderComplete)this._withOutputs(outputs);
        }

        @Override
        public OnlineQueryParamsComplete build() {
            return new OnlineQueryParamsComplete(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.includeMetrics, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }
    }

    public static class Builder<T extends Builder<T>> {
        protected Map<String, Object> inputs;
        protected List<String> outputs;
        protected Map<String, Duration> staleness;
        protected Map<String, String> meta;
        protected List<String> tags;
        protected boolean includeMeta;
        protected boolean includeMetrics;
        protected String environmentId;
        protected String previewDeploymentId;
        protected String queryName;
        protected String correlationId;
        protected String branch;

        protected T _withInput(String fqn, Object ... values) {
            if (this.inputs == null) {
                this.inputs = new HashMap<String, Object>();
            }
            if (values.length == 1 && values[0].getClass().isArray()) {
                values = Utils.convertToArrayOfObjects(values[0]);
            }
            this.inputs.put(fqn, values);
            return (T)this;
        }

        public <K> T _withInput(Feature<K> feature, K ... value) {
            return this._withInput(feature.getFqn(), (Object[])value);
        }

        protected T _withInputs(Map<String, Object> inputs) {
            if (this.inputs == null) {
                this.inputs = new HashMap<String, Object>();
            }
            this.inputs.putAll(inputs);
            return (T)this;
        }

        protected T _withOutputs(String ... outputs) {
            if (this.outputs == null) {
                this.outputs = new ArrayList<String>();
            }
            this.outputs.addAll(Arrays.asList(outputs));
            return (T)this;
        }

        public T _withOutputs(Feature<?> ... outputs) {
            String[] outputFqns = new String[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                outputFqns[i] = outputs[i].getFqn();
            }
            return this._withOutputs(outputFqns);
        }

        public T _withOutputs(WindowedFeaturesClass ... outputs) {
            String[] outputFqns = new String[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                outputFqns[i] = outputs[i].getFqn();
            }
            return this._withOutputs(outputFqns);
        }

        public T _withOutputs(StructFeaturesClass ... outputs) {
            String[] outputFqns = new String[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                outputFqns[i] = outputs[i].getFqn();
            }
            return this._withOutputs(outputFqns);
        }

        public T withStaleness(Object ... staleness) {
            if (this.staleness == null) {
                this.staleness = new HashMap<String, Duration>();
            }
            if (staleness.length % 2 != 0) {
                throw new IllegalArgumentException("staleness must be an even number of alternating keys and values");
            }
            for (int i = 0; i < staleness.length; i += 2) {
                if (!(staleness[i] instanceof String)) {
                    throw new IllegalArgumentException("staleness must be an even number of alternating keys and values");
                }
                this.staleness.put((String)staleness[i], (Duration)staleness[i + 1]);
            }
            return (T)this;
        }

        public T withMeta(String key, String value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, String>();
            }
            this.meta.put(key, value);
            return (T)this;
        }

        public T withTags(Object ... tags) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            if (tags.length == 1 && tags[0] instanceof List) {
                this.tags.addAll((List)tags[0]);
            } else {
                for (Object tag : tags) {
                    this.tags.add((String)tag);
                }
            }
            return (T)this;
        }

        public T withTag(String tag) {
            return this.withTags(tag);
        }

        public T withIncludeMeta(boolean includeMeta) {
            this.includeMeta = includeMeta;
            return (T)this;
        }

        public T withIncludeMetrics(boolean includeMetrics) {
            this.includeMetrics = includeMetrics;
            return (T)this;
        }

        public T withEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
            return (T)this;
        }

        public T withPreviewDeploymentId(String previewDeploymentId) {
            this.previewDeploymentId = previewDeploymentId;
            return (T)this;
        }

        public T withQueryName(String queryName) {
            this.queryName = queryName;
            return (T)this;
        }

        public T withCorrelationId(String correlationId) {
            this.correlationId = correlationId;
            return (T)this;
        }

        public T withBranch(String branch) {
            this.branch = branch;
            return (T)this;
        }

        public OnlineQueryParams build() {
            return new OnlineQueryParams(this.inputs, this.outputs, this.staleness, this.meta, this.tags, this.includeMeta, this.includeMetrics, this.environmentId, this.previewDeploymentId, this.queryName, this.correlationId, this.branch);
        }

        public Builder(Map<String, Object> inputs, List<String> outputs, Map<String, Duration> staleness, Map<String, String> meta, List<String> tags, boolean includeMeta, boolean includeMetrics, String environmentId, String previewDeploymentId, String queryName, String correlationId, String branch) {
            this.inputs = inputs;
            this.outputs = outputs;
            this.staleness = staleness;
            this.meta = meta;
            this.tags = tags;
            this.includeMeta = includeMeta;
            this.includeMetrics = includeMetrics;
            this.environmentId = environmentId;
            this.previewDeploymentId = previewDeploymentId;
            this.queryName = queryName;
            this.correlationId = correlationId;
            this.branch = branch;
        }

        public Builder() {
        }
    }
}

