/*
 * Decompiled with CFR 0.152.
 */
package ai.chalk.internal.bytes;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class BytesConsumer {
    private static final String MAGIC_STR = "CHALK_BYTE_TRANSMISSION";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static byte[] intToEightBytes(int value) {
        return new byte[]{0, 0, 0, 0, (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static ConsumptionResult<Long> consume8ByteLen(int startIdx, byte[] bytes) throws Exception {
        int numBytesThatRepresentsLength = 8;
        BytesConsumer.checkLen(startIdx, bytes, numBytesThatRepresentsLength);
        long length = ByteBuffer.wrap(bytes, startIdx, numBytesThatRepresentsLength).order(ByteOrder.BIG_ENDIAN).getLong();
        return new ConsumptionResult<Long>(startIdx + numBytesThatRepresentsLength, length);
    }

    private static int consumeMagicStr(int startIdx, byte[] bytes) throws Exception {
        byte[] magicBytes = MAGIC_STR.getBytes();
        BytesConsumer.checkLen(startIdx, bytes, magicBytes.length);
        for (byte b : magicBytes) {
            if (bytes[startIdx++] == b) continue;
            throw new Exception("Magic string bytes do not match");
        }
        return startIdx;
    }

    private static ConsumptionResult<Map<String, Object>> consumeJsonAttrs(int startIdx, byte[] bytes) throws Exception {
        ConsumptionResult<Long> lengthResult = BytesConsumer.consume8ByteLen(startIdx, bytes);
        Map jsonBody = (Map)mapper.readValue(bytes, lengthResult.getIndex(), lengthResult.getResult().intValue(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        return new ConsumptionResult<Map<String, Object>>(lengthResult.getIndex() + lengthResult.getResult().intValue(), jsonBody);
    }

    private static ConsumptionResult<Map<String, Object>> consumePydanticAttrs(int startIdx, byte[] bytes) throws Exception {
        return BytesConsumer.consumeJsonAttrs(startIdx, bytes);
    }

    private static ConsumptionResult<Map<String, byte[]>> consumeByteItemsData(int startIdx, byte[] bytes, Map<String, Integer> byteItemsMap) throws Exception {
        HashMap<String, byte[]> byteItems = new HashMap<String, byte[]>();
        int idx = startIdx;
        for (Map.Entry<String, Integer> entry : byteItemsMap.entrySet()) {
            String key = entry.getKey();
            int length = entry.getValue();
            BytesConsumer.checkLen(idx, bytes, length);
            byte[] itemBytes = new byte[length];
            System.arraycopy(bytes, idx, itemBytes, 0, length);
            byteItems.put(key, itemBytes);
            idx += length;
        }
        return new ConsumptionResult<Map<String, byte[]>>(idx, byteItems);
    }

    private static ConsumptionResult<Map<String, byte[]>> consumeByteItems(int startIdx, byte[] bytes) throws Exception {
        ConsumptionResult<Map<String, Object>> byteItemsMapResult = BytesConsumer.consumeJsonAttrs(startIdx, bytes);
        HashMap<String, Integer> byteItemsMapInt = new HashMap<String, Integer>();
        Map<String, Object> byteItemsMap = byteItemsMapResult.getResult();
        for (Map.Entry<String, Object> entry : byteItemsMap.entrySet()) {
            byteItemsMapInt.put(entry.getKey(), (Integer)entry.getValue());
        }
        return BytesConsumer.consumeByteItemsData(byteItemsMapResult.getIndex(), bytes, byteItemsMapInt);
    }

    private static void checkLen(int startIdx, byte[] bytes, int length) throws Exception {
        if (bytes.length < startIdx + length) {
            throw new Exception("Failed to find enough bytes to consume");
        }
    }

    public static Map<String, Object> unmarshal(byte[] body) throws Exception {
        ConsumptionResult<Map<String, byte[]>> deserializableByteItemsResult;
        ConsumptionResult<Map<String, byte[]>> byteItemsResult;
        ConsumptionResult<Map<String, Object>> pydanticJsonBodyResult;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int idx = BytesConsumer.consumeMagicStr(0, body);
        ConsumptionResult<Map<String, Object>> jsonBodyResult = BytesConsumer.consumeJsonAttrs(idx, body);
        if (jsonBodyResult.getResult() != null) {
            result.putAll(jsonBodyResult.getResult());
        }
        if ((pydanticJsonBodyResult = BytesConsumer.consumePydanticAttrs(idx = jsonBodyResult.getIndex(), body)).getResult() != null) {
            result.putAll(pydanticJsonBodyResult.getResult());
        }
        if ((byteItemsResult = BytesConsumer.consumeByteItems(idx = pydanticJsonBodyResult.getIndex(), body)).getResult() != null) {
            result.putAll(byteItemsResult.getResult());
        }
        if ((deserializableByteItemsResult = BytesConsumer.consumeByteItems(idx = byteItemsResult.getIndex(), body)).getResult() != null) {
            result.putAll(deserializableByteItemsResult.getResult());
        }
        return result;
    }

    public static class ConsumptionResult<T> {
        private final int index;
        private final T result;

        public int getIndex() {
            return this.index;
        }

        public T getResult() {
            return this.result;
        }

        public ConsumptionResult(int index, T result) {
            this.index = index;
            this.result = result;
        }
    }
}

